import pandas as pd
import matplotlib.pyplot as plt
import numpy as np
import matplotlib.dates as mdates

# Lista de archivos CSV
archivos_csv = [ 'EURUSD1H_from_02_of_2023_.csv',
                 'EURUSD1H_from_02_of_2022_.csv',
                 'EURUSD1H_from_02_of_2021_.csv',
                 'EURUSD1H_from_02_of_2020_.csv',
                 'EURUSD1H_from_02_of_2019_.csv',
                 'EURUSD1H_from_02_of_2018_.csv',
                 'EURUSD1H_from_02_of_2017_.csv',
                 'EURUSD1H_from_02_of_2016_.csv',
                 'EURUSD1H_from_02_of_2015_.csv']

# Crear una figura y un eje
fig, ax = plt.subplots()

suma_df = pd.DataFrame()

# Iterar sobre cada archivo CSV
for archivo in archivos_csv:
    # Leer el archivo CSV
    df = pd.read_csv(archivo)
    
    # Asegurarse de que 'ohlc' es numérico
    df['ohlc'] = pd.to_numeric(df['close'], errors='coerce')

    # Asumiendo que 'date' es el nombre de tu columna de fecha
    df['date'] = pd.to_datetime(df['time'])

    # Establecer 'date' como el índice del DataFrame
    df.set_index('date', inplace=True)

    # Filtrar para excluir las fechas de diciembre
    df = df[~(df.index.month == 12)]

    # Crear una nueva columna 'week_day' que combina la semana y el día de la semana
    df['week_day'] = df.index.isocalendar().week.astype(str) + '.' + df.index.weekday.astype(str)

    # Ordenar el DataFrame por 'week_day'
    df.sort_values('week_day', inplace=True)

    df['week_day'] = df['week_day'].astype(float)

    # Graficar 'ohlc' de este archivo CSV
    ax.plot(df['week_day'], df['ohlc'], label=archivo)
    # Convertir 'week_day' a formato numérico


    # Sumar 'ohlc' a 'suma_df'
    if suma_df.empty:
        suma_df = df[['week_day', 'ohlc']]
    else:
        suma_df = pd.concat([suma_df, df[['week_day', 'ohlc']]])

# Agrupar por 'week_day' y calcular el promedio de 'ohlc'
promedio_df = suma_df.groupby('week_day').mean()

# Graficar el promedio de 'ohlc'
ax.plot(promedio_df.index, promedio_df['ohlc'], label='Promedio', color='black', linewidth=3)

# Configurar las marcas del eje x para que sean cada día de cada semana
ax.xaxis.set_major_locator(plt.MaxNLocator(7*53))

# Girar las marcas del eje x para una mejor visualización
plt.xticks(rotation=45)

# Mostrar la leyenda y el gráfico
plt.legend(loc='best',prop={'size': 6})
plt.show()

