import statsmodels.api as sm
import pandas as pd

x=pd.read_csv("seasonal_feb_concat_v2.csv")

x=pd.DataFrame(x)
# Convert 'Time' column to datetime format
x['time'] = pd.to_datetime(x['time'])

# Set 'Time' column as the index
x.set_index('time', inplace=True)

ohlc_data = x.resample('1H').agg({'Bid_Bid': 'first', 'Ask_Ask': 'first', 'close': 'ohlc'})
ohlc_data.columns = ohlc_data.columns.map('_'.join)
ohlc_data.rename(columns={'close_open': 'open', 'close_high': 'high', 'close_low': 'low', 'close_close': 'close'}, inplace=True)
ohlc_data.dropna(inplace=True)
# Reset the index to have a separate 'Time' column
ohlc_data.reset_index(inplace=True)
# Display the resulting OHLC data
ohlc_data = ohlc_data.dropna()

ohlc_data.dropna()
x_close=pd.DataFrame()
ohlc_data = pd.DataFrame(ohlc_data)
x_close = ohlc_data['close']

x_list=x_close.values.tolist()

# Calculate autocorrelations
autocorrelations = sm.tsa.acf(x_list)
print(autocorrelations)

