//+------------------------------------------------------------------+
//|                                                      NewsRSS.mq4 |
//|                        Copyright  2011, http://all-webmoney.com |
//|                                          http://all-webmoney.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, http://all-webmoney.com"
#property link      "http://all-webmoney.com"

#include <HTMLTagsLib.mqh>
#include <WinUser32.mqh>

#import "wininet.dll"
  int InternetAttemptConnect(int x);
  int InternetOpenA(string sAgent, int lAccessType, 
                    string sProxyName = "", string sProxyBypass = "", 
                    int lFlags = 0);
  int InternetOpenUrlA(int hInternetSession, string sUrl, 
                       string sHeaders = "", int lHeadersLength = 0,
                       int lFlags = 0, int lContext = 0);
  int InternetReadFile(int hFile, int& sBuffer[], int lNumBytesToRead, 
                       int& lNumberOfBytesRead[]);
  int InternetCloseHandle(int hInet);
#import

extern string rssUrl = "http://www.forexfactory.com/ffcal_week_this.xml";

string webResData[];

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   
   string webRss = ReadWebResource(rssUrl);
   int i, stringsCount = ArrayFromString(webResData, webRss, ">");      
            
   string tags[];    // array for storing the tags
   int startPos[][2];// tag start coordinates
   int endPos[][2];  // tag end coordinates
   
   FillTagStructure(tags, startPos, endPos, webResData);
   int tagsNumber = ArraySize(tags);
   
   string text = "";
   string currTag;
   int start[1][2];
   int end[1][2];
  
   for (i = 0; i < tagsNumber; i++)
      {
      currTag = tags[i];     

      if (currTag == "<weeklyevents>")
         {
            Print("News block start;");
         }

      if (currTag == "<event>")
         {
            text = "";
            start[0][0] = -1;
            start[0][1] = -1;
         
         }

      
      if (currTag == "<title>")
         {// coordinates of the initial position for selecting the content between the tags
            start[0][0] = endPos[i][0];
            start[0][1] = endPos[i][1];
         }
                 
             
      if (currTag == "</title>")
         {// coordinates of the end position for selecting the content between the tags
            end[0][0] = startPos[i][0];
            end[0][1] = startPos[i][1];
            text = text + GetContent(webResData, start, end) + ";";
         }

      if (currTag == "<country>")
         {// coordinates of the initial position for selecting the content between the tags
            start[0][0] = endPos[i][0];
            start[0][1] = endPos[i][1];
         }
        
                       
      if (currTag == "</country>")
         {// coordinates of the end position for selecting the content between the tags
            end[0][0] = startPos[i][0];
            end[0][1] = startPos[i][1];
            text = text + GetContent(webResData, start, end) + " ;";
         }

      if (currTag == "</event>")
         {
            Print(text);
         }

      if (currTag == "</weeklyevents>")
         {
            Print("end of the news;");
         }

      }
  
//----
   return(0);
  }
//+------------------------------------------------------------------+
int ArrayFromString(string & webResData[], string inputStr, string divider) {   
   
   if (inputStr == "") {
     Print ("Input string is not set"); 
     return(0);
   }
   if (divider == "") {
      Print ("Separator is not set"); 
      return(0);
   }
   int i, stringCounter = 0;
   
   string tmpChar, tmpString, tmpArr[64000];   
   int inputStringLen = StringLen(inputStr);
   for (i = 0; i < inputStringLen; i++ ) {
      tmpChar = StringSubstr(inputStr, i, 1);
      tmpString = tmpString + tmpChar;
      tmpArr[stringCounter] = tmpString; 
      if (tmpChar == divider) {          
          stringCounter++;
          tmpString = "";
      }               
   }
   if (stringCounter > 0) {
      ArrayResize(webResData, stringCounter);   
      for (i = 0; i < stringCounter; i++) webResData[i] = tmpArr[i];
   }
   return (stringCounter);
}

string ReadWebResource(string url)
{
  if(!IsDllsAllowed())
  {
    Print("Using DLL should be enabled in the settings");
    return("");
  }
  int inetTr = InternetAttemptConnect(0);
  if(inetTr != 0)
  {
    Print("InternetAttemptConnect() call error");
    return("");
  }
  int hInternetSession = InternetOpenA("Microsoft Internet Explorer", 0, "", "", 0);
  if(hInternetSession <= 0)
  {
    Print("InternetOpenA() call error");
    return("");         
  }
  int hURL = InternetOpenUrlA(hInternetSession, url, "", 0, 0, 0);
  if(hURL <= 0)
  {
    Print("InternetOpenUrlA() call error");
    InternetCloseHandle(hInternetSession);
    return("");         
  }      
  int cBuffer[8192];
  int dwBytesRead[1]; 
  string tmpStr = "";
  
  while(!IsStopped())
  {
    for(int i = 0; i<8192; i++) cBuffer[i] = 0;
    bool bResult = InternetReadFile(hURL, cBuffer, 32768, dwBytesRead);
        
    if(dwBytesRead[0] == 0) break;
    string tmpText = "";   
    for(i=0; i<8192; i++)
    {
    
      tmpText = tmpText + CharToStr(cBuffer[i] & 0x000000FF);
      if(StringLen(tmpText) == dwBytesRead[0]) break;
      tmpText = tmpText + CharToStr(cBuffer[i] >> 8 & 0x000000FF);
      if(StringLen(tmpText) == dwBytesRead[0]) break;
      tmpText = tmpText + CharToStr(cBuffer[i] >> 16 & 0x000000FF);
      if(StringLen(tmpText) == dwBytesRead[0]) break;
      tmpText = tmpText + CharToStr(cBuffer[i] >> 24 & 0x000000FF);
           
      }
      tmpStr = tmpStr + tmpText; 
   }
     
  InternetCloseHandle(hInternetSession);  
  return(tmpStr);
}


