//+------------------------------------------------------------------+
//|                                            ReportHTMLtoCSV-2.mq4 |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.ru/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net/"

#define capacity  10000

#property show_inputs
//#property stacksize 1000000

//extern string filename = "StrategyTester.htm";

//+------------------------------------------------------------------+
//| print all array strings                                          |
//+------------------------------------------------------------------+
void PrintStringArray(string array[], string nameOfArray)
   {
//----
   Print("array ",nameOfArray);
   for (int i = 0; i <= ArraySize(array); i++)
      {
      Print(i, ":", array[i]);
      }
   Print("  ");
//----
   return;      
   }

//+------------------------------------------------------------------+
//| writing the file's contents to strings array[]                   |
//| return false in case of failure                                  |
//+------------------------------------------------------------------+
bool ReadFileToArray(string & array[], string FileName, string WorkFolderName)
  {
   bool res = false;
   int FileHandle;
   string tempArray[64000], currString;
   int stringCounter;
   int devider = '\x90';
   string FullFileName;
   if (StringLen(WorkFolderName) > 0) FullFileName = StringConcatenate(WorkFolderName, "\\", FileName);
   else FullFileName = FileName;
//----
   Print("Attempt to read the file ", FileName);
   FileHandle=FileOpen(FullFileName, FILE_READ, devider);
   if (FileHandle != -1)
      {
      while(!FileIsEnding(FileHandle)) 
         {
         tempArray[stringCounter] = FileReadString(FileHandle);
         stringCounter++;
         }
      stringCounter--;
      if (stringCounter > 0) 
         {
         ArrayResize(array,stringCounter);
         for (int i = 0; i < stringCounter; i++) array[i] = tempArray[i];
         res = true;
         }
      FileClose(FileHandle);   
      }
   else
      {
      Print("Failed to read the file ", FileName);
      }      
//----
   return(res);
  }


//+------------------------------------------------------------------+
//| write tag coordinates to the appropriate arrays                  |
//+------------------------------------------------------------------+
void setPositions(int & st[][], int & en[][], int counter,int stLine, int stPos, int enLine, int enPos)
   {
//----
   st[counter][0] = stLine;
   st[counter][1] = stPos;

   en[counter][0] = enLine;
   en[counter][1] = enPos;

//----
   return;
   }

//+------------------------------------------------------------------+
//|  fill the structure of tags                                      |
//+------------------------------------------------------------------+
void FillTagStructure(string  & structure[],// created structure of tags
                      int     & start[][],  // tag start (string, position)
                      int     & end[][],    // tag end (string, position)
                      string  array[])      // source html text
   {
//----
   int array_Size = ArraySize(array);
   
   ArrayResize(structure, capacity);
   ArrayResize(start, capacity);
   ArrayResize(end, capacity);
   
   int i=0, line, posOpen, pos_, posClose, tagCounter, currPos = 0;
   string currString;
   string tag;
   int curCapacity = capacity;
   while (i < array_Size)
      {
      if (tagCounter >= curCapacity)                     //  if the number of tags has exceeded 
         {                                               //  storage capacity
         ArrayResize(structure, curCapacity + capacity); //  increase storage capacity
         ArrayResize(start, curCapacity + capacity);     //  increase the size of the starting positions' array
         ArrayResize(end, curCapacity + capacity);       //  increase the size of the end positions' array       
         curCapacity += capacity;                        //  remember the new capacity
         }
      
      currString = array[i];                             // take the current string
      //Print(currString);
      posOpen = StringFind(currString, "<", currPos);    // look for the first "<" occurrence from currPos position
      if (posOpen == -1)                                 // not found
         {
         line = i;                                       // move to the next string
         currPos = 0;                                    //  search from the start in the new string
         i++;
         continue;                                       // return to the loop start
         }
         
      //  if this point is reached, "<" has been found     
      pos_ = StringFind(currString, " ", posOpen);       //  then search for space
      posClose = StringFind(currString, ">", posOpen);   //  search for the closing bracket 
      if ((pos_ == -1) && (posClose != -1))              //  there is no space but the bracket has been found
         {
         tag = StringSubstr(currString, posOpen, posClose - posOpen) + ">";
         // tag created
         structure[tagCounter] = tag;                    //  write it to the tags array
         setPositions(start, end, tagCounter, i, posOpen, i, posClose+1);
         tagCounter++;                                   //  increase the counter of found tags
         currPos = posClose;                             //  next search for the new tag starts here
         continue;                                       //   from posClose position where the closing bracket has been found
         }
         

      //   if we reached this place, both space and closing bracket have been found
      if ((pos_ != -1) && (posClose != -1))
         {
         if (pos_ > posClose)                            //  space located after the brackets
            {
            tag = StringSubstr(currString, posOpen, posClose - posOpen) + ">";
            // tag created
            structure[tagCounter] = tag;                 //  write it to the tags array
            setPositions(start, end, tagCounter, i, posOpen, i, posClose+1);
            tagCounter++;                                //  increase the counter of found tags
            currPos = posClose;                          //  next search for the new tag starts here
            continue;                                    //   from posClose position where the closing bracket has been found
            }

         //  space is located before the closing bracket
         if (pos_ < posClose)
            {
            tag = StringSubstr(currString, posOpen, pos_ - posOpen) + ">";
            // tag created
            structure[tagCounter] = tag;                 //  write it to the tags array
            setPositions(start, end, tagCounter, i, posOpen, i, posClose+1);
            tagCounter++;                                //  increase the counter of found tags
            currPos = posClose;                          //  next search for the new tag starts here
            continue;                                    //   from posClose position where the closing bracket has been found
            }
         }

      //   if we reached this place, neither space nor closing bracket have been found
      if ((pos_ == -1) && (posClose == -1))
         {
         tag = StringSubstr(currString, posOpen) + ">";  //  create the tag using present elements
         structure[tagCounter] = tag;                    //  write it to the tags array
         while (posClose == -1)                          //  and arrange the loop of searching for
            {                                            //  the first closing bracket
            i++;                                         //  increase the string counter
            currString = array[i];                       //  calculate the new string
            posClose = StringFind(currString, ">");      //  and search for the closing bracket in it
            }
         setPositions(start, end, tagCounter, i, posOpen, i, posClose+1);
         tagCounter++;                                   //  increase the counter of found tags
         currPos = posClose;                             //  it has probably been found, set the initial position
         }                                               //  for searching for the new tag
      }
   ArrayResize(structure, tagCounter);                   //  cut the size of the tags array down to the number of the found
//----                                                   //  tags
   return;   
   }
  
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
string GetContent(string array[], int start[1][2],int  end[1][2])
   {
   string res = "";
//----
   int startLine = start[0][0];
   int startPos = start[0][1];

   int endtLine = end[0][0];
   int endPos = end[0][1];
   string currString;
   
   for (int i = startLine; i<=endtLine; i++)
      {
      currString = array[i];
      if (i == startLine && endtLine > startLine)
         {
         res = res + StringSubstr(currString, startPos);
         }
      if (i > startLine && i < endtLine)
         {
         res = res + currString;
         }
         
      if (endtLine > startLine && i == endtLine)
         {
         if (endPos > 0) res = res + StringSubstr(currString, 0, endPos);
         }
         
      if (endtLine == startLine && i == endtLine)
         {
         if (endPos - startPos > 0) res = res + StringSubstr(currString, startPos, endPos - startPos);
         }
      }
//----
   return(res);   
   }  

  
//+------------------------------------------------------------------+