//+------------------------------------------------------------------+
//|                                                   TrailingCT.mqh |
//|                   Copyright 2009-2013, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertTrailing.mqh>
#include <ct_22.mqh>
#include <Math\Stat\Stat.mqh>
#define __PI 245850922/78256779
#define __PHI 0.61803398874989
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Trailing Stop based on 'Category Theory' for article 23    |
//| Type=Trailing                                                    |
//| Name=CategoryTheory                                              |
//| ShortName=CT                                                     |
//| Class=CTrailingCT                                                |
//| Page=trailing_ct                                                 |
//| Parameter=Step,double,0.5,Trailing Step                          |
//| Parameter=Transformations,int,5,Transformations Buffer           |
//| Parameter=Functor_AB_Period,int,5,Functor A Period               |
//| Parameter=Functor_CD_Period,int,21,Functor B Period              |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CTrailingCT.                                               |
//| Appointment: Class traling stops with 'Category Theory'          |
//|                for article 23.                                   |
//| Derives from class CExpertTrailing.                              |
//+------------------------------------------------------------------+
class CTrailingCT : public CExpertTrailing
  {
protected:
   //--- adjusted parameters
   double                  m_step;                // trailing step
   int                     m_transformations;
   int                     m_functor_ab;
   int                     m_functor_cd;
   //

public:
   //--- methods of setting adjustable parameters
   
   //--- method of verification of settings
   virtual bool         ValidationSettings(void);
   //--- method of creating the indicator and timeseries
   virtual bool         InitIndicators(CIndicators *indicators);
   //
   
   //--- methods of checking if the market models are formed
   virtual bool         CheckTrailingStopLong(CPositionInfo *position,double &sl,double &tp);
   virtual bool         CheckTrailingStopShort(CPositionInfo *position,double &sl,double &tp);
   //---
                        CTrailingCT(void);
                        ~CTrailingCT(void);
   //--- methods of initialization of protected data
   void                 Transformations(int value)             { m_transformations=value;    }
   void                 Functor_AB_Period(int value)           { m_functor_ab=value;         }
   void                 Functor_CD_Period(int value)           { m_functor_cd=value;         }
   
   void                 Step(double value)                     { m_step=value;               }
   //

protected:
   //--- method of initialization of the oscillator
   bool                    InitMA_A(CIndicators *indicators);
   bool                    InitMA_B(CIndicators *indicators);
   bool                    InitMA_C(CIndicators *indicators);
   bool                    InitMA_D(CIndicators *indicators);
   
   
   virtual void            Init();
   virtual void            Refresh();
   
   virtual double          GetDirection();// override;
   //--- methods of initialization of protected data
   
   CCategory               m_c_prices;
   CCategory               m_c_averages;
   
   CObjects<double>        m_o_prices;
   CObjects<double>        m_o_average_a;
   CObjects<double>        m_o_average_b;
   CObjects<double>        m_o_average_c;
   CObjects<double>        m_o_average_d;
   
   CElement<double>        m_e_price;
   
   double                  m_natural_transformations_ac[];
   double                  m_natural_transformations_bd[];
   
   bool                    m_init;
      
  };
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CTrailingCT::CTrailingCT(void) 
  {
//--- initialization of protected data
      m_used_series=USE_SERIES_TIME+USE_SERIES_SPREAD+USE_SERIES_OPEN+USE_SERIES_HIGH+USE_SERIES_LOW+USE_SERIES_CLOSE;
      
      m_init=false;
  }
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CTrailingCT::~CTrailingCT(void)
  {
  }
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CTrailingCT::ValidationSettings(void)
  {
//--- validation settings of additional filters
   if(!CExpertTrailing::ValidationSettings())
      return(false);

      
//--- ok
   return(true);
  }
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CTrailingCT::InitIndicators(CIndicators *indicators)
  {
//--- check pointer
   if(indicators==NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertTrailing::InitIndicators(indicators))
      return(false);
      
//--- ok
   return(true);
  }
//+------------------------------------------------------------------+
//| Checking trailing stop and/or profit for long position.          |
//+------------------------------------------------------------------+
bool CTrailingCT::CheckTrailingStopLong(CPositionInfo *position,double &sl,double &tp)
  {
//--- check
      if(position==NULL)
         return(false);
      
      m_high.Refresh(-1);
      m_low.Refresh(-1);
      
      m_time.Refresh(-1);
      
      int _x=StartIndex();
      
      double _a_0=0.0,_a_1=0.0;
      m_o_average_a.Get(0,m_e_price);m_e_price.Get(0,_a_0);m_e_price.Let();
      m_o_average_a.Get(1,m_e_price);m_e_price.Get(0,_a_1);m_e_price.Let();
      
      double _b_0=0.0,_b_1=0.0;
      m_o_average_b.Get(0,m_e_price);m_e_price.Get(0,_b_0);m_e_price.Let();
      m_o_average_b.Get(1,m_e_price);m_e_price.Get(0,_b_1);m_e_price.Let();
      
      double _c_0=0.0,_c_1=0.0;
      m_o_average_c.Get(0,m_e_price);m_e_price.Get(0,_c_0);m_e_price.Let();
      m_o_average_c.Get(1,m_e_price);m_e_price.Get(0,_c_1);m_e_price.Let();
      
      double _d_0=0.0,_d_1=0.0;
      m_o_average_d.Get(0,m_e_price);m_e_price.Get(0,_d_0);m_e_price.Let();
      m_o_average_d.Get(1,m_e_price);m_e_price.Get(0,_d_1);m_e_price.Let();
      
      double _trend= (_a_0-_a_1)+
                     (_b_0-_b_1)+
                     (_c_0-_c_1)+
                     (_d_0-_d_1);
                     
      if(_trend<0.0){ return(false); }
      
      double _type=0.5*(GetDirection()+1.0);
      
      double _atr=fmax(2.0*m_spread.GetData(_x)*m_symbol.Point(),m_high.GetData(_x)-m_low.GetData(_x))*(_type);
      
      double _sl=m_low.GetData(_x)-(m_step*_atr);
      
      double level =NormalizeDouble(m_symbol.Bid()-m_symbol.StopsLevel()*m_symbol.Point(),m_symbol.Digits());
      double new_sl=NormalizeDouble(_sl,m_symbol.Digits());
      double pos_sl=position.StopLoss();
      double base  =(pos_sl==0.0) ? position.PriceOpen() : pos_sl;
      
      sl=EMPTY_VALUE;
      tp=EMPTY_VALUE;
      if(new_sl>base && new_sl<level)
         sl=new_sl;
      
//---
   return(sl!=EMPTY_VALUE);
  }
//+------------------------------------------------------------------+
//| Checking trailing stop and/or profit for short position.         |
//+------------------------------------------------------------------+
bool CTrailingCT::CheckTrailingStopShort(CPositionInfo *position,double &sl,double &tp)
  {
//--- check
      if(position==NULL)
         return(false);
      
      m_high.Refresh(-1);
      m_low.Refresh(-1);
      
      m_time.Refresh(-1);
      
      int _x=StartIndex();
      
      double _a_0=0.0,_a_1=0.0;
      m_o_average_a.Get(0,m_e_price);m_e_price.Get(0,_a_0);m_e_price.Let();
      m_o_average_a.Get(1,m_e_price);m_e_price.Get(0,_a_1);m_e_price.Let();
      
      double _b_0=0.0,_b_1=0.0;
      m_o_average_b.Get(0,m_e_price);m_e_price.Get(0,_b_0);m_e_price.Let();
      m_o_average_b.Get(1,m_e_price);m_e_price.Get(0,_b_1);m_e_price.Let();
      
      double _c_0=0.0,_c_1=0.0;
      m_o_average_c.Get(0,m_e_price);m_e_price.Get(0,_c_0);m_e_price.Let();
      m_o_average_c.Get(1,m_e_price);m_e_price.Get(0,_c_1);m_e_price.Let();
      
      double _d_0=0.0,_d_1=0.0;
      m_o_average_d.Get(0,m_e_price);m_e_price.Get(0,_d_0);m_e_price.Let();
      m_o_average_d.Get(1,m_e_price);m_e_price.Get(0,_d_1);m_e_price.Let();
      
      double _trend= (_a_0-_a_1)+
                     (_b_0-_b_1)+
                     (_c_0-_c_1)+
                     (_d_0-_d_1);
                     
      if(_trend>0.0){ return(false); }
      
      double _type=0.5*(GetDirection()+1.0);
   
      double _atr=fmax(2.0*m_spread.GetData(_x)*m_symbol.Point(),m_high.GetData(_x)-m_low.GetData(_x))*(_type);
      
      double _sl=m_high.GetData(_x)+(m_step*_atr);
      
      double level =NormalizeDouble(m_symbol.Ask()+m_symbol.StopsLevel()*m_symbol.Point(),m_symbol.Digits());
      double new_sl=NormalizeDouble(_sl,m_symbol.Digits());
      double pos_sl=position.StopLoss();
      double base  =(pos_sl==0.0) ? position.PriceOpen() : pos_sl;
      
      sl=EMPTY_VALUE;
      tp=EMPTY_VALUE;
      if(new_sl<base && new_sl>level)
         sl=new_sl;
      
//---
      return(sl!=EMPTY_VALUE);
  }
//+------------------------------------------------------------------+
//| Get Direction function from Natural Transformations.             |
//+------------------------------------------------------------------+
void CTrailingCT::Init(void)
   {
      if(!m_init)
      {
         m_close.Refresh(-1);
         
         int _x=StartIndex();
         
         m_o_prices.Cardinality(m_functor_ab+m_functor_ab);
         for(int i=0;i<m_functor_ab+m_functor_ab;i++)
         {
            m_e_price.Let();m_e_price.Cardinality(1);m_e_price.Set(0,m_close.GetData(_x+i));m_o_prices.Set(i,m_e_price);
         }
         
         m_o_average_a.Cardinality(m_transformations+1);
         m_o_average_b.Cardinality(m_transformations+1);
         m_o_average_c.Cardinality(m_transformations+1);
         
         for(int i=0;i<m_transformations+1;i++)
         {
            double _a=0.0;
            for(int ii=i;ii<m_functor_ab+i;ii++)
            {
               _a+=m_close.GetData(_x+ii);
            }
            _a/=m_functor_ab;
            m_e_price.Let();m_e_price.Cardinality(1);m_e_price.Set(0,_a);m_o_average_a.Set(i,m_e_price);
            //
            double _b=0.0;
            for(int ii=i;ii<m_functor_cd+i;ii++)
            {
               _b+=m_close.GetData(_x+ii);
            }
            _b/=m_functor_cd;
            m_e_price.Let();m_e_price.Cardinality(1);m_e_price.Set(0,_b);m_o_average_b.Set(i,m_e_price);
            //
            double _c=0.0;
            for(int ii=i;ii<m_functor_ab+i;ii++)
            {
               _c+=m_close.GetData(_x+ii);
            }
            _c/=m_functor_ab;
            m_e_price.Let();m_e_price.Cardinality(1);m_e_price.Set(0,_c);m_o_average_c.Set(i,m_e_price);
            //
            double _d=0.0;
            for(int ii=i;ii<m_functor_cd+i;ii++)
            {
               _d+=m_close.GetData(_x+ii);
            }
            _d/=m_functor_cd;
            m_e_price.Let();m_e_price.Cardinality(1);m_e_price.Set(0,_d);m_o_average_d.Set(i,m_e_price);
         }
         //
         ArrayResize(m_natural_transformations_ac,m_transformations);ArrayInitialize(m_natural_transformations_ac,0.0);
         ArrayResize(m_natural_transformations_bd,m_transformations);ArrayInitialize(m_natural_transformations_bd,0.0);
         
         for(int i=m_transformations-1;i>=0;i--)
         {
            double _a=0.0;
            m_e_price.Let();m_e_price.Cardinality(1);m_o_average_a.Get(i,m_e_price);m_e_price.Get(0,_a);
            double _b=0.0;
            m_e_price.Let();m_e_price.Cardinality(1);m_o_average_b.Get(i,m_e_price);m_e_price.Get(0,_b);
            double _c=0.0;
            m_e_price.Let();m_e_price.Cardinality(1);m_o_average_c.Get(i,m_e_price);m_e_price.Get(0,_c);
            double _d=0.0;
            m_e_price.Let();m_e_price.Cardinality(1);m_o_average_d.Get(i,m_e_price);m_e_price.Get(0,_d);
            
            m_natural_transformations_ac[i]=_a-_c;
            m_natural_transformations_bd[i]=_b-_d;
         }
         
         m_init=true;
      }
   }
//+------------------------------------------------------------------+
//| Refresh function from Natural Transformations.                   |
//+------------------------------------------------------------------+
void CTrailingCT::Refresh(void)
   {
      if(!m_init)
      {
         Init();
      }
      else
      {
         m_close.Refresh(-1);
         
         int _x=StartIndex();
         
         for(int i=m_functor_ab+m_functor_ab-1;i>0;i--)
         {
            m_e_price.Let();m_e_price.Cardinality(1);m_o_prices.Get(i,m_e_price);m_o_prices.Set(i-1,m_e_price);
         }
         
         double _p=m_close.GetData(_x);
         m_e_price.Let();m_e_price.Cardinality(1);m_e_price.Set(0,_p);m_o_prices.Set(0,m_e_price);
         
         for(int i=0;i<m_transformations+1;i++)
         {
            double _a=0.0;
            for(int ii=i;ii<m_functor_ab+i;ii++)
            {
               _a+=m_close.GetData(_x+ii);
            }
            _a/=m_functor_ab;
            m_e_price.Let();m_e_price.Cardinality(1);m_e_price.Set(0,_a);m_o_average_a.Set(i,m_e_price);
            //
            double _b=0.0;
            for(int ii=i;ii<m_functor_cd+i;ii++)
            {
               m_e_price.Let();m_e_price.Cardinality(1);m_o_average_a.Get(i,m_e_price);
               double _b_i=0.0;m_e_price.Set(0,_b_i);
               _b+=_b_i;
            }
            _b/=m_functor_cd;
            m_e_price.Let();m_e_price.Cardinality(1);m_e_price.Set(0,_b);m_o_average_b.Set(i,m_e_price);
            //
            double _c=0.0;
            for(int ii=i;ii<m_functor_ab+i;ii++)
            {
               _c+=m_close.GetData(_x+ii);
            }
            _c/=m_functor_ab;
            m_e_price.Let();m_e_price.Cardinality(1);m_e_price.Set(0,_c);m_o_average_c.Set(i,m_e_price);
            //
            double _d=0.0;
            for(int ii=i;ii<m_functor_cd+i;ii++)
            {
               m_e_price.Let();m_e_price.Cardinality(1);m_o_average_c.Get(i,m_e_price);
               double _d_i=0.0;m_e_price.Set(0,_d_i);
               _d+=_d_i;
            }
            _d/=m_functor_cd;
            m_e_price.Let();m_e_price.Cardinality(1);m_e_price.Set(0,_d);m_o_average_d.Set(i,m_e_price);
         }
         
         
         for(int i=m_transformations-1;i>0;i--)
         {
            m_natural_transformations_ac[i]=m_natural_transformations_ac[i-1];
            m_natural_transformations_bd[i]=m_natural_transformations_bd[i-1];
         }
         //
         double _a=0.0;
         m_e_price.Let();m_e_price.Cardinality(1);m_o_average_a.Get(0,m_e_price);m_e_price.Get(0,_a);
         double _b=0.0;
         m_e_price.Let();m_e_price.Cardinality(1);m_o_average_b.Get(0,m_e_price);m_e_price.Get(0,_b);
         double _c=0.0;
         m_e_price.Let();m_e_price.Cardinality(1);m_o_average_c.Get(0,m_e_price);m_e_price.Get(0,_c);
         double _d=0.0;
         m_e_price.Let();m_e_price.Cardinality(1);m_o_average_d.Get(0,m_e_price);m_e_price.Get(0,_d);
         
         m_natural_transformations_ac[0]=_a-_c;
         m_natural_transformations_bd[0]=_b-_d;
      }
   }
//+------------------------------------------------------------------+
//| Get Direction function from Natural Transformations.             |
//+------------------------------------------------------------------+
double CTrailingCT::GetDirection()
   {
      double _r=0.0;
      
      Refresh();
      
      MathCorrelationSpearman(m_natural_transformations_ac,m_natural_transformations_bd,_r);
      
      return(_r);
   }
//+------------------------------------------------------------------+
