//+------------------------------------------------------------------+
//|                                                          Cct.mqh |
//|                                  Copyright 2022, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright                 "Copyright 2022, MetaQuotes Ltd."
#property link                      "https://www.mql5.com"
#property version                   "1.00"

#include                            <Object.mqh>
#include                            <Math\Stat\Math.mqh>
#define                             __PHI 0.61803398874989
//+------------------------------------------------------------------+
//| ELEMENT CLASS                                                    |
//+------------------------------------------------------------------+
template <typename T>
class CElement                      : public CObject
   {
      protected:
      
      int                           cardinal;
      T                             element[];
      
      public:
      
      bool                          Cardinality(int Value) { if(Value>=0 && Value<INT_MAX) { cardinal=Value; ArrayResize(element,cardinal); return(true); } return(false); }
      int                           Cardinality() { return(cardinal); }
      
      bool                          Get(int ElementIndex,T &Type) { if(ElementIndex>=0 && ElementIndex<Cardinality()) { Type=element[ElementIndex]; return(true); } return(false); }
      bool                          Set(int ValueIndex,T Value) { if(ValueIndex>=0 && ValueIndex<Cardinality()) { element[ValueIndex]=Value; return(true); } return(false); }
      
      void                          Let()
                                    {
                                       this.Cardinality(0);
                                    };
                                    
                                    CElement(void)
                                    {
                                       Cardinality(0);
                                    };
                                    ~CElement(void) {};
   };
//+------------------------------------------------------------------+
//| DOMAIN CLASS                                                     |
//+------------------------------------------------------------------+
template <typename T>
class CDomain                       : public CObject
   {
      protected:
      
      int                           cardinal;
      CElement<T>                   elements[];
      
      public:
      
      bool                          Cardinality(int Value) { if(Value>=0 && Value<INT_MAX) { cardinal=Value; ArrayResize(elements,cardinal); return(true); } return(false); }
      int                           Cardinality() { return(cardinal); }
      
      bool                          Get(int ElementIndex,CElement<T> &Element) { if(ElementIndex>=0 && ElementIndex<Cardinality()) { Element=elements[ElementIndex]; return(true); } return(false); }
                                    
                                    //'IsIndexed' parameter specifies value should be unique in domain which is a typical requirement
                                    //there are exceptions however, such as when swapping values (see GetIsomorphisms()), where this rule could be suspended
      bool                          Set(int ValueIndex,CElement<T> &Value,bool IsIndexed=false) 
                                    { 
                                       if(ValueIndex>=0 && ValueIndex<Cardinality()) 
                                       { 
                                          if(!IsIndexed||Index(Value)<0)
                                          { 
                                             elements[ValueIndex]=Value; 
                                             return(true); 
                                          }
                                          else
                                          { 
                                             printf(__FUNCSIG__+" value already exists. "); 
                                          } 
                                       }
                                       else
                                       { 
                                          if(ValueIndex>=0 && Cardinality()<ValueIndex+1 && ValueIndex<INT_MAX)
                                          {
                                             if(Cardinality(ValueIndex+1))
                                             {
                                                elements[ValueIndex]=Value; 
                                                return(true); 
                                             }
                                          }
                                          else
                                          {
                                             printf(__FUNCSIG__+" index: "+IntegerToString(ValueIndex)+" out of bounds in domain cardinal: "+IntegerToString(Cardinality())); 
                                          }
                                       } 
                                       
                                       return(false); 
                                    }
      
      void                          Let()
                                    {
                                       this.Cardinality(0);
                                    };
                                    
      int                           Index(CElement<T> &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int c=0; c<cardinal; c++)
                                       {
                                          if(ElementMatch(Value,elements[c]))
                                          {
                                             //printf(__FUNCSIG__+" value match at: "+IntegerToString(c)+" with value cardinality: "+IntegerToString(Value.Cardinality())+", & element cardinality: "+string(elements[c].Cardinality()));
                                             //
                                             //for(int cc=0; cc<elements[c].Cardinality(); cc++)
                                             {
                                                //printf(__FUNCSIG__+" value match at: "+IntegerToString(c)+" with value: "+string(Value.Get(cc))+", & element: "+string(elements[c].Get(cc)));
                                             }
                                             _index=c; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
                                    CDomain(void)
                                    {
                                       Cardinality(0);
                                    };
                                    ~CDomain(void) {};
   };
//+------------------------------------------------------------------+
//| MORPHISM CLASS                                                   |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
class CMorphism
   {
      protected:
      
      int                           domain_index;
      int                           codomain_index;
      
      public:
      
      CDomain<TD>                   domain;
      CDomain<TC>                   codomain;
      
      int                           Domain(){ return(domain_index); };
      bool                          Domain(int DomainIndex) 
                                    { 
                                       if(DomainIndex>=0 && DomainIndex<domain.Cardinality()) 
                                       { 
                                          domain_index=DomainIndex; return(true); 
                                       }
                                       else
                                       { 
                                          if(DomainIndex>=0 && domain.Cardinality()==0 && DomainIndex<INT_MAX)
                                          { 
                                             domain.Cardinality(DomainIndex+1); domain_index=DomainIndex; return(true); 
                                          } 
                                          else if(DomainIndex!=-1)
                                          { 
                                             printf(__FUNCSIG__+" index: "+IntegerToString(DomainIndex)+" out of bounds for domain cardinal: "+IntegerToString(domain.Cardinality())+". "); 
                                          }
                                       } 
                                       
                                       return(false); 
                                    }
      
      int                           Codomain(){ return(codomain_index); };
      bool                          Codomain(int CodomainIndex) 
                                    { 
                                       if(CodomainIndex>=0 && CodomainIndex<codomain.Cardinality()) 
                                       { 
                                          codomain_index=CodomainIndex; return(true); 
                                       }
                                       else
                                       { 
                                          if(CodomainIndex>=0 && codomain.Cardinality()==0 && CodomainIndex<INT_MAX)
                                          { 
                                             codomain.Cardinality(CodomainIndex+1); codomain_index=CodomainIndex; return(true); 
                                          } 
                                          else if(CodomainIndex!=-1)
                                          { 
                                             printf(__FUNCSIG__+" index: "+IntegerToString(CodomainIndex)+" out of bounds for codomain cardinal: "+IntegerToString(codomain.Cardinality())+". "); 
                                          } 
                                       } 
                                       
                                       return(false); 
                                    }
      
                                    template <typename TDD,typename TDC>
      bool                          Morph(CDomain<TDD> &D,CDomain<TDC> &C,int DomainIndex,int CodomainIndex)
                                    {
                                       if(DomainIndex>=0 && DomainIndex<D.Cardinality() && CodomainIndex>=0 && CodomainIndex<D.Cardinality())
                                       {
                                          domain_index=DomainIndex;
                                          codomain_index=CodomainIndex;
                                          
                                          domain=D;
                                          codomain=C;
                                          
                                          return(true);
                                       }
                                       
                                       return(false);
                                    }
      
      void                          Let()
                                    {
                                       this.codomain.Cardinality(0);
                                       this.domain.Cardinality(0);
                                       this.Codomain(-1);
                                       this.Domain(-1);
                                    };
      
                                    CMorphism(void){ domain_index=-1; codomain_index=-1; };
                                    ~CMorphism(void){};
   };
//+------------------------------------------------------------------+
//| HOMO-MORPHISM CLASS                                              |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
class CHomomorphism                 : public CObject
   {
      protected:
      
      int                           morphisms;
      
      public:
      
      CDomain<TD>                   domain;
      CDomain<TC>                   codomain;
      
      CMorphism<TD,TC>              morphism[];
      
      int                           Morphisms() { return(morphisms); }
      bool                          Morphisms(int Value) { if(Value>=0 && Value<INT_MAX) { morphisms=Value; ArrayResize(morphism,morphisms); return(true); } return(false); }
      
      bool                          Get(int MorphismIndex,CMorphism<TD,TC> &Morphism) { if(MorphismIndex>=0 && MorphismIndex<Morphisms()) { Morphism=morphism[MorphismIndex]; Morphism.domain=domain; Morphism.codomain=codomain; Morphism.Domain(morphism[MorphismIndex].Domain()); Morphism.Codomain(morphism[MorphismIndex].Codomain()); return(true); } return(false); }
      
                                    template <typename TDD,typename TDC>
      bool                          Set(int ValueIndex,CMorphism<TDD,TDC> &Value)
                                    {
                                       if
                                       (
                                       (string(typename(TD))!=string(typename(TDD)))
                                       ||
                                       (string(typename(TC))!=string(typename(TDC)))
                                       )
                                       {
                                          return(false);
                                       }
                                       //
                                       /*if(!DomainMatch(Value.domain,domain)||!DomainMatch(Value.codomain,codomain))
                                       {
                                          printf(__FUNCSIG__+" mismatched domain and/or codomain... ");
                                          return(false);
                                       }*/
                                       // 
                                       int _index=Index(Value);//printf(__FUNCSIG__+" Index: "+IntegerToString(_index));
                                       //
                                       if(_index==-1)
                                       {
                                          if(ValueIndex>=0 && ValueIndex<Morphisms())
                                          {
                                             morphism[ValueIndex]=Value;//printf(__FUNCSIG__+" re-assigned... ");
                                             
                                             return(true);
                                          }
                                          else if(ValueIndex>=0 && ValueIndex<INT_MAX)
                                          {
                                             if(Morphisms(ValueIndex+1))
                                             {
                                                morphism[ValueIndex]=Value;//printf(__FUNCSIG__+" incremented... ");
                                                
                                                return(true);
                                             }
                                          }
                                       }
                                       
                                       return(false); 
                                    };
      
      void                          Let()
                                    {
                                       this.Morphisms(0);
                                       this.domain.Cardinality(0);
                                       this.codomain.Cardinality(0);
                                    };
      
      int                           Index(CMorphism<TD,TC> &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int m=0; m<Morphisms(); m++)
                                       {
                                          if(MorphismMatch(Value,morphism[m]))
                                          {
                                             _index=m; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
                                    CHomomorphism(void){  Morphisms(0); };
                                    ~CHomomorphism(void){};
   };
//+------------------------------------------------------------------+
//| Square Commute Class to illustrate Universal Property            |
//+------------------------------------------------------------------+
template <typename TA,typename TB,typename TC,typename TD>
class CCommuteSquare
   {
      public:
      
      CHomomorphism<TA,TB>          ab;
      CHomomorphism<TA,TC>          ac;
      CHomomorphism<TD,TB>          db;
      CHomomorphism<TD,TC>          dc;
      
      CHomomorphism<TD,TA>          da;   //universal property
      
      virtual void                  SquareAssert()
                                    {
                                       ab.domain=ac.domain;
                                       ab.codomain=db.codomain;
                                       dc.domain=db.domain;
                                       dc.codomain=ac.codomain;
                                       
                                       da.domain=db.domain;
                                       da.codomain=ac.domain;
                                    }
      
                                    CCommuteSquare(){};
                                    ~CCommuteSquare(){};
   };
//+------------------------------------------------------------------+
//| Fill Domain with handle data.                                    |
//+------------------------------------------------------------------+
template <typename T>
bool FillDomain(CDomain<T> &D,int Index,int Size,int &Handle,int Buffer=0)
   {
      double _buffer[];ArrayResize(_buffer,Size);ArrayInitialize(_buffer,0.0);
      
      if(CopyBuffer(Handle,Buffer,0,Size,_buffer)>=Size)
      {
         for(int p=0;p<Size;p++)
         {
            CElement<double> _e;
            if(_e.Cardinality(1))
            {
               if(_e.Set(0,_buffer[p]))
               { 
                  D.Set(p,_e); 
               }
            }
         }
      }
      
      return(true);
   }
//+------------------------------------------------------------------+
//| Element Match function                                           |
//+------------------------------------------------------------------+
template <typename TA,typename TB>
bool ElementMatch(CElement<TA> &A,CElement<TB> &B)
   {
      if(string(typename(TA))!=string(typename(TB)))
      {
         return(false);
      }
      
      if(A.Cardinality()!=B.Cardinality())
      {
         return(false);
      }
      
      if(A.Cardinality()==0||B.Cardinality()==0)
      {
         return(false);
      }
      
      bool _matched=true;
      
      for(int r=0; r<A.Cardinality(); r++)
      {
         TA _a;TB _b;
         if(A.Get(r,_a) && B.Get(r,_b) && _a!=_b)
         {
            _matched=false;
            break;
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Domain Match function                                            |
//+------------------------------------------------------------------+
template <typename TA,typename TB>
bool DomainMatch(CDomain<TA> &A,CDomain<TB> &B)
   {
      if(string(typename(TA))!=string(typename(TB)))
      {
         //printf(__FUNCSIG__+" type mismatch. ");
         return(false);
      }
      
      if(A.Cardinality()!=B.Cardinality())
      {
         //printf(__FUNCSIG__+" cardinality mismatch. ");
         return(false);
      }
      
      /*if(A.Cardinality()==0||B.Cardinality()==0)
      {
         return(false);
      }*/
      
      bool _matched=true;
      
      for(int o=0; o<A.Cardinality(); o++)
      {
         CElement<TA> _a;
         CElement<TB> _b;
         
         if(A.Get(o,_a) && B.Get(o,_b) && !ElementMatch(_a,_b))
         {
            //printf(__FUNCSIG__+" element mismatch at: "+IntegerToString(o));
            _matched=false; break;
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Morphism Match function                                          |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
bool MorphismMatch(CMorphism<TD,TC> &A,CMorphism<TD,TC> &B)
   {
      bool _matched=true;
      
      if(A.Domain()!=B.Domain()||A.Codomain()!=B.Codomain())
      {
         _matched=false;return(_matched);
      }
      
      if(!DomainMatch(A.domain,B.domain)||!DomainMatch(A.codomain,B.codomain))
      {
         _matched=false;return(_matched);
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Print Element function                                           |
//+------------------------------------------------------------------+
template <typename T>
string PrintElement(CElement<T> &E,int FloatPrecision=1)
   {
      string _element="(";
      //
      for(int r=0; r<E.Cardinality(); r++)
      {
         if(string(typename(T))=="datetime")
         {
            T _date;
            if(E.Get(r,_date)){ _element+=TimeToString(datetime(_date)); }
         }
         else if(string(typename(T))=="string")
         {
            T _string;
            if(E.Get(r,_string)){ _element+=string(_string); }
         }
         else if(string(typename(T))=="double"||string(typename(T))=="float")
         {
            T _double;
            if(E.Get(r,_double)){ _element+=DoubleToString(double(_double)); }
         }
         else //if(string(typename(T))=="int")
         {
            T _int;
            if(E.Get(r,_int)){ _element+=IntegerToString(int(_int)); }
         }
         
         if(r<E.Cardinality()-1){ _element+=","; }
      }
      //
      return(_element+")");
   }
//+------------------------------------------------------------------+
//| Print Domain function                                            |
//+------------------------------------------------------------------+
template <typename T>
string PrintDomain(CDomain<T> &D,int FloatPrecision=1)
   {
      string _domain="{";
      //
      CElement<T> _e;
      for(int o=0; o<D.Cardinality(); o++)
      {
         D.Get(o,_e);
         _domain+=PrintElement(_e,FloatPrecision);if(o<D.Cardinality()-1){ _domain+=","; }
      }
      //
      return(_domain+"}\n");
   }
//+------------------------------------------------------------------+
//| Print Morphism function                                          |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
string PrintMorphism(CMorphism<TD,TC> &M,int FloatPrecision=1)
   {
      string _morphism="";
      //
      CElement<TD> _d;
      CElement<TC> _c;
      ResetLastError();
      if(M.domain.Get(M.Domain(),_d) && M.codomain.Get(M.Codomain(),_c))
      {
         _morphism=PrintElement(_d,FloatPrecision);
         _morphism+="|----->";
         _morphism+=PrintElement(_c,FloatPrecision);
         _morphism+="\n";
      }
      else
      {
         //printf(__FUNCSIG__+" could not get element from: "+OBJECT_NAME(M.Domain)+", at domain index: "+IntegerToString(M.Domain())+" and/or "+OBJECT_NAME(M.Codomain)+", at codomain index: "+IntegerToString(M.Codomain())+", err: "+IntegerToString(GetLastError()));
      }
      //
      return(_morphism);
   }
//+------------------------------------------------------------------+
//| Print Homomorphism function                                      |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
string PrintHomomorphism(CHomomorphism<TD,TC> &H,int FloatPrecision=1)
   {
      string _homomorphism="\n\n"+PrintDomain(H.domain,FloatPrecision);
      //
      _homomorphism+="|\n";
      
      CMorphism<TD,TC> _m;
      for(int m=0;m<H.Morphisms();m++)
      {
         if(H.Get(m,_m))
         {
            _homomorphism+=(PrintMorphism(_m,FloatPrecision));
         }
      }
      //
      _homomorphism+="|\n";
      
      _homomorphism+=PrintDomain(H.codomain,FloatPrecision);
      //
      return(_homomorphism);
   }
//+------------------------------------------------------------------+
