//+------------------------------------------------------------------+
//|                                                     template.mq5 |
//|                                  Copyright 2022, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2022, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"

#property            script_show_inputs

#include             <ct_13.mqh>

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
struct STableEvents
  {
      datetime                   date;
      string                     code;
      double                     actual;
      double                     forecast;
      double                     previous;
      int                        country_id;
      int                        currency_id;
      int                        event_id;
      
                                 STableEvents(){};
                                 ~STableEvents(){};
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
struct STableEventTypes
  {
      int                        id;
      string                     type;
      
                                 STableEventTypes(){};
                                 ~STableEventTypes(){};
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
struct STableCurrencies
  {
      int                        id;
      string                     currency;
      
                                 STableCurrencies(){};
                                 ~STableCurrencies(){};
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
struct STableCountries
  {
      int                        id;
      string                     country;
      
                                 STableCountries(){};
                                 ~STableCountries(){};
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CDatabase
  {
      public:
      
      STableEvents               events;
      STableEventTypes           event_types;
      STableCountries            countries;
      STableCurrencies           currncies;
      
      
                                 CDatabase(void);
                                 ~CDatabase(void);
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//sample enumeration. should ideally be based off one's training model using reasonable datasize
enum EType
  {
      TYPE_CPI=1,
      TYPE_PMI=2,
      TYPE_AUCTION_2YR=3,
      TYPE_AUCTION_10YR=4,
      TYPE_BENCHMARK_RATE=5,
      TYPE_UNDEFINED=6,
  };
//+------------------------------------------------------------------+
//| INPUTS                                                           |
//+------------------------------------------------------------------+
input EType __type=TYPE_PMI;
input uint __bid_weight=1;
input uint __ask_weight=1;
input datetime __start_date=D'2023.06.01';
input ENUM_TIMEFRAMES __stop_date_increment=PERIOD_MN1;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
   {
      CCommuteSquare<string,string,string,string> _sc;
      
      int _types=6;
      //actual types no. will be got from enumeration size, 
      //which one gets from training classification model
      
      //sample constructor for type set
      CDomain<string> _d_type;_d_type.Cardinality(_types);
      //data population
      CElement<string> _e_type;_e_type.Cardinality(1);
      _e_type.Set(0,EnumToString(TYPE_CPI));_d_type.Set(0,_e_type);
      _e_type.Set(0,EnumToString(TYPE_PMI));_d_type.Set(1,_e_type);
      _e_type.Set(0,EnumToString(TYPE_AUCTION_2YR));_d_type.Set(2,_e_type);
      _e_type.Set(0,EnumToString(TYPE_AUCTION_10YR));_d_type.Set(3,_e_type);
      _e_type.Set(0,EnumToString(TYPE_BENCHMARK_RATE));_d_type.Set(4,_e_type);
      _e_type.Set(0,EnumToString(TYPE_UNDEFINED));_d_type.Set(5,_e_type);
      
      for(int s=0;s<_types;s++)
      {
         //retrieve types into _e_type element then fill set
         CElement<string> _e;
         if(_d_type.Get(s,_e))
         {
            _sc.db.codomain.Set(s,_e);
         }
      }
      
      //printf(__FUNCSIG__+" raw db codomain or type set is:... "+PrintDomain(_d_type));
      //printf(__FUNCSIG__+" commute db codomain or type set is:... "+PrintDomain(_sc.db.codomain));return;
      //
      
      int _currencies=5;
      //actual number would be based on one's portfolio 
      //based on currencies selected from those reported on in calendar'
      
      //sample constructor for currency set
      CDomain<string> _d_currency;_d_currency.Cardinality(_currencies);
      //data population
      CElement<string> _e_currency;_e_currency.Cardinality(1);
      _e_currency.Set(0,"EUR");_d_currency.Set(0,_e_currency);
      _e_currency.Set(0,"GBP");_d_currency.Set(1,_e_currency);
      _e_currency.Set(0,"USD");_d_currency.Set(2,_e_currency);
      _e_currency.Set(0,"CHF");_d_currency.Set(3,_e_currency);
      _e_currency.Set(0,"JPY");_d_currency.Set(4,_e_currency);
      
      for(int s=0;s<_currencies;s++)
      {
         //retrieve currencies into _e_currency element then fill set
         CElement<string> _e;
         if(_d_currency.Get(s,_e))
         {
            _sc.ac.codomain.Set(s,_e);
         }
      }
      
      //printf(__FUNCSIG__+" raw ac codomain or currency set is:... "+PrintDomain(_d_currency));
      //printf(__FUNCSIG__+" commute ac codomain or currency set is:... "+PrintDomain(_sc.ac.codomain));return;
      //
      
      int _events=0;
      
      for(int i=0;i<_currencies;i++)//_currencies
      {
         string _c="";
         if(_d_currency.Get(i,_e_currency) && _e_currency.Get(0,_c))
         {
            SampleEvents(_sc.ac.domain,_sc.db.codomain,_c,_events);
         }
      }
      
      //printf(__FUNCSIG__+" with: "+IntegerToString(_events)+" events, ");
      //printf(__FUNCSIG__+" commute ac domain or ab domain or events set is:... "+PrintDomain(_sc.ac.domain));return;
      //
      
      int _values=4;
      //actual no. will depend on one's portfolio
      
      //sample constructor for values set
      CDomain<string> _d_values;_d_values.Cardinality(_values);
      //data population
      CElement<string> _e_values;_e_values.Cardinality(4);
      
      double _value=0.0;
      
      _value=0.0; WeightedValue(_sc.ac.domain,"EUR","USD",EnumToString(__type),_value);_e_values.Set(0,"EUR");_e_values.Set(1,"USD");_e_values.Set(2,DoubleToString(_value));_e_values.Set(3,EnumToString(__type));_d_values.Set(0,_e_values);
      _value=0.0; WeightedValue(_sc.ac.domain,"GBP","USD",EnumToString(__type),_value);_e_values.Set(0,"GBP");_e_values.Set(1,"USD");_e_values.Set(2,DoubleToString(_value));_e_values.Set(3,EnumToString(__type));_d_values.Set(1,_e_values);
      _value=0.0; WeightedValue(_sc.ac.domain,"USD","CHF",EnumToString(__type),_value);_e_values.Set(0,"USD");_e_values.Set(1,"CHF");_e_values.Set(2,DoubleToString(_value));_e_values.Set(3,EnumToString(__type));_d_values.Set(2,_e_values);
      _value=0.0; WeightedValue(_sc.ac.domain,"USD","JPY",EnumToString(__type),_value);_e_values.Set(0,"USD");_e_values.Set(1,"JPY");_e_values.Set(2,DoubleToString(_value));_e_values.Set(3,EnumToString(__type));_d_values.Set(3,_e_values);
      
      for(int s=0;s<_values;s++)
      {
         //retrieve types into _e_type element then fill set
         CElement<string> _e;
         if(_d_values.Get(s,_e))
         {
            _sc.db.domain.Set(s,_e);
         }
      }
      
      //printf(__FUNCSIG__+" raw db domain or dc domain or values set is:... "+PrintDomain(_d_values));
      //printf(__FUNCSIG__+" commute db domain or dc domain or values set is:... "+PrintDomain(_sc.db.domain));//return;
      //
      
      //synchronize domains and codomains
      _sc.SquareAssert();
         
      //ab homomorphisms
      CHomomorphism<string,string> _ab;
      
      CElement<string> _e;
      for(int s=0;s<_sc.ab.domain.Cardinality();s++)
      {
         _e.Let();
         if(_sc.ab.domain.Get(s,_e))
         {
            string _s="";
            if(_e.Get(0,_s))
            {
               CMorphism<string,string> _m;
               _m.Morph(_sc.ab.domain,_sc.ab.codomain,s,EventType(_s));
               
               _ab.Morphisms(_ab.Morphisms()+1);
               _ab.Set(_ab.Morphisms()-1,_m);
            }
         }
      }
      
      _ab.domain=_sc.ab.domain;
      _ab.codomain=_sc.ab.codomain;
      _sc.ab=_ab; _sc.SquareAssert();
      //printf(__FUNCSIG__+" a to b homomorphisms are... "+PrintHomomorphism(_sc.ab));//return;
      
      //ac homomorphisms
      CHomomorphism<string,string> _ac;
      
      for(int s=0;s<_sc.ac.domain.Cardinality();s++)
      {
         _e.Let();
         if(_sc.ac.domain.Get(s,_e))
         {
            string _s="";
            if(_e.Get(1,_s))
            {
               CMorphism<string,string> _m;
               int _c=EventCurrency(_s);
               if(_c!=-1)
               {
                  _m.Morph(_sc.ac.domain,_sc.ac.codomain,s,_c);
                  
                  _ac.Morphisms(_ac.Morphisms()+1);
                  _ac.Set(_ac.Morphisms()-1,_m);
               }
            }
         }
      }
      
      _ac.domain=_sc.ac.domain;
      _ac.codomain=_sc.ac.codomain;
      _sc.ac=_ac; _sc.SquareAssert();
      /*printf(__FUNCSIG__+" a to c homomorphisms are... "+PrintHomomorphism(_sc.ac));
      printf(__FUNCSIG__+" doamin a: "+PrintDomain(_sc.ab.domain));*/
      
      //db homomorphisms
      CHomomorphism<string,string> _db;
      
      for(int s=0;s<_values;s++)
      {
         _e.Let();
         if(_sc.db.domain.Get(s,_e))
         {
            string _s="";
            if(_e.Get(3,_s))
            {
               int _t=TypeToInt(_s);
               CMorphism<string,string> _m;
               //
               _m.Morph(_sc.db.domain,_sc.db.codomain,s,_t);
               
               _db.Morphisms(_db.Morphisms()+1);
               _db.Set(_db.Morphisms()-1,_m);
            }
         }
      }
      
      _db.domain=_sc.db.domain;
      _db.codomain=_sc.db.codomain;
      _sc.db=_db; _sc.SquareAssert();
      /*printf(__FUNCSIG__+" d to b homomorphisms are... "+PrintHomomorphism(_sc.db));*/
      
      //dc homomorphisms
      CHomomorphism<string,string> _dc;
      
      for(int s=0;s<_values;s++)
      {
         _e.Let();
         if(_sc.dc.domain.Get(s,_e))
         {
            string _s="";
            if(_e.Get(0,_s))//morphisms for margin currency only
            {
               int _c=EventCurrency(_s);
               
               CMorphism<string,string> _m;
               //
               _m.Morph(_sc.dc.domain,_sc.dc.codomain,s,_c);
               
               _dc.Morphisms(_dc.Morphisms()+1);
               _dc.Set(_dc.Morphisms()-1,_m);
            }
         }
      }
      
      _dc.domain=_sc.dc.domain;
      _dc.codomain=_sc.dc.codomain;
      _sc.dc=_dc; _sc.SquareAssert();
      //printf(__FUNCSIG__+" d to c homomorphisms are... "+PrintHomomorphism(_sc.dc));
      
      //da homomorphisms
      CHomomorphism<string,string> _da;
      
      for(int s=0;s<_values;s++)
      {
         _e.Let();
         if(_sc.da.domain.Get(s,_e))
         {
            string _s_c="",_s_t="";
            if(_e.Get(0,_s_c) && _e.Get(3,_s_t))// for margin currency
            {
               for(int ss=0;ss<_sc.ac.domain.Cardinality();ss++)
               {
                  CElement<string> _ee;
                  if(_sc.da.codomain.Get(ss,_ee))
                  {
                     string _ss_c="",_ss_t="";
                     if(_ee.Get(1,_ss_c) && _ee.Get(6,_ss_t))// for margin currency
                     {
                        if(_ss_c==_s_c && _ss_t==_s_t)
                        {
                           CMorphism<string,string> _m;
                           //
                           _m.Morph(_sc.da.domain,_sc.da.codomain,s,ss);
                           
                           _da.Morphisms(_da.Morphisms()+1);
                           _da.Set(_da.Morphisms()-1,_m);
                           
                           _sc.da=_da; _sc.SquareAssert();
                           
                           break;
                        }
                     }
                  }
               }
            }
         }
      }
      
      _da.domain=_sc.da.domain;
      _da.codomain=_sc.da.codomain;
      _sc.da=_da; _sc.SquareAssert();
      //printf(__FUNCSIG__+" d to a homomorphisms are... "+PrintHomomorphism(_sc.da));
      
      //
      
      printf(__FUNCSIG__+" a to b homomorphisms are... "+PrintHomomorphism(_sc.ab));
      //
      printf(__FUNCSIG__+" a to c homomorphisms are... "+PrintHomomorphism(_sc.ac));
      //
      printf(__FUNCSIG__+" d to b homomorphisms are... "+PrintHomomorphism(_sc.db));
      //
      printf(__FUNCSIG__+" d to c homomorphisms are... "+PrintHomomorphism(_sc.dc));
      //
      printf(__FUNCSIG__+" d to a homomorphisms are... "+PrintHomomorphism(_sc.da));
   } 
//+------------------------------------------------------------------+
//| Method to retieve Calendar Events and Values by Currency         |
//+------------------------------------------------------------------+
void SampleRetrieval(string Currency)
   {
      MqlCalendarValue _value[];
      datetime _stop_date=datetime(__start_date+int(PeriodSeconds(__stop_date_increment)));
//--- get events
      MqlCalendarEvent _event[];
      int _events=CalendarEventByCurrency(Currency,_event);
      printf(__FUNCSIG__+" for Currency: "+Currency+" events are: "+IntegerToString(_events));
      //
      for(int e=0;e<_events;e++)
      {
         int _values=CalendarValueHistoryByEvent(_event[e].id, _value, __start_date, _stop_date);
         //
         for(int v=0;v<_values;v++)
         {
            //
            printf(__FUNCSIG__+" Calendar Event code: "+_event[e].event_code+", for value: "+TimeToString(_value[v].period)+" on: "+TimeToString(_value[v].time)+", has... ");
            //
            if(_value[v].HasPreviousValue())
            {
               printf(__FUNCSIG__+" Previous value: "+DoubleToString(_value[v].GetPreviousValue()));
            }
            
            if(_value[v].HasForecastValue())
            {
               printf(__FUNCSIG__+" Forecast value: "+DoubleToString(_value[v].GetForecastValue()));
            }
            
            if(_value[v].HasActualValue())
            {
               printf(__FUNCSIG__+" Actual value: "+DoubleToString(_value[v].GetActualValue()));
            }
         }
      }
   }
//+------------------------------------------------------------------+
//| Method to retieve Calendar Events by Type and by Currency.       |
//| Events parameter is an output counter to no. of added events to  |
//| domain.                                                          |
//+------------------------------------------------------------------+
void SampleEvents(CDomain<string> &E,CDomain<string> &T,string Currency, int &Events)
   {
      //sample constructor for event set
      CElement<string> _e_event;_e_event.Cardinality(7);
      //
      
      MqlCalendarValue _value[];
      datetime _stop_date=datetime(__start_date+int(PeriodSeconds(__stop_date_increment)));
//--- get events
      MqlCalendarEvent _event[];
      int _new_events=CalendarEventByCurrency(Currency,_event);//Events+=_new_events;
      printf(__FUNCSIG__+" at Currency: "+Currency+
         " events are: "+IntegerToString(_new_events)+
         " accumulating to: "+IntegerToString(Events)+
         " with cardinality: "+IntegerToString(E.Cardinality())
         );
      //
      for(int e=0;e<_new_events;e++)
      {
         int _values=CalendarValueHistoryByEvent(_event[e].id, _value, __start_date, _stop_date);
         //
         for(int v=0;v<_values;v++)
         {
            //data population at each index
            
            if(_value[v].HasActualValue())
            {
               CElement<string> _e_t;
               int _t=EventType(_event[e].event_code);
               if(T.Get(_t,_e_t))
               {
                  string _s="";
                  if(_e_t.Get(0,_s) && _s==EnumToString(__type))
                  {
                     _e_event.Set(6,_s);
                     
                     _e_event.Set(4,DoubleToString(_value[v].GetActualValue()));
                     //printf(__FUNCSIG__+" assigning value: "+DoubleToString(_value[v].GetActualValue())+", for: "+_event[e].event_code+", of type: "+IntegerToString(EventType(_event[e].event_code)));     
                     
                     _e_event.Set(0,_event[e].event_code);
                     _e_event.Set(1,Currency);
                     //
                     if(_value[v].HasPreviousValue())
                     {
                        _e_event.Set(2,DoubleToString(_value[v].GetPreviousValue()));
                     }
                     
                     if(_value[v].HasForecastValue())
                     {
                        _e_event.Set(3,DoubleToString(_value[v].GetForecastValue()));
                     }
                  
                     _e_event.Set(5,TimeToString(_value[v].time));
                     
                     //
                     
                     if(E.Cardinality(E.Cardinality()+1))
                     {
                        E.Set(E.Cardinality()-1,_e_event);Events++;
                     }
                  }
               }
               
            }
         }
      }
   }
//+------------------------------------------------------------------+
//|   UN-TRAINED Model on Event Type Classification                  |
//+------------------------------------------------------------------+
int EventType(string EventCode)
   {
      if(StringFind(EventCode,"cpi")>=0){ return(0); }
      else if(StringFind(EventCode,"pmi")>=0){ return(1); }
      else if((StringFind(EventCode,"2-yr")>=0||StringFind(EventCode,"2-year")>=0)&&StringFind(EventCode,"auction")>=0){ return(2); }
      else if((StringFind(EventCode,"10-yr")>=0||StringFind(EventCode,"10-year")>=0)&&StringFind(EventCode,"auction")>=0){ return(3); }
      else if(StringFind(EventCode,"interest")>=0){ return(4); }
      //... other options can be added here, based on training.
      
      return(5);
   }
//+------------------------------------------------------------------+
//| Method that converts a currency to its index in the Currency set |
//+------------------------------------------------------------------+
int EventCurrency(string Currency)
   {
      if(Currency=="EUR"){ return(0); }
      else if(Currency=="GBP"){ return(1); }
      else if(Currency=="USD"){ return(2); }
      else if(Currency=="CHF"){ return(3); }
      else if(Currency=="JPY"){ return(4); }
      
      return(-1);
   }
//+------------------------------------------------------------------+
//| Method that converts a string to its index in the Type set       |
//+------------------------------------------------------------------+
int TypeToInt(string &T)
   {
      if(T==EnumToString(TYPE_CPI)){ return(0); }
      else if(T==EnumToString(TYPE_PMI)){ return(1); }
      else if(T==EnumToString(TYPE_AUCTION_2YR)){ return(2); }
      else if(T==EnumToString(TYPE_AUCTION_10YR)){ return(3); }
      else if(T==EnumToString(TYPE_BENCHMARK_RATE)){ return(4); }
      
      return(5);
   }
//+------------------------------------------------------------------+
//| Method that calculates weighted average of two event values      |
//+------------------------------------------------------------------+
void WeightedValue(CDomain<string> &E, string Bid, string Ask, string Type, double &Value)
   {
      bool _valued=false;
      
      for(int i=0;i<E.Cardinality();i++)// loop through all events to get a matching currency and event type for input Bid
      {
         CElement<string> _e_bid;
         string _bid_currency="",_bid_type="";
         if(E.Get(i,_e_bid) && _e_bid.Get(1,_bid_currency) && _bid_currency==Bid && _e_bid.Get(6,_bid_type) && _bid_type==Type)
         {
            for(int ii=0;ii<E.Cardinality();ii++)// loop through all events to get a matching currency and event type for input Ask
            {
               CElement<string> _e_ask;
               string _ask_currency="",_ask_type="";
               if(E.Get(ii,_e_ask) && _e_ask.Get(1,_ask_currency) && _ask_currency==Ask && _e_ask.Get(6,_ask_type) && _ask_type==Type)
               {
                  string _bid_value="",_ask_value="";
                  if(_e_bid.Get(4,_bid_value) && _e_ask.Get(4,_ask_value))// once matching bid and ask events are got select their actual values
                  {
                     Value=((__ask_weight*StringToDouble(_ask_value))+(__bid_weight*StringToDouble(_bid_value)))/fmax(1.0,__ask_weight+__bid_weight);
                     //combine actual values as weighted average...
                     _valued=true;
                     break;
                  }
               } 
            }
         }
         
         if(_valued){ break; }
      }
   }
//+------------------------------------------------------------------+
