//+------------------------------------------------------------------+
//|                                             Money Management.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property script_show_inputs
#include <Graphics\Graphic.mqh>
input uchar ProbabilityWin=70;
input ushort Trades=100,
             StartDeposit=1000,
             SL=500,
             TP=350,
             Risk=3;
input bool Lin1=false,
           Lin2=false,
           Exp=false,
           Hyp=true;
input uchar Width=3;
input bool ScreenShot=true;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   MathSrand(GetTickCount());
   int size=MathMax(10,Trades),prob=MathMin(99,MathMax(1,ProbabilityWin)),trades[];
   ArrayResize(trades,size);
   for(int i=0; i<size; i++)
      trades[i]= 100*MathRand()<=32767*prob? 1:0;

   int risk=MathMax(1,Risk);
   double PV=SymbolInfoDouble(_Symbol,SYMBOL_TRADE_TICK_VALUE)*SymbolInfoDouble(_Symbol,SYMBOL_POINT)/SymbolInfoDouble(_Symbol,SYMBOL_TRADE_TICK_SIZE),
          sl=SL*PV,tp=TP*PV,min=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN),step=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_STEP),
          d1[],l1[],d2[],l2[],d3[],l3[],d4[],l4[];

   if(Lin1==true)
     {
      int cnt=0;
      double L=0,sum=0,h=(SL+risk*TP)/(2*PV*SL*TP);
      ArrayResize(d1,size+1);
      ArrayInitialize(d1,0);
      d1[0]=StartDeposit;
      ArrayResize(l1,size+1);
      ArrayInitialize(l1,0);
      l1[0]=0;

      for(int i=1; i<=size; i++)
        {
         if(cnt>0)
            L=MathSqrt(sum/cnt);
         double lot=NormalizeLot(L*h),
                res=trades[i-1]==1? lot*tp:-lot*sl;
         d1[i]=d1[i-1]+res;
         if(d1[i]<=0)
            break;
         l1[i]=(lot-min)/step;
         sum=sum+res*res;
         cnt++;
        }
     }

   if(Lin2==true)
     {
      int cnt=0;
      double L=0,sum=0;
      ArrayResize(d2,size+1);
      ArrayInitialize(d2,0);
      d2[0]=StartDeposit;
      ArrayResize(l2,size+1);
      ArrayInitialize(l2,0);
      l2[0]=0;

      for(int i=1; i<=size; i++)
        {
         if(cnt>0)
            L=MathSqrt(sum/cnt);
         double lot=NormalizeLot(min+L/(risk*tp)),
                res=trades[i-1]==1? lot*tp:-lot*sl;
         d2[i]=d2[i-1]+res;
         if(d2[i]<=0)
            break;
         l2[i]=(lot-min)/step;
         sum=sum+res*res;
         cnt++;
        }
     }

   if(Exp==true)
     {
      ArrayResize(d3,size+1);
      ArrayInitialize(d3,0);
      d3[0]=StartDeposit;
      ArrayResize(l3,size+1);
      ArrayInitialize(l3,0);
      l3[0]=0;
      for(int i=1; i<=size; i++)
        {
         double lot=tp/(risk*tp+d3[i-1])-sl/(d3[i-1]-risk*sl);
         if(i>1)
            for(int j=i-1; j>0; j--)
              {
               double res=(d3[j]-d3[j-1])/(l3[j]*step+min);
               lot=lot+2*res/(risk*res+d3[j-1]);
              }
         lot=NormalizeLot(lot);
         double res=trades[i-1]==1? lot*tp:-lot*sl;
         d3[i]=d3[i-1]+res;
         if(d3[i]<=0)
            break;
         l3[i]=(lot-min)/step;
        }
     }

   if(Hyp==true)
     {
      ArrayResize(d4,size+1);
      ArrayInitialize(d4,0);
      d4[0]=StartDeposit;
      ArrayResize(l4,size+1);
      ArrayInitialize(l4,0);
      l4[0]=0;
      for(int i=1; i<=size; i++)
        {
         double lot=0,clot=min,diff=DBL_MAX;

         while(clot<=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MAX))
           {
            double cd=tp/(risk*clot*tp+d4[i-1])-sl/(d4[i-1]-risk*clot*sl);
            for(int j=i-1; j>0; j--)
              {
               double res=(d4[j]-d4[j-1])/(l4[j]*step+min);
               cd=cd-2*res/(risk*clot*res+d4[j-1]);
              }
            cd=MathAbs(cd);
            if(cd<diff)
              {
               lot=clot;
               diff=cd;
              }
            else
               break;
            clot=clot+step;
           }

         lot=NormalizeLot(lot);
         double res=trades[i-1]==1? lot*tp:-lot*sl;
         d4[i]=d4[i-1]+res;
         if(d4[i]<=0)
            break;
         l4[i]=(lot-min)/step;
        }
     }
//---
   ChartSetInteger(0,CHART_SHOW,false);
   int w=(int)ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,0),
       h=(int)ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,0);

   CGraphic GD;
   GD.Create(0,"MM",0,0,0,w,h);
   if(Lin1==true)
     {
      CCurve *depo1=GD.CurveAdd(d1,CURVE_LINES);
      depo1.LinesWidth(Width);
      depo1.Name("Lin1");
     }
   if(Lin2==true)
     {
      CCurve *depo2=GD.CurveAdd(d2,CURVE_LINES);
      depo2.LinesWidth(Width);
      depo2.Name("Lin2");
     }
   if(Exp==true)
     {
      CCurve *depo3=GD.CurveAdd(d3,CURVE_LINES);
      depo3.LinesWidth(Width);
      depo3.Name("Exp");
     }
   if(Hyp==true)
     {
      CCurve *depo4=GD.CurveAdd(d4,CURVE_LINES);
      depo4.LinesWidth(Width);
      depo4.Name("Hyp");
     }

   GD.CurvePlotAll();
   GD.Update();
   if(ScreenShot==true)
      ChartScreenShot(0,"MM.png",w,h);
   Sleep(5000);
   GD.Destroy();
//---
   CGraphic GL;
   GL.Create(0,"Lot",0,0,0,w,h);
   if(Lin1==true)
     {
      CCurve *lot1=GL.CurveAdd(l1,CURVE_LINES);
      lot1.LinesWidth(Width);
      lot1.Name("Lin1");
     }
   if(Lin2==true)
     {
      CCurve *lot2=GL.CurveAdd(l2,CURVE_LINES);
      lot2.LinesWidth(Width);
      lot2.Name("Lin2");
     }
   if(Exp==true)
     {
      CCurve *lot3=GL.CurveAdd(l3,CURVE_LINES);
      lot3.LinesWidth(Width);
      lot3.Name("Exp");
     }
   if(Hyp==true)
     {
      CCurve *lot4=GL.CurveAdd(l4,CURVE_LINES);
      lot4.LinesWidth(Width);
      lot4.Name("Hyp");
     }

   GL.CurvePlotAll();
   GL.Update();
   if(ScreenShot==true)
      ChartScreenShot(0,"Lot.png",w,h);
   Sleep(5000);
   GL.Destroy();

   ChartSetInteger(0,CHART_SHOW,true);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double NormalizeLot(double lot)
  {
//---
   double min=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN),
          step=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_STEP),
          max=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MAX);

   int v=MathMax(0,(int)MathRound((lot-min)/step));

   return(MathMin(min+v*step,max));
//---
  }
//+------------------------------------------------------------------+
