//+------------------------------------------------------------------+
//|                                                         Rost.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property script_show_inputs
#include <Graphics\Graphic.mqh>
input ushort Trades=20;
input double Lin=0.5,
             Exp=1.2,
             Hyp=1.00001;
input uchar Width=3;
input bool ScreenShot=true;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   int size=MathMax(10,Trades);
   double array1[],array2[],array3[];
   ArrayResize(array1,size);
   ArrayInitialize(array1,1);
   ArrayResize(array2,size);
   ArrayInitialize(array2,1);
   ArrayResize(array3,size);
   ArrayInitialize(array3,1);
   
   for(int i=1; i<size; i++)
     {
      array1[i]=array1[i-1]+Lin;
      array2[i]=array2[i-1]*Exp;
      array3[i]=array3[i-1]*array3[i-1]*Hyp;
     }

   ChartSetInteger(0,CHART_SHOW,false);
   int w=(int)ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,0),
       h=(int)ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,0);

   CGraphic GD;
   GD.Create(0,"rost",0,0,0,w,h);

   CCurve *depo1=GD.CurveAdd(array1,CURVE_LINES);
   depo1.LinesWidth(Width);
   depo1.Name("Lin");

   CCurve *depo2=GD.CurveAdd(array2,CURVE_LINES);
   depo2.LinesWidth(Width);
   depo2.Name("Exp");

   CCurve *depo3=GD.CurveAdd(array3,CURVE_LINES);
   depo3.LinesWidth(Width);
   depo3.Name("Hyp");

   GD.CurvePlotAll();
   GD.Update();
   if(ScreenShot==true)
      ChartScreenShot(0,"rost.png",w,h);
   Sleep(5000);
   GD.Destroy();
   ChartSetInteger(0,CHART_SHOW,true);
//---
  }
//+------------------------------------------------------------------+
