//+------------------------------------------------------------------+
//|                                                         tCCI.mq4 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/en/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/en/users/aleksej1966"
#property version   "1.00"
#property strict
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_plots   2

#property indicator_level1 0
#property indicator_level2 0
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DOT
#property indicator_levelwidth 1

#property indicator_type1  DRAW_HISTOGRAM
#property indicator_label1 "trend up"
#property indicator_color1 clrBlue
#property indicator_width1 5
#property indicator_style1 STYLE_SOLID

#property indicator_type2  DRAW_HISTOGRAM
#property indicator_label2 "trend dn"
#property indicator_color2 clrRed
#property indicator_width2 5
#property indicator_style2 STYLE_SOLID

input ushort iPeriod=14;

int indx10,indx11,indx20,indx21;
double buffer_up[],buffer_dn[],halfsums[],diff[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   if(iPeriod<3)
     {
      Alert("Minimum iPeriod = 3");
      return(INIT_FAILED);
     }
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer_up,INDICATOR_DATA);
   ArraySetAsSeries(buffer_up,true);
   SetIndexEmptyValue(0,0);

   SetIndexBuffer(1,buffer_dn,INDICATOR_DATA);
   ArraySetAsSeries(buffer_dn,true);
   SetIndexEmptyValue(1,EMPTY_VALUE);

   int sizeHS=iPeriod*(iPeriod-1)/2;
   ArrayResize(halfsums,sizeHS);

   indx10=sizeHS/2;
   indx11=MathMod(sizeHS,2)==0? indx10-1:indx10;

   ArrayResize(diff,iPeriod);
   indx20=iPeriod/2;
   indx21=MathMod(iPeriod,2)==0? indx20-1:indx20;
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   static int cnt_up,cnt_dn;
   static double sum_up,sum_dn;

   ArraySetAsSeries(open,true);

   int bars=rates_total-prev_calculated-1;
   if(prev_calculated==0)
     {
      bars=rates_total-iPeriod-1;
      for(int i=rates_total-1; i>bars; i--)
        {
         buffer_up[i]=0;
         buffer_dn[i]=0;
        }
     }

   for(int i=bars; i>=0; i--)
     {
      int cnt=0;
      for(int j=iPeriod-2; j>=0; j--)
        {
         double p=open[i+j];
         for(int k=iPeriod-1; k>j; k--)
           {
            halfsums[cnt]=p+open[i+k];
            cnt++;
           }
        }
      ArraySort(halfsums);
      double mean=(halfsums[indx10]+halfsums[indx11])/4;

      for(int j=0; j<iPeriod; j++)
         diff[j]=MathAbs(open[i+j]-mean);
      ArraySort(diff);

      double sd=(diff[indx20]+diff[indx21])/2;
      mean=sd>0? (open[i]-mean)/sd:0;

      if(mean>0)
        {
         buffer_up[i]=mean+buffer_up[i+1];
         buffer_dn[i]=0;

         if(buffer_up[i+1]==0)
           {
            cnt_up++;
            sum_dn=sum_dn+buffer_dn[i+1];
           }
        }
      if(mean<0)
        {
         buffer_dn[i]=mean+buffer_dn[i+1];
         buffer_up[i]=0;

         if(buffer_dn[i+1]==0)
           {
            cnt_dn++;
            sum_up=sum_up+buffer_up[i+1];
           }
        }
      if(mean==0)
        {
         buffer_up[i]=buffer_up[i+1];
         buffer_dn[i]=buffer_dn[i+1];
        }

      if(i==0)
        {
         IndicatorSetDouble(INDICATOR_LEVELVALUE,0,sum_up/cnt_up);
         IndicatorSetDouble(INDICATOR_LEVELVALUE,1,sum_dn/cnt_dn);
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
