//+------------------------------------------------------------------+
//|                                                         mCCI.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/en/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/en/users/aleksej1966"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_applied_price PRICE_TYPICAL
#property indicator_type1  DRAW_LINE
#property indicator_label1 "mCCI"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

enum type_ind {Classical,Square,Modern};
input type_ind TypeInd=Classical;
input ushort iPeriod=14;

int indx10,indx11,indx20,indx21;
double buffer[],halfsums[],diff[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   if(iPeriod<3)
     {
      Alert("Minimum iPeriod = 3");
      return(INIT_FAILED);
     }
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   if(TypeInd==Modern)
     {
      int size=iPeriod*(iPeriod-1)/2;
      ArrayResize(halfsums,size);
      indx10=size/2;
      indx11=MathMod(size,2)==0? indx10-1:indx10;

      ArrayResize(diff,iPeriod);
      indx20=iPeriod/2;
      indx21=MathMod(iPeriod,2)==0? indx20-1:indx20;
     }
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
//---
   ArraySetAsSeries(price,true);

   int bars=prev_calculated>0? rates_total-prev_calculated:rates_total-iPeriod-1;

   for(int i=bars; i>=0; i--)
     {
      double res=0;
      if(TypeInd==Classical)
        {
         double mean=0,mad=0;
         for(int j=0; j<iPeriod; j++)
            mean=mean+price[i+j];
         mean=mean/iPeriod;
         for(int j=0; j<iPeriod; j++)
            mad=mad+MathAbs(price[i+j]-mean);
         if(mad>0)
            res=(price[i]-mean)*iPeriod/mad;
        }

      if(TypeInd==Square)
        {
         double sumS=0,sumQ=0;
         for(int j=0; j<iPeriod; j++)
           {
            double p=price[i+j];
            sumS=sumS+p;
            sumQ=sumQ+p*p;
           }
         double denom=MathSqrt(iPeriod*sumQ-sumS*sumS);
         if(denom>0)
            res=(iPeriod*price[i]-sumS)/denom;
        }

      if(TypeInd==Modern)
        {
         int cnt=0;
         for(int j=iPeriod-2; j>=0; j--)
           {
            double p=price[i+j];
            for(int k=iPeriod-1; k>j; k--)
              {
               halfsums[cnt]=p+price[i+k];
               cnt++;
              }
           }
         ArraySort(halfsums);
         double mean=(halfsums[indx10]+halfsums[indx11])/4;
         for(int j=0; j<iPeriod; j++)
            diff[j]=MathAbs(price[i+j]-mean);
         ArraySort(diff);
         double sd=(diff[indx20]+diff[indx21])/2;
         if(sd>0)
            res=(price[i]-mean)/sd;
        }

      buffer[i]=res;
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
