//+------------------------------------------------------------------+
//|                                                       EA CCI.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/en/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/en/users/aleksej1966"
#property version   "1.00"
enum type_ind {Classical,Square,Modern};

input type_ind TypeInd=Classical;
input ushort iPeriod=14;
input ENUM_APPLIED_PRICE iPrice=PRICE_TYPICAL;
input ushort Level=150;

int indx10,indx11,indx20,indx21;
double lot,halfsums[],diff[],old_ind;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   lot=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN);
   if(TypeInd==Modern)
     {
      int sizeHS=iPeriod*(iPeriod-1)/2;
      ArrayResize(halfsums,sizeHS);
      indx10=sizeHS/2;
      indx11=MathMod(sizeHS,2)==0? indx10-1:indx10;
      ArrayResize(diff,iPeriod);
      indx20=iPeriod/2;
      indx21=MathMod(iPeriod,2)==0? indx20-1:indx20;
     }
   old_ind=CalculationIndicator();
   NewBar();
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
//---
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   if(NewBar()==true)
     {
      double cur_ind=CalculationIndicator();
      if(cur_ind<Level && old_ind>Level)
         PutPosition(ORDER_TYPE_SELL);
      if(-cur_ind<Level && -old_ind>Level)
         PutPosition(ORDER_TYPE_BUY);
      old_ind=cur_ind;
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void PutPosition(ENUM_ORDER_TYPE type)
  {
//---
   double price=type==ORDER_TYPE_BUY? SymbolInfoDouble(_Symbol,SYMBOL_ASK):SymbolInfoDouble(_Symbol,SYMBOL_BID),margin;
   if(OrderCalcMargin(type,_Symbol,lot,price,margin)==false)
      return;
   if(margin>AccountInfoDouble(ACCOUNT_MARGIN_FREE))
     {
      Print("Not enough money for ",EnumToString(type)," ",lot," ",_Symbol," Error code=",GetLastError());
      return;
     }
   MqlTradeRequest request= {};
   MqlTradeResult result= {};
   request.action=TRADE_ACTION_DEAL;
   request.symbol=_Symbol;
   request.volume=lot;
   request.price=price;
   request.deviation=SymbolInfoInteger(_Symbol,SYMBOL_SPREAD);
   request.type=type;
   if(OrderSend(request,result)==false)
      PrintFormat("OrderSend error %d",GetLastError());
//---
   for(int pos=PositionsTotal()-1; pos>=0; pos--)
     {
      ulong ticket=PositionGetTicket(pos);
      if(ticket>0 && PositionSelectByTicket(ticket)==true && PositionGetString(POSITION_SYMBOL)==_Symbol)
        {
         if(type==ORDER_TYPE_SELL && PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_BUY)
            ClosePosition(POSITION_TYPE_BUY,ticket);
         if(type==ORDER_TYPE_BUY && PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_SELL)
            ClosePosition(POSITION_TYPE_SELL,ticket);
        }
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void ClosePosition(ENUM_POSITION_TYPE type_pos,ulong ticket)
  {
//---
   MqlTradeRequest request= {};
   MqlTradeResult result= {};
   request.action=TRADE_ACTION_DEAL;
   request.position=ticket;
   request.symbol=_Symbol;
   request.volume=lot;
   request.deviation=SymbolInfoInteger(_Symbol,SYMBOL_SPREAD);
   if(type_pos==POSITION_TYPE_BUY)
     {
      request.price=SymbolInfoDouble(_Symbol,SYMBOL_BID);
      request.type=ORDER_TYPE_SELL;
     }
   else
     {
      request.price=SymbolInfoDouble(_Symbol,SYMBOL_ASK);
      request.type=ORDER_TYPE_BUY;
     }
   if(OrderSend(request,result)==false)
      PrintFormat("OrderSend error %d",GetLastError());
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CalculationIndicator()
  {
//---
   int bar=iPrice==PRICE_OPEN? 0:1,cnt=0;
   if(TypeInd==Classical)
     {
      double mean=0,mad=0;
      for(int i=0; i<iPeriod; i++)
         mean=mean+CPrice(bar+i);
      mean=mean/iPeriod;
      for(int i=0; i<iPeriod; i++)
         mad=mad+MathAbs(CPrice(bar+i)-mean);
      return(mad>0? 100*iPeriod*(CPrice(bar)-mean)/mad:0);
     }
//---
   if(TypeInd==Square)
     {
      double sumS=0,sumQ=0;
      for(int i=0; i<iPeriod; i++)
        {
         double p=CPrice(bar+i);
         sumS=sumS+p;
         sumQ=sumQ+p*p;
        }
      double denom=MathSqrt(iPeriod*sumQ-sumS*sumS);
      return(denom>0? 100*(iPeriod*CPrice(bar)-sumS)/denom:0);
     }
//---
   for(int i=iPeriod-2; i>=0; i--)
     {
      double p=CPrice(bar+i);
      for(int j=iPeriod-1; j>i; j--)
        {
         halfsums[cnt]=p+CPrice(bar+j);
         cnt++;
        }
     }
   ArraySort(halfsums);
   double mean=(halfsums[indx10]+halfsums[indx11])/4;
   for(int i=0; i<iPeriod; i++)
      diff[i]=MathAbs(CPrice(bar+i)-mean);
   ArraySort(diff);
   double sd=(diff[indx20]+diff[indx21])/2;
   return(sd>0? 100*(CPrice(bar)-mean)/sd:0);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CPrice(int i)
  {
//---
   if(iPrice==PRICE_CLOSE)
      return(iClose(_Symbol,PERIOD_CURRENT,i));
   if(iPrice==PRICE_OPEN)
      return(iOpen(_Symbol,PERIOD_CURRENT,i));
   if(iPrice==PRICE_HIGH)
      return(iHigh(_Symbol,PERIOD_CURRENT,i));
   if(iPrice==PRICE_LOW)
      return(iLow(_Symbol,PERIOD_CURRENT,i));
   if(iPrice==PRICE_MEDIAN)
      return((iHigh(_Symbol,PERIOD_CURRENT,i)+iLow(_Symbol,PERIOD_CURRENT,i))/2);
   if(iPrice==PRICE_TYPICAL)
      return((iHigh(_Symbol,PERIOD_CURRENT,i)+iLow(_Symbol,PERIOD_CURRENT,i)+iClose(_Symbol,PERIOD_CURRENT,i))/3);
   return((iHigh(_Symbol,PERIOD_CURRENT,i)+iLow(_Symbol,PERIOD_CURRENT,i)+2*iClose(_Symbol,PERIOD_CURRENT,i))/4);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool NewBar()
  {
//---
   static long last_bar;
   long cur_bar=SeriesInfoInteger(_Symbol,PERIOD_CURRENT,SERIES_LASTBAR_DATE);
   if(last_bar<cur_bar)
     {
      last_bar=cur_bar;
      return(true);
     }
   return(false);
//---
  }
//+------------------------------------------------------------------+
