//+------------------------------------------------------------------+
//|                                                           T3.mq5 |
//|                        Copyright 2010, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
//---- Drawing the indicator in the main window
#property indicator_chart_window
//---- one buffer is used for calculation and drawing of the indicator
#property indicator_buffers 1
//---- only one plot is used
#property indicator_plots   1
//---- drawing of the indicator as a line
#property indicator_type1   DRAW_LINE
//---- red color is used as the color of the indicator line
#property indicator_color1  LimeGreen

//---- input parameters of the indicator
input int T3Period = 14; // period of the moving average
input double b = 0.7;
input int T3Shift = 0; // horizontal shift of the moving average in bars 

//---- declaration of a dynamic array that further 
                // will be used an indicator buffer
double ExtLineBuffer[]; 
//---- declaration of variables for storing coefficients
double n, w1, w2, b2, b3, c1, c2, c3, c4;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----+
   //---- transformation of the dynamic array ExtLineBuffer into an indicator buffer
   SetIndexBuffer(0, ExtLineBuffer, INDICATOR_DATA);
   //---- performing the horizontal shift of the moving average by T3Shift
   PlotIndexSetInteger(0, PLOT_SHIFT, T3Shift);
   //---- initialization of variables
   b2 = b * b;
   b3 = b2 * b;
   c1 = -b3;
   c2 = 3 * (b2 + b3);
   c3 = -3 * (2 * b2 + b + b3);
   c4 = 1 + 3 * b + b3 + 3 * b2;
   n = T3Period;
   if(n < 1) n = 1;
   n = 1 + 0.5 * (n - 1);
   w1 = 2 / (n + 1);
   w2 = 1 - w1;
//----+
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate
 (
  const int rates_total, // amount of history in bars at the current tick
   const int prev_calculated, // amount of history in bars at the previous tick
    const int begin, // number of beginning of reliable counting of bars
     const double &price[] // price array for calculation of the indicator
     )
  {
//----+   
   //---- checking the number of bars to be enough for the calculation
   if (rates_total < T3Period - 1 + begin) return(0);
   
   //---- declaration of local variables 
   int first, bar, iii;
   double e1, e2, e3, e4, e5, e6, T3;
   //---- declaration of static variables for storing real values of coefficients
   static double e1_, e2_, e3_, e4_, e5_, e6_;
   
   //---- calculation of the starting number 'first' for the cycle of recalculation of bars
   if (prev_calculated == 0) // checking for the first start of the indicator calculation
    {
     first = begin; // starting number for calculation of all bars
     //---- the starting initialization of calculated coefficients
     e1_ = price[first];
     e2_ = price[first];
     e3_ = price[first];
     e4_ = price[first];
     e5_ = price[first];
     e6_ = price[first];
    }
   else first = prev_calculated - 1; // starting number for calculation of new bars
   
   //---- restore vales of the variables
   e1 = e1_;
   e2 = e2_;
   e3 = e3_;
   e4 = e4_;
   e5 = e5_;
   e6 = e6_;

   //---- main cycle of calculation of the indicator
   for(bar = first; bar < rates_total; bar++)
    {
     //---- memorize values of the variables before running at the current bar
     if (rates_total != prev_calculated && bar == rates_total - 1)
      {
       e1_ = e1;
       e2_ = e2;
       e3_ = e3;
       e4_ = e4;
       e5_ = e5;
       e6_ = e6;
      }
     
     //---- performing calculation of the T3 moving average
     e1 = w1 * price[bar] + w2 * e1;
     e2 = w1 * e1 + w2 * e2;
     e3 = w1 * e2 + w2 * e3;
     e4 = w1 * e3 + w2 * e4;
     e5 = w1 * e4 + w2 * e5;
     e6 = w1 * e5 + w2 * e6;
     T3 = c1 * e6 + c2 * e5 + c3 * e4 + c4 * e3;
     
     //---- Initialization of a cell of the indicator buffer with the received value of  T3
     ExtLineBuffer[bar] = T3;
    }
//----+     
   return(rates_total);
  }
//+------------------------------------------------------------------+
