//+X================================================================X+
//|                                                        AMkA_.mq5 |
//|              MQL4 Code:  Copyright  2004, GOODMAN & Mstera  AF |
//|              MQL5 Code:     Copyright  2010,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+X================================================================X+
//---- author of the indicator
#property copyright "Copyright  2004, by GOODMAN & Mstera  AF"
//---- link to the website of the author
#property link      "http://forum.viac.ru/viewforum.php?f=7"
//---- number of version of the indicator
#property version   "1.00"
//---- drawing the indicator in the main window
#property indicator_chart_window 
//----two buffers are used for calculation of drawing of the indicator
#property indicator_buffers 3
//---- two plots are used
#property indicator_plots   3
//+----------------------------------------------+
//|  Parameters of drawing the AMA line          |
//+----------------------------------------------+
//---- drawing the indicator 1 as a line
#property indicator_type1   DRAW_LINE
//---- blue color is used as the color of a bullish candlestick
#property indicator_color1  BlueViolet
//---- line of the indicator 1 is a continuous line
#property indicator_style1  STYLE_SOLID
//---- thickness of line of the indicator 1 is equal to 3
#property indicator_width1  3
//---- displaying of the bullish label of the indicator
#property indicator_label1  "AMA"
//+----------------------------------------------+
//|  Parameter of drawing the bearish indicator  |
//+----------------------------------------------+
//---- drawing the indicator 2 as a line
#property indicator_type2   DRAW_ARROW
//---- red color is used as the color of the bearish indicator
#property indicator_color2  Red
//---- thickness of line of the indicator 2 is equal to 2
#property indicator_width2  2
//---- displaying of the bearish label of the indicator
#property indicator_label2  "Dn_Signal"
//+----------------------------------------------+
//|  Parameters of drawing the bullish indicator |
//+----------------------------------------------+
//---- drawing the indicator 3 as a symbol
#property indicator_type3   DRAW_ARROW
//---- green color is used as the color of the bullish indicator
#property indicator_color3  Lime
//---- thickness of line if the indicator 3 is equal to 2
#property indicator_width3  2
//---- displaying of the bullish label of the indicator
#property indicator_label3  "Up_Signal"
//+----------------------------------------------+
//| Input parameters of the indicator            |
//+----------------------------------------------+
input int ama_period = 9; // period of AMA
input int fast_ma_period = 2; // period of fast MA
input int slow_ma_period = 30; // period of slow MA
input double G = 2.0; // a power the smoothing constant is raised to
input int AMAShift = 0; // horizontal shift of the indicator in bar 
input double dK = 1.0;  //coefficient for the filter
//+----------------------------------------------+
//---- declaration of dynamic arrays that further  
// will be used as indicator buffers
double AMABuffer[];
double BearsBuffer[];
double BullsBuffer[];
//----+ declaration of a variable with the floating point for constants
double dSC, slowSC, fastSC; int AMA_Handle, dAMA_Handle;
//+X================================================================X+
//| Custom indicator initialization function                         |
//+X================================================================X+ 
void OnInit()
  {
//----+
//---- transformation of the dynamic array AMABuffer into an indicator buffer
   SetIndexBuffer(0, AMABuffer, INDICATOR_DATA);
//---- performing the horizontal shift of the indicator 1 by ama_shift
   PlotIndexSetInteger(0,PLOT_SHIFT, AMAShift);
//---- performing shift of the beginning of counting of drawing the indicator 1 by 1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN, ama_period + 1);
//--- creation of a label to be displayed in the Data Window
   PlotIndexSetString(0,PLOT_LABEL, "AMA");
//--- restriction to draw empty values for the indicator
   PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, 0.0);

//---- transformation of the BearsBuffer dynamic array into an indicator buffer
   SetIndexBuffer(1, BearsBuffer, INDICATOR_DATA);
//---- performing the horizontal shift of the indicator 2 by ama_shift
   PlotIndexSetInteger(1,PLOT_SHIFT, AMAShift);
//---- performing shift of the beginning of counting of drawing the indicator 2 by ama_period + 2
   PlotIndexSetInteger(1, PLOT_DRAW_BEGIN, ama_period + 2);
//--- creation of a label to be displayed in the Data Window
   PlotIndexSetString(1,PLOT_LABEL, "DnSignal");
//--- selecting symbol for drawing
   PlotIndexSetInteger(1,PLOT_ARROW, 159);
//--- restriction to draw empty values for the indicator
   PlotIndexSetDouble(1, PLOT_EMPTY_VALUE, 0.0);

//---- transformation of the dynamic array BullsBuffer into an indicator buffer
   SetIndexBuffer(2, BullsBuffer, INDICATOR_DATA);
//---- performing the horizontal shift of the indicator 3 by ama_shift
   PlotIndexSetInteger(2,PLOT_SHIFT, AMAShift);
//---- performing shift of the beginning of drawing the indicator 3 by ama_period + 2
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN, ama_period + 2);
//--- creation of a label to be displayed in the Data Window
   PlotIndexSetString(2,PLOT_LABEL, "UpSignal");
//--- selecting symbol for drawing
   PlotIndexSetInteger(2,PLOT_ARROW, 159);
//--- restriction to draw empty values for the indicator
   PlotIndexSetDouble(2, PLOT_EMPTY_VALUE, 0.0);
   
//---- initialization of a variable for a short name of the indicator
   string shortname;
   StringConcatenate(shortname,
                     "AMkA( ",ama_period,", ",fast_ma_period,", ",slow_ma_period," )");
//--- creation of the name to be displayed in a separate sub-window and in a pop up help
   IndicatorSetString(INDICATOR_SHORTNAME, shortname);
//--- determination of accuracy of displaying of the indicator values
   IndicatorSetInteger(INDICATOR_DIGITS, _Digits);
   
   //---- initialization of constants 
   slowSC = (2.0 / (slow_ma_period + 1));
   fastSC = (2.0 / (fast_ma_period + 1)); 
   dSC = fastSC - slowSC; 
//----+
  }
//+X================================================================X+
//| Custom indicator iteration function                              |
//+X================================================================X+
int OnCalculate(
                const int rates_total,    // amount of history in bars at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const int begin,          // number of beginning of reliable counting of bars
                const double &price[]     // price arrau for calculation of the indicator
               )
  {
//----+   
   //---- checking the number of bars to be enough for the calculation
   if (rates_total < 2 * ama_period + 2 + begin)
    return(0);
   
   //---- declaration of local variables 
   int first, bar, iii; 
   double noise, AMA, signal, ER, ERSC, SSC, price0, price1;
   double Sum, SMAdif, StDev, BULLS, BEARS, Filter;
   static double dAMA[], dama;
  
   //---- calculation of the starting number 'first' for the cycle of recalculation of bars
   if (prev_calculated == 0) // checking for the first start of the indicator calculation
    { 
     first = ama_period + 2 + begin; // starting number for calculation of all bars
     AMA = price[first - 1];
     if (ArrayResize(dAMA, ama_period) != ama_period) return(0); 

     //--- increase the position of the beginning of data by 'begin' bars as a result of calculation using data of another indicator
     if(begin > 0)
      {
       PlotIndexSetInteger(0, PLOT_DRAW_BEGIN,     ama_period + begin);
       PlotIndexSetInteger(1, PLOT_DRAW_BEGIN, 2 * ama_period + begin + 2);
       PlotIndexSetInteger(2, PLOT_DRAW_BEGIN, 2 * ama_period + begin + 2);
      }
    }
   else 
    {
     first = prev_calculated - 1; // starting number for calculation of new bars
     AMA = AMABuffer[first - 1];
    }

   //---- main cycle of calculation of the AMA indicator
   for(bar = first; bar < rates_total; bar++)
    {
     //---- 
     noise = Point() / 10000;
     for(iii = 0; iii < ama_period; iii++)
      {
        price0 = price[bar - iii - 0];
        price1 = price[bar - iii - 1];
        noise += MathAbs(price0 - price1);
      }
     
     price0 = price[bar];
     price1 = price[bar - ama_period];                         
     signal = MathAbs(price0 - price1);
     ER = signal / noise;
     ERSC = ER * dSC;
     SSC = ERSC + slowSC;
     AMA = AMA + (MathPow(SSC, G) * (price0 - AMA));
     //AMA = NormalizeDouble(AMA, _Digits);
          
     //---- Initialization of a cell of the indicator buffer with the received value of AMA
     AMABuffer[bar] = AMA;    
    }
    
   if(prev_calculated == 0)
    first = 2 * ama_period + 6 + begin; 
    
   //---- main cycle of calculation of the AMkA indicator
   for(bar = first; bar < rates_total; bar++)
    {
     //---- loading increments of the AMA indicator for intermediate calculations
     for(iii = 0; iii < ama_period; iii++)
      dAMA[iii] = AMABuffer[bar - iii - 0] - AMABuffer[bar - iii - 1];
      
     //---- calculating simple average of increments of AMA
     Sum = 0.0;
     for(iii = 0; iii < ama_period; iii++)
      Sum += dAMA[iii];
     SMAdif = Sum / ama_period;
     
     //---- calculating sum of  squared differences of increments and the average
     Sum = 0.0;
     for(iii = 0; iii < ama_period; iii++)
      Sum += MathPow(dAMA[iii] - SMAdif, 2);
     
     //---- calculating the total value of the standard deviation StDev from the increment of AMA
     StDev = MathSqrt(Sum / ama_period);

     //---- initialization of variables
     dama = NormalizeDouble(dAMA[0], _Digits + 2);
     Filter = NormalizeDouble(dK * StDev, _Digits + 2);
     BEARS = 0;
     BULLS = 0;
    
     //---- calculation of the indicator values
     if(dama < -Filter) BEARS = AMABuffer[bar]; //  
     if(dama > +Filter) BULLS = AMABuffer[bar]; //there is a rising trend
 
     //---- initialization of cells of the indicator buffers with obtained values 
     BullsBuffer[bar] = BULLS;
     BearsBuffer[bar] = BEARS;
    }
//----+     
   return(rates_total);
  }
//+X----------------------+ <<< The End >>> +-----------------------X+
