//+------------------------------------------------------------------+
//|                                                         AMkA.mq5 |
//|                        Copyright 2010, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
//---- author of the indicator
#property copyright "2010, MetaQuotes Software Corp."
//---- link to the website of the author
#property link      "http://www.mql5.com"
//---- number of version of the indicator
#property version   "1.00"
//---- drawing the indicator in the main window
#property indicator_chart_window 
//----two buffers are used for calculation of drawing of the indicator
#property indicator_buffers 3
//---- two plots are used
#property indicator_plots   3
//+----------------------------------------------+
//|  Parameters of drawing the AMA line          |
//+----------------------------------------------+
//---- drawing the indicator 1 as a line
#property indicator_type1   DRAW_LINE
//---- blue color is used as the color of a bullish candlestick
#property indicator_color1  BlueViolet
//---- line of the indicator 1 is a continuous line
#property indicator_style1  STYLE_SOLID
//---- thickness of line of the indicator 1 is equal to 3
#property indicator_width1  3
//---- displaying of the bullish label of the indicator
#property indicator_label1  "AMA"
//+----------------------------------------------+
//|  Parameter of drawing the bearish indicator  |
//+----------------------------------------------+
//---- drawing the indicator 2 as a line
#property indicator_type2   DRAW_ARROW
//---- red color is used as the color of the bearish indicator
#property indicator_color2  Red
//---- thickness of line of the indicator 2 is equal to 2
#property indicator_width2  2
//---- displaying of the bearish label of the indicator
#property indicator_label2  "Dn_Signal"
//+----------------------------------------------+
//|  Parameters of drawing the bullish indicator |
//+----------------------------------------------+
//---- drawing the indicator 3 as a symbol
#property indicator_type3   DRAW_ARROW
//---- green color is used as the color of the bullish indicator
#property indicator_color3  Lime
//---- thickness of line if the indicator 3 is equal to 2
#property indicator_width3  2
//---- displaying of the bullish label of the indicator
#property indicator_label3  "Up_Signal"
//+----------------------------------------------+
//| Input parameters of the indicator            |
//+----------------------------------------------+
input int ama_period = 9; // period of AMA
input int fast_ma_period = 2; // period of fast MA
input int slow_ma_period = 30; // period of slow MA
input int  ama_shift = 0; // horizontal shift of the indicator
input ENUM_APPLIED_PRICE  applied_price = PRICE_CLOSE; // type of price or handle
input double dK = 1.0;  //coefficient for the filter
//+----------------------------------------------+
//---- declaration of dynamic arrays that further  
// will be used as indicator buffers
double AMABuffer[];
double BearsBuffer[];
double BullsBuffer[];
//---- declaration of a variable for storing handle of the dAMA indicator
int dAMAHandle;
//---- declaration of a variable for storing handle of the StdDev indicator
int StdDevHandle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----+
//---- transformation of the dynamic array AMABuffer into an indicator buffer
   SetIndexBuffer(0, AMABuffer, INDICATOR_DATA);
//---- performing the horizontal shift of the indicator 1 by ama_shift
   PlotIndexSetInteger(0, PLOT_SHIFT, ama_shift);
//---- performing shift of the beginning of counting of drawing the indicator 1 by 1
   PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, ama_period + 1);
//--- creation of a label to be displayed in the Data Window
   PlotIndexSetString(0, PLOT_LABEL, "AMA");

//---- transformation of the BearsBuffer dynamic array into an indicator buffer
   SetIndexBuffer(1, BearsBuffer, INDICATOR_DATA);
//---- performing the horizontal shift of the indicator 2 by ama_shift
   PlotIndexSetInteger(1, PLOT_SHIFT, ama_shift);
//---- performing shift of the beginning of counting of drawing the indicator 2 by ama_period + 2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN, ama_period + 2);
//--- creation of a label to be displayed in the Data Window
   PlotIndexSetString(1, PLOT_LABEL, "DnSignal");
//--- selecting symbol for drawing
   PlotIndexSetInteger(1, PLOT_ARROW, 159);

//---- transformation of the dynamic array BullsBuffer into an indicator buffer
   SetIndexBuffer(2, BullsBuffer, INDICATOR_DATA);
//---- performing the horizontal shift of the indicator 3 by ama_shift
   PlotIndexSetInteger(2, PLOT_SHIFT, ama_shift);
//---- performing shift of the beginning of drawing the indicator 3 by ama_period + 2
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN, ama_period + 2);
//--- creation of a label to be displayed in the Data Window
   PlotIndexSetString(2, PLOT_LABEL, "UpSignal");
//--- selecting symbol for drawing
   PlotIndexSetInteger(2, PLOT_ARROW, 159);

//---- initialization of a variable for a short name of the indicator
   string shortname;
   StringConcatenate(shortname, "AMkA( ",ama_period,", ",fast_ma_period,", ",slow_ma_period," )");
//---- creation of the name to be displayed in a separate sub-window and in a pop up help
   IndicatorSetString(INDICATOR_SHORTNAME, shortname);
//---- determination of accuracy of displaying of the indicator values
   IndicatorSetInteger(INDICATOR_DIGITS, _Digits);

//----+ Getting handle of the dAMA indicator
   dAMAHandle = iCustom(NULL, 0, "dAMA", ama_period, fast_ma_period, slow_ma_period, ama_shift, applied_price);
   if (dAMAHandle == INVALID_HANDLE)Print(" Failed to get handle of the dAMA indicator");

//----+ Getting handle of the technical indicator
// StdDev calculated from values of the dAMA indicator
   StdDevHandle = iStdDev(NULL, 0, ama_period, 0, MODE_SMA, dAMAHandle);
   if (StdDevHandle == INVALID_HANDLE)Print(" Failed to get handle of the StdDev indicator");

//----+ Indexation of elements in buffers as in timeseries
   ArraySetAsSeries(AMABuffer,true);
   ArraySetAsSeries(BearsBuffer,true);
   ArraySetAsSeries(BullsBuffer,true);
//----+
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//----+
//--- Release handles of the indicators
   IndicatorRelease(dAMAHandle);
   IndicatorRelease(StdDevHandle);
//----+   
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate
(
 const int rates_total,
 const int prev_calculated,
 const int begin,
 const double &price[]
 )
  {
//----+   
//---- checking the number of bars to be enough for the calculation 
// and checking of calculated bars in the called indicators
   if (rates_total < 2 * ama_period + 2 + begin)   return(0);
   if (BarsCalculated(dAMAHandle)   < rates_total) return(0);
   if (BarsCalculated(StdDevHandle) < rates_total) return(0);

//---- declaration of local variables 
   int limit, bar;
   double BULLS, BEARS, Filter;
   
//---- declaration of local arrays
   double dAMA_Array[], StdDev_Array[];
//---- indexation of elements in arrays as in timeseries
   ArraySetAsSeries(dAMA_Array, true);
   ArraySetAsSeries(StdDev_Array, true);

//--- calculation of amount data to be copied
   int to_copy;
   if(prev_calculated > rates_total || prev_calculated <= 0)// checking for the first start of calculation of an indicator
        to_copy = rates_total - begin; // calculated number of all bars
   else to_copy = rates_total - prev_calculated + 1; // calculated number of new bars only
   
//--- copy the newly appeared data into the indicator buffer and local, dynamic arrays
   if(CopyBuffer(dAMAHandle,   1, 0, to_copy, AMABuffer   ) <= 0) return(0);
   if(CopyBuffer(dAMAHandle,   0, 0, to_copy, dAMA_Array  ) <= 0) return(0);
   if(CopyBuffer(StdDevHandle, 0, 0, to_copy, StdDev_Array) <= 0) return(0);

//---- calculation of the starting number 'first' for the cycle of recalculation of bars
   if(prev_calculated > rates_total || prev_calculated <= 0) //      
        limit = rates_total - 2 * ama_period - 2 - begin; // starting number for calculation of all bars
   else limit = rates_total - prev_calculated; // starting number for calculation of new bars

//---- main cycle of calculation of the indicator
   for(bar = limit; bar >= 0; bar--)
     {
      //---- initialization of variables
      Filter = dK * StdDev_Array[bar];
      BEARS = 0;
      BULLS = 0;

      //---- calculation of the indicator values
    if(NormalizeDouble(dAMA_Array[bar], _Digits) < -NormalizeDouble(Filter, _Digits)) BEARS = AMABuffer[bar]; //there is descending trend
    if(NormalizeDouble(dAMA_Array[bar], _Digits) > +NormalizeDouble(Filter, _Digits)) BULLS = AMABuffer[bar]; //there is a rising trend
 
      //---- initialization of cells of the indicator buffers with obtained values 
      BullsBuffer[bar] = BULLS;
      BearsBuffer[bar] = BEARS;
     }
//----+     
   return(rates_total);
  }
//+------------------------------------------------------------------+
