//+------------------------------------------------------------------+
//|                                                       AMA_Ex.mq5 |
//|              MQL4 Code:  Copyright  2004, GOODMAN & Mstera  AF |
//|              MQL5 Code:     Copyright  2010,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
//---- author of the indicator
#property copyright "Copyright  2004, by GOODMAN & Mstera  AF"
//---- link to the website of the author
#property link      "http://forum.viac.ru/viewforum.php?f=7"
//---- number of version of the indicator
#property version   "1.00"
//---- Drawing the indicator in the main window
#property indicator_chart_window
//---- one buffer is used for calculation and drawing of the indicator
#property indicator_buffers 1
//---- only one plot is used
#property indicator_plots   1
//---- drawing of the indicator as a line
#property indicator_type1   DRAW_LINE
//---- blue color is used as the color of the indicator line
#property indicator_color1  Blue
//---- the indicator line is a continuous line
#property indicator_style1  STYLE_SOLID
//---- thickness of the indicator line is 2
#property indicator_width1  2
//---- displaying labels of the indicator
#property indicator_label1  "AMA"

//+----------------------------------------------+
//| Input parameters of the indicator            |
//+----------------------------------------------+
input int ama_period = 9; // period of AMA
input int fast_ma_period = 2; // period of fast MA
input int slow_ma_period = 30; // period of slow MA
input double G = 2.0; // a power the smoothing constant is raised to
input int AMAShift = 0; // horizontal shift of the indicator in bar 
//+----------------------------------------------+
//---- declaration of a dynamic array that further 
                // will be used an indicator buffer
double ExtLineBuffer[]; 
//----+ declaration of a variable with the floating point for constants
double dSC, slowSC, fastSC;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----+
   //---- transformation of the dynamic array ExtLineBuffer into an indicator buffer
   SetIndexBuffer(0, ExtLineBuffer, INDICATOR_DATA);
   //---- performing the horizontal shift of the indicator by AMAShift
   PlotIndexSetInteger(0, PLOT_SHIFT, AMAShift);
   //---- performing the shift of beginning of indicator drawing
   PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, 1);
   //---- initialization of a variable for a short name of the indicator
   string shortname;
   StringConcatenate(shortname, "AMA(", ama_period, ")");
   //--- creation of a label to be displayed in the Data Window
   PlotIndexSetString(0, PLOT_LABEL, shortname);   
   //--- creation of the name to be displayed in a separate sub-window and in a pop up help
   IndicatorSetString(INDICATOR_SHORTNAME, shortname);
   //--- determination of accuracy of displaying of the indicator values
   IndicatorSetInteger(INDICATOR_DIGITS, _Digits + 1);
   //--- restriction to draw empty values for the indicator
   PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, 0.0);
   
   //---- initialization of constants 
   slowSC = (2.0 / (slow_ma_period + 1));
   fastSC = (2.0 / (fast_ma_period + 1)); 
   dSC = fastSC - slowSC; 
//----+
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    // amount of history in bars at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const int begin,          // number of beginning of reliable counting of bars
                const double &price[]     // price arrau for calculation of the indicator
               )
  {
//----+   
   //---- checking the number of bars to be enough for the calculation
   if (rates_total < ama_period + 2 + begin)
    return(0);
   
   //---- declaration of local variables 
   int first, bar; 
   double noise, AMA, signal, ER, ERSC, SSC, price0, price1;

   //---- calculation of the starting number 'first' for the cycle of recalculation of bars
   if (prev_calculated == 0) // checking for the first start of the indicator calculation
    { 
     first = ama_period + 2 + begin; // starting number for calculation of all bars
     AMA = price[first - 1];
     //--- increase the position of the beginning of data by 'begin' bars as a result of calculation using data of another indicator
     if(begin > 0)
      PlotIndexSetInteger(0, PLOT_DRAW_BEGIN, ama_period + begin);
    }
   else 
    {
     first = prev_calculated - 1; // starting number for calculation of new bars
     AMA = ExtLineBuffer[first - 1];
    }

   //---- main cycle of calculation of the indicator
   for(bar = first; bar < rates_total - 1; bar++)
    {
     //---- 
     noise = Point() / 100000;
     for(int jjj = 0; jjj < ama_period; jjj++)
      {
        price0 = price[bar - jjj - 0];
        price1 = price[bar - jjj - 1];
        noise += MathAbs(price0 - price1);
      }
     
     price0 = price[bar];
     price1 = price[bar - ama_period];                         
     signal = MathAbs(price0 - price1);
     ER = signal / noise;
     ERSC = ER * dSC;
     SSC = ERSC + slowSC;
     AMA = AMA + (MathPow(SSC, G) * (price0 - AMA));  
          
     //---- Initialization of a cell of the indicator buffer with the received value of AMA
     ExtLineBuffer[bar] = AMA;
    }
//----+     
   return(rates_total);
  }
//+------------------------------------------------------------------+
