//+------------------------------------------------------------------+
//|                                              HighLowRainbow2.mq4 |
//|                                Copyright  2010, Investors Haven |
//|                                    http://www.InvestorsHaven.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, Investors Haven"
#property link      "http://www.InvestorsHaven.com"

#property indicator_chart_window
#property indicator_buffers 8
#property indicator_color1 Blue              // Sets the colors of the second
#property indicator_color2 Blue              // 8 lines of the 24 line set
#property indicator_color3 HotPink
#property indicator_color4 HotPink
#property indicator_color5 Orange
#property indicator_color6 Orange
#property indicator_color7 Orchid
#property indicator_color8 Orchid
#property indicator_width1 3          // Sets the width of the lins in pixels
#property indicator_width2 3
#property indicator_width3 3
#property indicator_width4 3
#property indicator_width5 3
#property indicator_width6 3
#property indicator_width7 3
#property indicator_width8 3


int BandsPeriod = 20;                  // sets an initial amount on the
//---- buffers                         // lines prior to displaying them
double Hour1High[];                    // Array buffer for 1 Hour High
double Hour1Low[];                     // Array buffer for 1 Hour Low
double M30High[];                      // Array buffer for 30 Minute High
double M30Low[];                       // Array buffer for 30 Minute Low
double M15High[];                      // Array buffer for 15 Minute High
double M15Low[];                       // Array buffer for 15 Minute Low
double M5High[];                       // Array buffer for 5 Minute High
double M5Low[];                        // Array buffer for 5 Minute Low
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE);            // Section draws the lines for each
   SetIndexBuffer(0,Hour1High);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,Hour1Low);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,M30High);
   SetIndexStyle(3,DRAW_LINE);
   SetIndexBuffer(3,M30Low);
   SetIndexStyle(4,DRAW_LINE);
   SetIndexBuffer(4,M15High);
   SetIndexStyle(5,DRAW_LINE);
   SetIndexBuffer(5,M15Low);
   SetIndexStyle(6,DRAW_LINE);
   SetIndexBuffer(6,M5High);
   SetIndexStyle(7,DRAW_LINE);
   SetIndexBuffer(7,M5Low);
   
   SetIndexDrawBegin(0,BandsPeriod);         // Sets the lines starting point
   SetIndexDrawBegin(1,BandsPeriod);
   SetIndexDrawBegin(2,BandsPeriod);
   SetIndexDrawBegin(3,BandsPeriod);
   SetIndexDrawBegin(4,BandsPeriod);
   SetIndexDrawBegin(5,BandsPeriod);
   SetIndexDrawBegin(6,BandsPeriod);
   SetIndexDrawBegin(7,BandsPeriod);
   
   SetIndexLabel(0,"1Hour High");         // Label the lines for easy reading
   SetIndexLabel(1,"1Hour Low");
   SetIndexLabel(2,"30M High");
   SetIndexLabel(3,"30M Low");
   SetIndexLabel(4,"15M High");
   SetIndexLabel(5,"15M Low");
   SetIndexLabel(6,"5M High");
   SetIndexLabel(7,"5M Low");
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
//----
   if(Bars<=BandsPeriod) return(0);    // exit if we don't have enough bars
   
   int    i,counted_bars=IndicatorCounted();    // Init variables
   
   //---- initial zero
   if(counted_bars<1)                        // No bars have been counted
   {
      for(i=1;i<=BandsPeriod;i++)            // Loop through assigning
        {                                    // all lines to empty
            Hour1High[Bars-i]=EMPTY_VALUE;   // so lines are  clean
            Hour1Low[Bars-i]=EMPTY_VALUE;
            M30High[Bars-i]=EMPTY_VALUE;
            M30Low[Bars-i]=EMPTY_VALUE;
            M15High[Bars-i]=EMPTY_VALUE;
            M15Low[Bars-i]=EMPTY_VALUE;
            M5High[Bars-i]=EMPTY_VALUE;
            M5Low[Bars-i]=EMPTY_VALUE;        
        }
     }
     
   int limit=Bars-counted_bars;                 // determine our limit
   if(counted_bars>0) limit++;                  // Track our limit as we count
   for(i=0; i<limit; i++)                       // Now loop through and assign
   {                                      // price values to lines via buffers
      Hour1High[i]= iHigh(NULL,PERIOD_H1,0);    // get high for 1 hour
      Hour1Low[i]= iLow(NULL,PERIOD_H1,0);      // get low for 1 hour
      M30High[i]= iHigh(NULL,PERIOD_M30,0);     // get high for 30 min
      M30Low[i]= iLow(NULL,PERIOD_M30,0);       // get low for 30 min
      M15High[i]= iHigh(NULL,PERIOD_M15,0);     // get high for 15 min
      M15Low[i]= iLow(NULL,PERIOD_M15,0);       // get low for 15 min
      M5High[i]= iHigh(NULL,PERIOD_M5,0);       // get high for 5 min
      M5Low[i]= iLow(NULL,PERIOD_M5,0);         // get low for 5 min
  }

   
//----
   return(0);
  }
//+------------------------------------------------------------------+