//|------------------------------------------------------------------|
//|                                                   ExtObjects.mqh |
//|                                      Copyright 2012, Torma Gbor |
//|                                              tormagabor@hmail.hu |
//|------------------------------------------------------------------|

#property copyright "Copyright 2012, Torma Gbor"
#property link      "tormagabor@hmail.hu"

/*** INTEGER ***/
bool ObjectSetColor(long ChartID,string Name,color Color)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_COLOR,Color));
  }
color ObjectGetColor(long ChartID,string Name)
  {
   return(color(ObjectGetInteger(ChartID,Name,OBJPROP_COLOR)));
  }
bool ObjectSetStyle(long ChartID,string Name,ENUM_LINE_STYLE Style)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_STYLE,Style));
  }
ENUM_LINE_STYLE ObjectGetStyle(long ChartID,string Name)
  {
   ENUM_LINE_STYLE result=ENUM_LINE_STYLE(ObjectGetInteger(ChartID,Name,OBJPROP_STYLE));
   return(result);
  }
bool ObjectSetWidth(long ChartID,string Name,int Width)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_WIDTH,Width));
  }
int ObjectGetWidth(long ChartID,string Name)
  {
   return(int(ObjectGetInteger(ChartID,Name,OBJPROP_WIDTH)));
  }
bool ObjectSetBack(long ChartID,string Name,bool Back)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_BACK,Back));
  }
bool ObjectGetBack(long ChartID,string Name)
  {
   return(ObjectGetInteger(ChartID,Name,OBJPROP_BACK));
  }
bool ObjectSetZOrder(long ChartID,string Name,long ZOrder)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_ZORDER,ZOrder));
  }
long ObjectGetZOrder(long ChartID,string Name)
  {
   return(ObjectGetInteger(ChartID,Name,OBJPROP_ZORDER));
  }
bool ObjectSetFill(long ChartID,string Name,bool Fill)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_FILL,Fill));
  }
bool ObjectGetFill(long ChartID,string Name)
  {
   return(ObjectGetInteger(ChartID,Name,OBJPROP_FILL));
  }
bool ObjectSetHidden(long ChartID,string Name,bool Hidden)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_HIDDEN,Hidden));
  }
bool ObjectGetHidden(long ChartID,string Name)
  {
   return(ObjectGetInteger(ChartID,Name,OBJPROP_HIDDEN));
  }
bool ObjectSetSelected(long ChartID,string Name,bool Selected)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_SELECTED,Selected));
  }
bool ObjectGetSelected(long ChartID,string Name)
  {
   return(ObjectGetInteger(ChartID,Name,OBJPROP_SELECTED));
  }
bool ObjectSetReadOnly(long ChartID,string Name,bool ReadOnly)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_READONLY,ReadOnly));
  }
bool ObjectGetReadOnly(long ChartID,string Name)
  {
   return(ObjectGetInteger(ChartID,Name,OBJPROP_READONLY));
  }
bool ObjectSetTime(long ChartID,string Name,datetime Time)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_TIME,Time));
  }
datetime ObjectGetTime(long ChartID,string Name,datetime Time)
  {
   return(datetime(ObjectGetInteger(ChartID,Name,OBJPROP_TIME)));
  }
bool ObjectSetTime(long ChartID,string Name,int Modifier,datetime Time)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_TIME,Modifier,Time));
  }
datetime ObjectGetTime(long ChartID,string Name,int Modifier)
  {
   return(datetime(ObjectGetInteger(ChartID,Name,OBJPROP_TIME,Modifier)));
  }
bool ObjectSetTime(long ChartID,string Name,datetime Time1,datetime Time2)
  {
   return(ObjectSetTime(ChartID,Name,0,Time1) && 
          ObjectSetTime(ChartID,Name,1,Time2));
  }
bool ObjectSetTime(long ChartID,string Name,datetime Time1,datetime Time2,datetime Time3)
  {
   return(ObjectSetTime(ChartID,Name,0,Time1) && 
          ObjectSetTime(ChartID,Name,1,Time2) && 
          ObjectSetTime(ChartID,Name,2,Time3));
  }
bool ObjectSetType(long ChartID,string Name,ENUM_OBJECT Type)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_TYPE,Type));
  }
ENUM_OBJECT ObjectGetType(long ChartID,string Name)
  {
   ENUM_OBJECT result=ENUM_OBJECT(ObjectGetInteger(ChartID,Name,OBJPROP_TYPE));
   return(result);
  }
bool ObjectSetSelectable(long ChartID,string Name,bool Selectable)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_SELECTABLE,Selectable));
  }
bool ObjectGetSelectable(long ChartID,string Name)
  {
   return(ObjectGetInteger(ChartID,Name,OBJPROP_SELECTABLE));
  }
datetime ObjectGetCreateTime(long ChartID,string Name)
  {
   return(datetime(ObjectGetInteger(ChartID,Name,OBJPROP_CREATETIME)));
  }
bool ObjectSetLevels(long ChartID,string Name,int Levels)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_LEVELS,Levels));
  }
int ObjectGetLevels(long ChartID,string Name)
  {
   return(int(ObjectGetInteger(ChartID,Name,OBJPROP_LEVELS)));
  }
bool ObjectSetLevelColor(long ChartID,string Name,color LevelColor)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_LEVELCOLOR,LevelColor));
  }
bool ObjectSetLevelColor(long ChartID,string Name,int Modifier,color LevelColor)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_LEVELCOLOR,Modifier,LevelColor));
  }
color ObjectGetLevelColor(long ChartID,string Name)
  {
   return(color(ObjectGetInteger(ChartID,Name,OBJPROP_LEVELCOLOR)));
  }
color ObjectGetLevelColor(long ChartID,string Name,int Modifier)
  {
   return(color(ObjectGetInteger(ChartID,Name,OBJPROP_LEVELCOLOR,Modifier)));
  }
bool ObjectSetLevelStyle(long ChartID,string Name,ENUM_LINE_STYLE LevelStyle)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_LEVELSTYLE,LevelStyle));
  }
bool ObjectSetLevelStyle(long ChartID,string Name,int Modifier,ENUM_LINE_STYLE LevelStyle)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_LEVELSTYLE,Modifier,LevelStyle));
  }
ENUM_LINE_STYLE ObjectGetLevelStyle(long ChartID,string Name,int Modifier)
  {
   ENUM_LINE_STYLE result=ENUM_LINE_STYLE(ObjectGetInteger(ChartID,Name,OBJPROP_LEVELSTYLE,Modifier));
   return(result);
  }
ENUM_LINE_STYLE ObjectGetLevelStyle(long ChartID,string Name)
  {
   ENUM_LINE_STYLE result=ENUM_LINE_STYLE(ObjectGetInteger(ChartID,Name,OBJPROP_LEVELSTYLE));
   return(result);
  }
bool ObjectSetLevelWidth(long ChartID,string Name,ENUM_LINE_STYLE LevelWidth)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_LEVELWIDTH,LevelWidth));
  }
bool ObjectSetLevelWidth(long ChartID,string Name,int Modifier,ENUM_LINE_STYLE LevelWidth)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_LEVELWIDTH,Modifier,LevelWidth));
  }
int ObjectGetLevelWidth(long ChartID,string Name)
  {
   return(int(ObjectGetInteger(ChartID,Name,OBJPROP_LEVELWIDTH)));
  }
int ObjectGetLevelWidth(long ChartID,string Name,int Modifier)
  {
   return(int(ObjectGetInteger(ChartID,Name,OBJPROP_LEVELWIDTH,Modifier)));
  }
bool ObjectSetAlign(long ChartID,string Name,ENUM_ALIGN_MODE Align)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_ALIGN,Align));
  }
ENUM_ALIGN_MODE ObjectGetAlign(long ChartID,string Name)
  {
   ENUM_ALIGN_MODE result=ENUM_ALIGN_MODE(ObjectGetInteger(ChartID,Name,OBJPROP_ALIGN));
   return(result);
  }
bool ObjectSetFontSize(long ChartID,string Name,int FontSize)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_FONTSIZE,FontSize));
  }
bool ObjectSetRayLeft(long ChartID,string Name,bool RayLeft)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_RAY_LEFT,RayLeft));
  }
bool ObjectGetRayLeft(long ChartID,string Name)
  {
   return(ObjectGetInteger(ChartID,Name,OBJPROP_RAY_LEFT));
  }
bool ObjectSetRayRight(long ChartID,string Name,bool RayRight)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_RAY_RIGHT,RayRight));
  }
bool ObjectGetRayRight(long ChartID,string Name)
  {
   return(ObjectGetInteger(ChartID,Name,OBJPROP_RAY_RIGHT));
  }
bool ObjectSetRay(long ChartID,string Name,bool Ray)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_RAY,Ray));
  }
bool ObjectGetRay(long ChartID,string Name)
  {
   return(ObjectGetInteger(ChartID,Name,OBJPROP_RAY));
  }
bool ObjectSetEllipse(long ChartID,string Name,bool Ellipse)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_ELLIPSE,Ellipse));
  }
bool ObjectGetEllipse(long ChartID,string Name)
  {
   return(ObjectGetInteger(ChartID,Name,OBJPROP_ELLIPSE));
  }
bool ObjectSetArrowCode(long ChartID,string Name,char ArrowCode)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_ARROWCODE,ArrowCode));
  }
char ObjectGetArrowCode(long ChartID,string Name)
  {
   return(char(ObjectGetInteger(ChartID,Name,OBJPROP_ARROWCODE)));
  }
bool ObjectSetTimeFrames(long ChartID,string Name,int TimeFrames)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_TIMEFRAMES,TimeFrames));
  }
int ObjectGetTimeFrames(long ChartID,string Name)
  {
   return(int(ObjectGetInteger(ChartID,Name,OBJPROP_TIMEFRAMES)));
  }
bool ObjectSetAnchorPoint(long ChartID,string Name,ENUM_ANCHOR_POINT AnchorPoint)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_ANCHOR,AnchorPoint));
  }
ENUM_ANCHOR_POINT ObjectGetAnchorPoint(long ChartID,string Name)
  {
   ENUM_ANCHOR_POINT result=ENUM_ANCHOR_POINT(ObjectGetInteger(ChartID,Name,OBJPROP_ANCHOR));
   return(result);
  }
bool ObjectSetArrowAnchor(long ChartID,string Name,ENUM_ARROW_ANCHOR ArrowAnchor)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_ANCHOR,ArrowAnchor));
  }
ENUM_ARROW_ANCHOR ObjectGetArrowAnchor(long ChartID,string Name)
  {
   ENUM_ARROW_ANCHOR result=ENUM_ARROW_ANCHOR(ObjectGetInteger(ChartID,Name,OBJPROP_ANCHOR));
   return(result);
  }
bool ObjectSetXDistance(long ChartID,string Name,int XDistance)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_XDISTANCE,XDistance));
  }
int ObjectGetXDistance(long ChartID,string Name)
  {
   return(int(ObjectGetInteger(ChartID,Name,OBJPROP_XDISTANCE)));
  }
bool ObjectSetLeft(long ChartID,string Name,int Left)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_XDISTANCE,Left));
  }
int ObjectGetLeft(long ChartID,string Name)
  {
   return(int(ObjectGetInteger(ChartID,Name,OBJPROP_XDISTANCE)));
  }
bool ObjectSetYDistance(long ChartID,string Name,int YDistance)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_YDISTANCE,YDistance));
  }
int ObjectGetYDistance(long ChartID,string Name)
  {
   return(int(ObjectGetInteger(ChartID,Name,OBJPROP_YDISTANCE)));
  }
bool ObjectSetTop(long ChartID,string Name,int Top)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_YDISTANCE,Top));
  }
int ObjectGetTop(long ChartID,string Name)
  {
   return(int(ObjectGetInteger(ChartID,Name,OBJPROP_YDISTANCE)));
  }
bool ObjectSetPos(long ChartID,string Name,int Left,int Top)
  {
   return(ObjectSetLeft(ChartID,Name,Left) && 
          ObjectSetTop(ChartID,Name,Top));
  }
bool ObjectSetDirection(long ChartID,string Name,ENUM_GANN_DIRECTION Direction)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_DIRECTION,Direction));
  }
ENUM_GANN_DIRECTION ObjectGetDirection(long ChartID,string Name)
  {
   ENUM_GANN_DIRECTION result=ENUM_GANN_DIRECTION(ObjectGetInteger(ChartID,Name,OBJPROP_DIRECTION));
   return(result);
  }
bool ObjectSetDegree(long ChartID,string Name,ENUM_ELLIOT_WAVE_DEGREE Degree)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_DIRECTION,Degree));
  }
ENUM_ELLIOT_WAVE_DEGREE ObjectGetDegree(long ChartID,string Name)
  {
   ENUM_ELLIOT_WAVE_DEGREE result=ENUM_ELLIOT_WAVE_DEGREE(ObjectGetInteger(ChartID,Name,OBJPROP_DEGREE));
   return(result);
  }
bool ObjectSetDrawLines(long ChartID,string Name,bool DrawLines)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_DRAWLINES,DrawLines));
  }
bool ObjectGetDrawLines(long ChartID,string Name)
  {
   return(ObjectGetInteger(ChartID,Name,OBJPROP_DRAWLINES));
  }
bool ObjectSetState(long ChartID,string Name,bool State)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_STATE,State));
  }
bool ObjectGetState(long ChartID,string Name)
  {
   return(ObjectGetInteger(ChartID,Name,OBJPROP_STATE));
  }
bool ObjectSetChartID(long ChartID,string Name,long ObjChartID)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_CHART_ID,ObjChartID));
  }
long ObjectGetChartID(long ChartID,string Name)
  {
   return(ObjectGetInteger(ChartID,Name,OBJPROP_CHART_ID));
  }
bool ObjectSetXSize(long ChartID,string Name,int XSize)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_XSIZE,XSize));
  }
int ObjectGetXSize(long ChartID,string Name)
  {
   return(int(ObjectGetInteger(ChartID,Name,OBJPROP_XSIZE)));
  }
bool ObjectSetYSize(long ChartID,string Name,int YSize)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_YSIZE,YSize));
  }
int ObjectGetYSize(long ChartID,string Name)
  {
   return(int(ObjectGetInteger(ChartID,Name,OBJPROP_YSIZE)));
  }
bool ObjectSetSize(long ChartID,string Name,int XSize,int YSize)
  {
   return(ObjectSetXSize(ChartID,Name,XSize) && 
          ObjectSetYSize(ChartID,Name,YSize));
  }
bool ObjectSetXOffset(long ChartID,string Name,int XOffset)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_XOFFSET,XOffset));
  }
int ObjectGetXOffset(long ChartID,string Name)
  {
   return(int(ObjectGetInteger(ChartID,Name,OBJPROP_XOFFSET)));
  }
bool ObjectSetYOffset(long ChartID,string Name,int YOffset)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_YOFFSET,YOffset));
  }
int ObjectGetYOffset(long ChartID,string Name)
  {
   return(int(ObjectGetInteger(ChartID,Name,OBJPROP_YOFFSET)));
  }
bool ObjectSetPeriod(long ChartID,string Name,ENUM_TIMEFRAMES Period)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_PERIOD,Period));
  }
ENUM_TIMEFRAMES ObjectGetPeriod(long ChartID,string Name)
  {
   ENUM_TIMEFRAMES result=ENUM_TIMEFRAMES(ObjectGetInteger(ChartID,Name,OBJPROP_PERIOD));
   return(result);
  }
bool ObjectSetDataScale(long ChartID,string Name,bool DataScale)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_DATE_SCALE,DataScale));
  }
bool ObjectGetDataScale(long ChartID,string Name)
  {
   return(ObjectGetInteger(ChartID,Name,OBJPROP_DATE_SCALE));
  }
bool ObjectSetPriceScale(long ChartID,string Name,bool PriceScale)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_PRICE_SCALE,PriceScale));
  }
bool ObjectGetPriceScale(long ChartID,string Name)
  {
   return(ObjectGetInteger(ChartID,Name,OBJPROP_PRICE_SCALE));
  }
bool ObjectSetChartScale(long ChartID,string Name,int ChartScale)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_CHART_SCALE,ChartScale));
  }
int ObjectGetChartScale(long ChartID,string Name)
  {
   return(int(ObjectGetInteger(ChartID,Name,OBJPROP_CHART_SCALE)));
  }
bool ObjectSetBgColor(long ChartID,string Name,color BgColor)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_BGCOLOR,BgColor));
  }
color ObjectGetBgColor(long ChartID,string Name)
  {
   return(color(ObjectGetInteger(ChartID,Name,OBJPROP_BGCOLOR)));
  }
bool ObjectSetCorner(long ChartID,string Name,ENUM_BASE_CORNER Corner)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_CORNER,Corner));
  }
ENUM_BASE_CORNER ObjectGetCorner(long ChartID,string Name)
  {
   ENUM_BASE_CORNER result=ENUM_BASE_CORNER(ObjectGetInteger(ChartID,Name,OBJPROP_CORNER));
   return(result);
  }
bool ObjectSetBorderType(long ChartID,string Name,ENUM_BORDER_TYPE BorderType)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_BORDER_TYPE,BorderType));
  }
ENUM_BORDER_TYPE ObjectGetBorderType(long ChartID,string Name)
  {
   ENUM_BORDER_TYPE result=ENUM_BORDER_TYPE(ObjectGetInteger(ChartID,Name,OBJPROP_BORDER_TYPE));
   return(result);
  }
bool ObjectSetBorderColor(long ChartID,string Name,color BorderColor)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_BORDER_COLOR,BorderColor));
  }
color ObjectGetBorderColor(long ChartID,string Name)
  {
   return(color(ObjectGetInteger(ChartID,Name,OBJPROP_BORDER_COLOR)));
  }

/*** DOUBLE ***/
bool ObjectSetPrice(long ChartID,string Name,double Price)
  {
   return(ObjectSetDouble(ChartID,Name,OBJPROP_PRICE,Price));
  }
bool ObjectSetPrice(long ChartID,string Name,int Modifier,double Price)
  {
   return(ObjectSetDouble(ChartID,Name,OBJPROP_PRICE,Modifier,Price));
  }
double ObjectGetPrice(long ChartID,string Name)
  {
   return(ObjectGetDouble(ChartID,Name,OBJPROP_PRICE));
  }
double ObjectGetPrice(long ChartID,string Name,int Modifier)
  {
   return(ObjectGetDouble(ChartID,Name,OBJPROP_PRICE,Modifier));
  }
bool ObjectSetPrice(long ChartID,string Name,double Price1,double Price2)
  {
   return(ObjectSetDouble(ChartID,Name,OBJPROP_PRICE,0,Price1) && 
          ObjectSetDouble(ChartID,Name,OBJPROP_PRICE,1,Price2));
  }
bool ObjectSetPrice(long ChartID,string Name,double Price1,double Price2,double Price3)
  {
   return(ObjectSetDouble(ChartID,Name,OBJPROP_PRICE,0,Price1) && 
          ObjectSetDouble(ChartID,Name,OBJPROP_PRICE,1,Price2) && 
          ObjectSetDouble(ChartID,Name,OBJPROP_PRICE,2,Price3));
  }
bool ObjectSetLevelValue(long ChartID,string Name,double LevelValue)
  {
   return(ObjectSetDouble(ChartID,Name,OBJPROP_LEVELVALUE,LevelValue));
  }
bool ObjectSetLevelValue(long ChartID,string Name,int Modifier,double LevelValue)
  {
   return(ObjectSetDouble(ChartID,Name,OBJPROP_LEVELVALUE,Modifier,LevelValue));
  }
double ObjectGetLevelValue(long ChartID,string Name)
  {
   return(ObjectGetDouble(ChartID,Name,OBJPROP_LEVELVALUE));
  }
double ObjectGetLevelValue(long ChartID,string Name,int Modifier)
  {
   return(ObjectGetDouble(ChartID,Name,OBJPROP_LEVELVALUE,Modifier));
  }
bool ObjectSetScale(long ChartID,string Name,double Scale)
  {
   return(ObjectSetDouble(ChartID,Name,OBJPROP_SCALE,Scale));
  }
double ObjectGetScale(long ChartID,string Name)
  {
   return(ObjectGetDouble(ChartID,Name,OBJPROP_SCALE));
  }
bool ObjectSetAngle(long ChartID,string Name,double Angle)
  {
   return(ObjectSetDouble(ChartID,Name,OBJPROP_ANGLE,Angle));
  }
double ObjectGetAngle(long ChartID,string Name)
  {
   return(ObjectGetDouble(ChartID,Name,OBJPROP_ANGLE));
  }
bool ObjectSetDeviation(long ChartID,string Name,double Deviation)
  {
   return(ObjectSetDouble(ChartID,Name,OBJPROP_DEVIATION,Deviation));
  }
double ObjectGetDeviation(long ChartID,string Name)
  {
   return(ObjectGetDouble(ChartID,Name,OBJPROP_DEVIATION));
  }

/*** STRING ***/
bool ObjectSetName(long ChartID,string Name,string ObjName)
  {
   return(ObjectSetString(ChartID,Name,OBJPROP_NAME,ObjName));
  }
string ObjectGetName(long ChartID,string Name)
  {
   return(ObjectGetString(ChartID,Name,OBJPROP_NAME));
  }
bool ObjectSetText(long ChartID,string Name,string Text)
  {
   return(ObjectSetString(ChartID,Name,OBJPROP_TEXT,Text));
  }
string ObjectGetText(long ChartID,string Name)
  {
   return(ObjectGetString(ChartID,Name,OBJPROP_TEXT));
  }
bool ObjectSetDescription(long ChartID,string Name,string Description)
  {
   return(ObjectSetString(ChartID,Name,OBJPROP_TEXT,Description));
  }
string ObjectGetDescription(long ChartID,string Name)
  {
   return(ObjectGetString(ChartID,Name,OBJPROP_TEXT));
  }
bool ObjectSetToolTip(long ChartID,string Name,string ToolTip)
  {
   return(ObjectSetString(ChartID,Name,OBJPROP_TOOLTIP,ToolTip));
  }
string ObjectGetToolTip(long ChartID,string Name)
  {
   return(ObjectGetString(ChartID,Name,OBJPROP_TOOLTIP));
  }
bool ObjectSetHint(long ChartID,string Name,string Hint)
  {
   return(ObjectSetString(ChartID,Name,OBJPROP_TOOLTIP,Hint));
  }
string ObjectGetHint(long ChartID,string Name)
  {
   return(ObjectGetString(ChartID,Name,OBJPROP_TOOLTIP));
  }
bool ObjectSetLevelText(long ChartID,string Name,string LevelText)
  {
   return(ObjectSetString(ChartID,Name,OBJPROP_LEVELTEXT,LevelText));
  }
bool ObjectSetLevelText(long ChartID,string Name,int Modifier,string LevelText)
  {
   return(ObjectSetString(ChartID,Name,OBJPROP_LEVELTEXT,Modifier,LevelText));
  }
string ObjectGetLevelText(long ChartID,string Name)
  {
   return(ObjectGetString(ChartID,Name,OBJPROP_LEVELTEXT));
  }
string ObjectGetLevelText(long ChartID,string Name,int Modifier)
  {
   return(ObjectGetString(ChartID,Name,OBJPROP_LEVELTEXT,Modifier));
  }
bool ObjectSetFont(long ChartID,string Name,string Font)
  {
   return(ObjectSetString(ChartID,Name,OBJPROP_FONT,Font));
  }
string ObjectGetFont(long ChartID,string Name)
  {
   return(ObjectGetString(ChartID,Name,OBJPROP_FONT));
  }
bool ObjectSetBMPFileOn(long ChartID,string Name,string BMPFile)
  {
   return(ObjectSetString(ChartID,Name,OBJPROP_BMPFILE,0,BMPFile));
  }
string ObjectGetBMPFileOn(long ChartID,string Name)
  {
   return(ObjectGetString(ChartID,Name,OBJPROP_BMPFILE,0));
  }
bool ObjectSetBMPFileOff(long ChartID,string Name,string BMPFile)
  {
   return(ObjectSetString(ChartID,Name,OBJPROP_BMPFILE,1,BMPFile));
  }
string ObjectGetBMPFileOff(long ChartID,string Name)
  {
   return(ObjectGetString(ChartID,Name,OBJPROP_BMPFILE,0));
  }
bool ObjectSetBMPFile(long ChartID,string Name,string BMPFile)
  {
   return(ObjectSetBMPFileOn(ChartID,Name,BMPFile) && 
          ObjectSetBMPFileOff(ChartID,Name,BMPFile));
  }
bool ObjectSetBMPFile(long ChartID,string Name,string BMPFileOn,string BMPFileOff)
  {
   return(ObjectSetBMPFileOn(ChartID,Name,BMPFileOn) && 
          ObjectSetBMPFileOff(ChartID,Name,BMPFileOff));
  }
bool ObjectSetSymbol(long ChartID,string Name,string Symbol)
  {
   return(ObjectSetString(ChartID,Name,OBJPROP_SYMBOL,Symbol));
  }
string ObjectGetSymbol(long ChartID,string Name)
  {
   return(ObjectGetString(ChartID,Name,OBJPROP_SYMBOL));
  }

/*** Mixed ****/
bool ObjectSetFont(long ChartID,string Name,string FontName,int FontSize)
  {
   return(ObjectSetString(ChartID,Name,OBJPROP_FONT,FontName) && 
          ObjectSetInteger(ChartID,Name,OBJPROP_FONTSIZE,FontSize));
  }
bool ObjectSet(long ChartID,string Name,datetime Time1,double Price1)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_TIME,0,Time1) && 
          ObjectSetDouble(ChartID,Name,OBJPROP_PRICE,0,Price1));
  }
bool ObjectSet(long ChartID,string Name,datetime Time1,double Price1,datetime Time2,double Price2)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_TIME,0,Time1) && 
          ObjectSetDouble(ChartID,Name,OBJPROP_PRICE,0,Price1) && 
          ObjectSetInteger(ChartID,Name,OBJPROP_TIME,1,Time2) && 
          ObjectSetDouble(ChartID,Name,OBJPROP_PRICE,1,Price2));
  }
bool ObjectSet(long ChartID,string Name,datetime Time1,double Price1,datetime Time2,double Price2,datetime Time3,double Price3)
  {
   return(ObjectSetInteger(ChartID,Name,OBJPROP_TIME,0,Time1) && 
          ObjectSetDouble(ChartID,Name,OBJPROP_PRICE,0,Price1) && 
          ObjectSetInteger(ChartID,Name,OBJPROP_TIME,1,Time2) && 
          ObjectSetDouble(ChartID,Name,OBJPROP_PRICE,1,Price2) && 
          ObjectSetInteger(ChartID,Name,OBJPROP_TIME,2,Time3) && 
          ObjectSetDouble(ChartID,Name,OBJPROP_PRICE,2,Price3));
  }
  
/*** INTEGER ***/
bool ObjectSetColor(string Name,color Color)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_COLOR,Color));
  }
color ObjectGetColor(string Name)
  {
   return(color(ObjectGetInteger(0,Name,OBJPROP_COLOR)));
  }
bool ObjectSetStyle(string Name,ENUM_LINE_STYLE Style)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_STYLE,Style));
  }
ENUM_LINE_STYLE ObjectGetStyle(string Name)
  {
   ENUM_LINE_STYLE result=ENUM_LINE_STYLE(ObjectGetInteger(0,Name,OBJPROP_STYLE));
   return(result);
  }
bool ObjectSetWidth(string Name,int Width)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_WIDTH,Width));
  }
int ObjectGetWidth(string Name)
  {
   return(int(ObjectGetInteger(0,Name,OBJPROP_WIDTH)));
  }
bool ObjectSetBack(string Name,bool Back)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_BACK,Back));
  }
bool ObjectGetBack(string Name)
  {
   return(ObjectGetInteger(0,Name,OBJPROP_BACK));
  }
bool ObjectSetZOrder(string Name,long ZOrder)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_ZORDER,ZOrder));
  }
long ObjectGetZOrder(string Name)
  {
   return(ObjectGetInteger(0,Name,OBJPROP_ZORDER));
  }
bool ObjectSetFill(string Name,bool Fill)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_FILL,Fill));
  }
bool ObjectGetFill(string Name)
  {
   return(ObjectGetInteger(0,Name,OBJPROP_FILL));
  }
bool ObjectSetHidden(string Name,bool Hidden)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_HIDDEN,Hidden));
  }
bool ObjectGetHidden(string Name)
  {
   return(ObjectGetInteger(0,Name,OBJPROP_HIDDEN));
  }
bool ObjectSetSelected(string Name,bool Selected)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_SELECTED,Selected));
  }
bool ObjectGetSelected(string Name)
  {
   return(ObjectGetInteger(0,Name,OBJPROP_SELECTED));
  }
bool ObjectSetReadOnly(string Name,bool ReadOnly)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_READONLY,ReadOnly));
  }
bool ObjectGetReadOnly(string Name)
  {
   return(ObjectGetInteger(0,Name,OBJPROP_READONLY));
  }
bool ObjectSetTime(string Name,datetime Time)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_TIME,Time));
  }
datetime ObjectGetTime(string Name,datetime Time)
  {
   return(datetime(ObjectGetInteger(0,Name,OBJPROP_TIME)));
  }
bool ObjectSetTime(string Name,int Modifier,datetime Time)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_TIME,Modifier,Time));
  }
datetime ObjectGetTime(string Name,int Modifier)
  {
   return(datetime(ObjectGetInteger(0,Name,OBJPROP_TIME,Modifier)));
  }
bool ObjectSetTime(string Name,datetime Time1,datetime Time2)
  {
   return(ObjectSetTime(0,Name,0,Time1) && 
          ObjectSetTime(0,Name,1,Time2));
  }
bool ObjectSetTime(string Name,datetime Time1,datetime Time2,datetime Time3)
  {
   return(ObjectSetTime(0,Name,0,Time1) && 
          ObjectSetTime(0,Name,1,Time2) && 
          ObjectSetTime(0,Name,2,Time3));
  }
bool ObjectSetType(string Name,ENUM_OBJECT Type)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_TYPE,Type));
  }
ENUM_OBJECT ObjectGetType(string Name)
  {
   ENUM_OBJECT result=ENUM_OBJECT(ObjectGetInteger(0,Name,OBJPROP_TYPE));
   return(result);
  }
bool ObjectSetSelectable(string Name,bool Selectable)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_SELECTABLE,Selectable));
  }
bool ObjectGetSelectable(string Name)
  {
   return(ObjectGetInteger(0,Name,OBJPROP_SELECTABLE));
  }
datetime ObjectGetCreateTime(string Name)
  {
   return(datetime(ObjectGetInteger(0,Name,OBJPROP_CREATETIME)));
  }
bool ObjectSetLevels(string Name,int Levels)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_LEVELS,Levels));
  }
int ObjectGetLevels(string Name)
  {
   return(int(ObjectGetInteger(0,Name,OBJPROP_LEVELS)));
  }
bool ObjectSetLevelColor(string Name,color LevelColor)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_LEVELCOLOR,LevelColor));
  }
bool ObjectSetLevelColor(string Name,int Modifier,color LevelColor)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_LEVELCOLOR,Modifier,LevelColor));
  }
color ObjectGetLevelColor(string Name)
  {
   return(color(ObjectGetInteger(0,Name,OBJPROP_LEVELCOLOR)));
  }
color ObjectGetLevelColor(string Name,int Modifier)
  {
   return(color(ObjectGetInteger(0,Name,OBJPROP_LEVELCOLOR,Modifier)));
  }
bool ObjectSetLevelStyle(string Name,ENUM_LINE_STYLE LevelStyle)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_LEVELSTYLE,LevelStyle));
  }
bool ObjectSetLevelStyle(string Name,int Modifier,ENUM_LINE_STYLE LevelStyle)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_LEVELSTYLE,Modifier,LevelStyle));
  }
ENUM_LINE_STYLE ObjectGetLevelStyle(string Name,int Modifier)
  {
   ENUM_LINE_STYLE result=ENUM_LINE_STYLE(ObjectGetInteger(0,Name,OBJPROP_LEVELSTYLE,Modifier));
   return(result);
  }
ENUM_LINE_STYLE ObjectGetLevelStyle(string Name)
  {
   ENUM_LINE_STYLE result=ENUM_LINE_STYLE(ObjectGetInteger(0,Name,OBJPROP_LEVELSTYLE));
   return(result);
  }
bool ObjectSetLevelWidth(string Name,ENUM_LINE_STYLE LevelWidth)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_LEVELWIDTH,LevelWidth));
  }
bool ObjectSetLevelWidth(string Name,int Modifier,ENUM_LINE_STYLE LevelWidth)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_LEVELWIDTH,Modifier,LevelWidth));
  }
int ObjectGetLevelWidth(string Name)
  {
   return(int(ObjectGetInteger(0,Name,OBJPROP_LEVELWIDTH)));
  }
int ObjectGetLevelWidth(string Name,int Modifier)
  {
   return(int(ObjectGetInteger(0,Name,OBJPROP_LEVELWIDTH,Modifier)));
  }
bool ObjectSetAlign(string Name,ENUM_ALIGN_MODE Align)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_ALIGN,Align));
  }
ENUM_ALIGN_MODE ObjectGetAlign(string Name)
  {
   ENUM_ALIGN_MODE result=ENUM_ALIGN_MODE(ObjectGetInteger(0,Name,OBJPROP_ALIGN));
   return(result);
  }
bool ObjectSetFontSize(string Name,int FontSize)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_FONTSIZE,FontSize));
  }
bool ObjectSetRayLeft(string Name,bool RayLeft)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_RAY_LEFT,RayLeft));
  }
bool ObjectGetRayLeft(string Name)
  {
   return(ObjectGetInteger(0,Name,OBJPROP_RAY_LEFT));
  }
bool ObjectSetRayRight(string Name,bool RayRight)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_RAY_RIGHT,RayRight));
  }
bool ObjectGetRayRight(string Name)
  {
   return(ObjectGetInteger(0,Name,OBJPROP_RAY_RIGHT));
  }
bool ObjectSetRay(string Name,bool Ray)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_RAY,Ray));
  }
bool ObjectGetRay(string Name)
  {
   return(ObjectGetInteger(0,Name,OBJPROP_RAY));
  }
bool ObjectSetEllipse(string Name,bool Ellipse)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_ELLIPSE,Ellipse));
  }
bool ObjectGetEllipse(string Name)
  {
   return(ObjectGetInteger(0,Name,OBJPROP_ELLIPSE));
  }
bool ObjectSetArrowCode(string Name,char ArrowCode)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_ARROWCODE,ArrowCode));
  }
char ObjectGetArrowCode(string Name)
  {
   return(char(ObjectGetInteger(0,Name,OBJPROP_ARROWCODE)));
  }
bool ObjectSetTimeFrames(string Name,int TimeFrames)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_TIMEFRAMES,TimeFrames));
  }
int ObjectGetTimeFrames(string Name)
  {
   return(int(ObjectGetInteger(0,Name,OBJPROP_TIMEFRAMES)));
  }
bool ObjectSetAnchorPoint(string Name,ENUM_ANCHOR_POINT AnchorPoint)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_ANCHOR,AnchorPoint));
  }
ENUM_ANCHOR_POINT ObjectGetAnchorPoint(string Name)
  {
   ENUM_ANCHOR_POINT result=ENUM_ANCHOR_POINT(ObjectGetInteger(0,Name,OBJPROP_ANCHOR));
   return(result);
  }
bool ObjectSetArrowAnchor(string Name,ENUM_ARROW_ANCHOR ArrowAnchor)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_ANCHOR,ArrowAnchor));
  }
ENUM_ARROW_ANCHOR ObjectGetArrowAnchor(string Name)
  {
   ENUM_ARROW_ANCHOR result=ENUM_ARROW_ANCHOR(ObjectGetInteger(0,Name,OBJPROP_ANCHOR));
   return(result);
  }
bool ObjectSetXDistance(string Name,int XDistance)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_XDISTANCE,XDistance));
  }
int ObjectGetXDistance(string Name)
  {
   return(int(ObjectGetInteger(0,Name,OBJPROP_XDISTANCE)));
  }
bool ObjectSetLeft(string Name,int Left)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_XDISTANCE,Left));
  }
int ObjectGetLeft(string Name)
  {
   return(int(ObjectGetInteger(0,Name,OBJPROP_XDISTANCE)));
  }
bool ObjectSetYDistance(string Name,int YDistance)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_YDISTANCE,YDistance));
  }
int ObjectGetYDistance(string Name)
  {
   return(int(ObjectGetInteger(0,Name,OBJPROP_YDISTANCE)));
  }
bool ObjectSetTop(string Name,int Top)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_YDISTANCE,Top));
  }
int ObjectGetTop(string Name)
  {
   return(int(ObjectGetInteger(0,Name,OBJPROP_YDISTANCE)));
  }
bool ObjectSetPos(string Name,int Left,int Top)
  {
   return(ObjectSetLeft(0,Name,Left) && 
          ObjectSetTop(0,Name,Top));
  }
bool ObjectSetDirection(string Name,ENUM_GANN_DIRECTION Direction)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_DIRECTION,Direction));
  }
ENUM_GANN_DIRECTION ObjectGetDirection(string Name)
  {
   ENUM_GANN_DIRECTION result=ENUM_GANN_DIRECTION(ObjectGetInteger(0,Name,OBJPROP_DIRECTION));
   return(result);
  }
bool ObjectSetDegree(string Name,ENUM_ELLIOT_WAVE_DEGREE Degree)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_DIRECTION,Degree));
  }
ENUM_ELLIOT_WAVE_DEGREE ObjectGetDegree(string Name)
  {
   ENUM_ELLIOT_WAVE_DEGREE result=ENUM_ELLIOT_WAVE_DEGREE(ObjectGetInteger(0,Name,OBJPROP_DEGREE));
   return(result);
  }
bool ObjectSetDrawLines(string Name,bool DrawLines)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_DRAWLINES,DrawLines));
  }
bool ObjectGetDrawLines(string Name)
  {
   return(ObjectGetInteger(0,Name,OBJPROP_DRAWLINES));
  }
bool ObjectSetState(string Name,bool State)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_STATE,State));
  }
bool ObjectGetState(string Name)
  {
   return(ObjectGetInteger(0,Name,OBJPROP_STATE));
  }
bool ObjectSetChartID(string Name,long ObjChartID)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_CHART_ID,ObjChartID));
  }
long ObjectGetChartID(string Name)
  {
   return(ObjectGetInteger(0,Name,OBJPROP_CHART_ID));
  }
bool ObjectSetXSize(string Name,int XSize)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_XSIZE,XSize));
  }
int ObjectGetXSize(string Name)
  {
   return(int(ObjectGetInteger(0,Name,OBJPROP_XSIZE)));
  }
bool ObjectSetYSize(string Name,int YSize)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_YSIZE,YSize));
  }
int ObjectGetYSize(string Name)
  {
   return(int(ObjectGetInteger(0,Name,OBJPROP_YSIZE)));
  }
bool ObjectSetSize(string Name,int XSize,int YSize)
  {
   return(ObjectSetXSize(0,Name,XSize) && 
          ObjectSetYSize(0,Name,YSize));
  }
bool ObjectSetXOffset(string Name,int XOffset)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_XOFFSET,XOffset));
  }
int ObjectGetXOffset(string Name)
  {
   return(int(ObjectGetInteger(0,Name,OBJPROP_XOFFSET)));
  }
bool ObjectSetYOffset(string Name,int YOffset)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_YOFFSET,YOffset));
  }
int ObjectGetYOffset(string Name)
  {
   return(int(ObjectGetInteger(0,Name,OBJPROP_YOFFSET)));
  }
bool ObjectSetPeriod(string Name,ENUM_TIMEFRAMES Period)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_PERIOD,Period));
  }
ENUM_TIMEFRAMES ObjectGetPeriod(string Name)
  {
   ENUM_TIMEFRAMES result=ENUM_TIMEFRAMES(ObjectGetInteger(0,Name,OBJPROP_PERIOD));
   return(result);
  }
bool ObjectSetDataScale(string Name,bool DataScale)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_DATE_SCALE,DataScale));
  }
bool ObjectGetDataScale(string Name)
  {
   return(ObjectGetInteger(0,Name,OBJPROP_DATE_SCALE));
  }
bool ObjectSetPriceScale(string Name,bool PriceScale)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_PRICE_SCALE,PriceScale));
  }
bool ObjectGetPriceScale(string Name)
  {
   return(ObjectGetInteger(0,Name,OBJPROP_PRICE_SCALE));
  }
bool ObjectSetChartScale(string Name,int ChartScale)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_CHART_SCALE,ChartScale));
  }
int ObjectGetChartScale(string Name)
  {
   return(int(ObjectGetInteger(0,Name,OBJPROP_CHART_SCALE)));
  }
bool ObjectSetBgColor(string Name,color BgColor)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_BGCOLOR,BgColor));
  }
color ObjectGetBgColor(string Name)
  {
   return(color(ObjectGetInteger(0,Name,OBJPROP_BGCOLOR)));
  }
bool ObjectSetBaseCorner(string Name,ENUM_BASE_CORNER BaseCorner)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_CORNER,BaseCorner));
  }
ENUM_BASE_CORNER ObjectGetBaseCorner(string Name)
  {
   ENUM_BASE_CORNER result=ENUM_BASE_CORNER(ObjectGetInteger(0,Name,OBJPROP_CORNER));
   return(result);
  }
bool ObjectSetBorderType(string Name,ENUM_BORDER_TYPE BorderType)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_BORDER_TYPE,BorderType));
  }
ENUM_BORDER_TYPE ObjectGetBorderType(string Name)
  {
   ENUM_BORDER_TYPE result=ENUM_BORDER_TYPE(ObjectGetInteger(0,Name,OBJPROP_BORDER_TYPE));
   return(result);
  }
bool ObjectSetBorderColor(string Name,color BorderColor)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_BORDER_COLOR,BorderColor));
  }
color ObjectGetBorderColor(string Name)
  {
   return(color(ObjectGetInteger(0,Name,OBJPROP_BORDER_COLOR)));
  }

/*** DOUBLE ***/
bool ObjectSetPrice(string Name,double Price)
  {
   return(ObjectSetDouble(0,Name,OBJPROP_PRICE,Price));
  }
bool ObjectSetPrice(string Name,int Modifier,double Price)
  {
   return(ObjectSetDouble(0,Name,OBJPROP_PRICE,Modifier,Price));
  }
double ObjectGetPrice(string Name)
  {
   return(ObjectGetDouble(0,Name,OBJPROP_PRICE));
  }
double ObjectGetPrice(string Name,int Modifier)
  {
   return(ObjectGetDouble(0,Name,OBJPROP_PRICE,Modifier));
  }
bool ObjectSetPrice(string Name,double Price1,double Price2)
  {
   return(ObjectSetDouble(0,Name,OBJPROP_PRICE,0,Price1) && 
          ObjectSetDouble(0,Name,OBJPROP_PRICE,1,Price2));
  }
bool ObjectSetPrice(string Name,double Price1,double Price2,double Price3)
  {
   return(ObjectSetDouble(0,Name,OBJPROP_PRICE,0,Price1) && 
          ObjectSetDouble(0,Name,OBJPROP_PRICE,1,Price2) && 
          ObjectSetDouble(0,Name,OBJPROP_PRICE,2,Price3));
  }
bool ObjectSetLevelValue(string Name,double LevelValue)
  {
   return(ObjectSetDouble(0,Name,OBJPROP_LEVELVALUE,LevelValue));
  }
bool ObjectSetLevelValue(string Name,int Modifier,double LevelValue)
  {
   return(ObjectSetDouble(0,Name,OBJPROP_LEVELVALUE,Modifier,LevelValue));
  }
double ObjectGetLevelValue(string Name)
  {
   return(ObjectGetDouble(0,Name,OBJPROP_LEVELVALUE));
  }
double ObjectGetLevelValue(string Name,int Modifier)
  {
   return(ObjectGetDouble(0,Name,OBJPROP_LEVELVALUE,Modifier));
  }
bool ObjectSetScale(string Name,double Scale)
  {
   return(ObjectSetDouble(0,Name,OBJPROP_SCALE,Scale));
  }
double ObjectGetScale(string Name)
  {
   return(ObjectGetDouble(0,Name,OBJPROP_SCALE));
  }
bool ObjectSetAngle(string Name,double Angle)
  {
   return(ObjectSetDouble(0,Name,OBJPROP_ANGLE,Angle));
  }
double ObjectGetAngle(string Name)
  {
   return(ObjectGetDouble(0,Name,OBJPROP_ANGLE));
  }
bool ObjectSetDeviation(string Name,double Deviation)
  {
   return(ObjectSetDouble(0,Name,OBJPROP_DEVIATION,Deviation));
  }
double ObjectGetDeviation(string Name)
  {
   return(ObjectGetDouble(0,Name,OBJPROP_DEVIATION));
  }

/*** STRING ***/
bool ObjectSetName(string Name,string ObjName)
  {
   return(ObjectSetString(0,Name,OBJPROP_NAME,ObjName));
  }
string ObjectGetName(string Name)
  {
   return(ObjectGetString(0,Name,OBJPROP_NAME));
  }
bool ObjectSetText(string Name,string Text)
  {
   return(ObjectSetString(0,Name,OBJPROP_TEXT,Text));
  }
string ObjectGetText(string Name)
  {
   return(ObjectGetString(0,Name,OBJPROP_TEXT));
  }
bool ObjectSetDescription(string Name,string Description)
  {
   return(ObjectSetString(0,Name,OBJPROP_TEXT,Description));
  }
string ObjectGetDescription(string Name)
  {
   return(ObjectGetString(0,Name,OBJPROP_TEXT));
  }
bool ObjectSetToolTip(string Name,string ToolTip)
  {
   return(ObjectSetString(0,Name,OBJPROP_TOOLTIP,ToolTip));
  }
string ObjectGetToolTip(string Name)
  {
   return(ObjectGetString(0,Name,OBJPROP_TOOLTIP));
  }
bool ObjectSetHint(string Name,string Hint)
  {
   return(ObjectSetString(0,Name,OBJPROP_TOOLTIP,Hint));
  }
string ObjectGetHint(string Name)
  {
   return(ObjectGetString(0,Name,OBJPROP_TOOLTIP));
  }
bool ObjectSetLevelText(string Name,string LevelText)
  {
   return(ObjectSetString(0,Name,OBJPROP_LEVELTEXT,LevelText));
  }
bool ObjectSetLevelText(string Name,int Modifier,string LevelText)
  {
   return(ObjectSetString(0,Name,OBJPROP_LEVELTEXT,Modifier,LevelText));
  }
string ObjectGetLevelText(string Name)
  {
   return(ObjectGetString(0,Name,OBJPROP_LEVELTEXT));
  }
string ObjectGetLevelText(string Name,int Modifier)
  {
   return(ObjectGetString(0,Name,OBJPROP_LEVELTEXT,Modifier));
  }
bool ObjectSetFont(string Name,string Font)
  {
   return(ObjectSetString(0,Name,OBJPROP_FONT,Font));
  }
string ObjectGetFont(string Name)
  {
   return(ObjectGetString(0,Name,OBJPROP_FONT));
  }
string ObjectGetBMPFileOn(string Name)
  {
   return(ObjectGetString(0,Name,OBJPROP_BMPFILE,0));
  }
bool ObjectSetBMPFileOff(string Name,string BMPFile)
  {
   return(ObjectSetString(0,Name,OBJPROP_BMPFILE,1,BMPFile));
  }
string ObjectGetBMPFileOff(string Name)
  {
   return(ObjectGetString(0,Name,OBJPROP_BMPFILE,0));
  }
bool ObjectSetBMPFile(string Name,string BMPFile)
  {
   return(ObjectSetBMPFileOn(0,Name,BMPFile) && 
          ObjectSetBMPFileOff(0,Name,BMPFile));
  }
bool ObjectSetBMPFile(string Name,string BMPFileOn,string BMPFileOff)
  {
   return(ObjectSetBMPFileOn(0,Name,BMPFileOn) && 
          ObjectSetBMPFileOff(0,Name,BMPFileOff));
  }
bool ObjectSetSymbol(string Name,string Symbol)
  {
   return(ObjectSetString(0,Name,OBJPROP_SYMBOL,Symbol));
  }
bool ObjectSetBMPFileOn(string Name,string BMPFile)
  {
   return(ObjectSetString(0,Name,OBJPROP_BMPFILE,0,BMPFile));
  }
string ObjectGetSymbol(string Name)
  {
   return(ObjectGetString(0,Name,OBJPROP_SYMBOL));
  }

/*** Mixed ****/
bool ObjectSetFont(string Name,string FontName,int FontSize)
  {
   return(ObjectSetString(0,Name,OBJPROP_FONT,FontName) && 
          ObjectSetInteger(0,Name,OBJPROP_FONTSIZE,FontSize));
  }
bool ObjectSet(string Name,datetime Time1,double Price1)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_TIME,0,Time1) && 
          ObjectSetDouble(0,Name,OBJPROP_PRICE,0,Price1));
  }
bool ObjectSet(string Name,datetime Time1,double Price1,datetime Time2,double Price2)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_TIME,0,Time1) && 
          ObjectSetDouble(0,Name,OBJPROP_PRICE,0,Price1) && 
          ObjectSetInteger(0,Name,OBJPROP_TIME,1,Time2) && 
          ObjectSetDouble(0,Name,OBJPROP_PRICE,1,Price2));
  }
bool ObjectSet(string Name,datetime Time1,double Price1,datetime Time2,double Price2,datetime Time3,double Price3)
  {
   return(ObjectSetInteger(0,Name,OBJPROP_TIME,0,Time1) && 
          ObjectSetDouble(0,Name,OBJPROP_PRICE,0,Price1) && 
          ObjectSetInteger(0,Name,OBJPROP_TIME,1,Time2) && 
          ObjectSetDouble(0,Name,OBJPROP_PRICE,1,Price2) && 
          ObjectSetInteger(0,Name,OBJPROP_TIME,2,Time3) && 
          ObjectSetDouble(0,Name,OBJPROP_PRICE,2,Price3));
  }
//+------------------------------------------------------------------+