//+------------------------------------------------------------------+
//|                                                       Random.mq4 |
//|                                                             amba |
//|                                                       2009-12-07 |
//+------------------------------------------------------------------+

/* 
      .
    .            
,   .     
   .  15.
*/
#property copyright "amba"
#property link      "http://www.mql4.com/ru/users/Amba"
#property show_inputs

extern datetime date.start=D'2009.11.01';
extern datetime date.end= D'2009.12.01';
extern double SL = 0.50;
extern double TP = 0.50;
extern bool IsPercent = true;

#include <ArrayVO.mq4>

int MagicNum=0;

datetime LastDT=0;

//  
string symb[]={ "USDJPY","EURUSD", "EURGBP"};//, "GBPUSD", "USDCHF"};};//

//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
{
    MagicNum=GetTickCount();
    MathSrand(GetTickCount());
    return(0);
}

//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
{
    //   
    v.CloseAllOrders();
    //    CSV. 
    // %METATRADER_FOLDER%\experts\files\deb.Random.hist.csv   
    // %METATRADER_FOLDER%\experts\files\deb.Random.trade.csv      -    
    DebugPrintArrays("Random");
    return(0);
}
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
{
    int _per=Period()*60;
    datetime dt=date.start-_per;
    while(date.end>dt)
    {
        dt+=_per;
        //    
        string cmnt = StringConcatenate("Current: ",TimeToStr(dt,TIME_DATE),"\nIn trade: ",v.OrdersTotal(),"\nIn hist: ",v.OrdersHistoryTotal());
        Comment(cmnt);
        //       
        RecalcTradeArray(dt);
    
        if(v.OrdersTotal()>0) continue;
        //      /
        int op=MathRound(MathRand()/32767.0);
        int op1=1-op;           // ,  
    
        //       
        int isymb = MathRound((ArraySize(symb)-1)*MathRand()/32767.0);
        string sy = symb[isymb];
    
        double pp,sl,tp;   //  , -  -
    
        Print("Operation: ", op, " symbol ",sy);
    
        //   
        int sh=iBarShift(sy,0,dt,true);
        //     - 
        if(sh<0) 
            continue;

        int spread=MarketInfo(sy,MODE_SPREAD);
        double _point=MarketInfo(sy,MODE_POINT);
    
        //       
        pp=iOpen(sy,0,sh)+spread*op1*_point;
        
        if(IsPercent)
        {
            sl=pp * (1 - IIF(op==OP_BUY,1,-1) * SL/100);
            tp=pp * (1 + IIF(op==OP_BUY,1,-1) * TP/100) ;
        } 
        else
        {
            sl=pp-IIF(op==OP_BUY,1,-1)* SL *_point;
            tp=pp+IIF(op==OP_BUY,1,-1)* TP *_point;
        }
    
        //  " "   
        SetCurrentDateTime(dt);
        
        v.SetOrder(sy, op, 0.1,pp,sl ,tp, MagicNum, dt+86400, StringConcatenate("Params",csv.dem,SL,csv.dem,TP));
           
    }   
    return(0);
}

//+------------------------------------------------------------------+


