//+------------------------------------------------------------------+
//|                                             Digital PCCI Filter  |
//|                      Copyright (c) Sergey Iljukhin, Novosibirsk. |
//|                         mailto:sergey@tibet.ru http://fx.qrz.ru/ |
//+------------------------------------------------------------------+
#property copyright "Copyright (c) 2005, Sergey Iljukhin, Novosibirsk"
#property link      "mailto:sergey@tibet.ru"
// --- Parameters: P1=38, D1=28, A1=40
// --- P2=52, D2=31, A2=40, Ripple=0.08, Delay=0
// --- Order [Auto]=106, Calculate method=2
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 Red
//----
extern int TF=0;
//---- buffers
double FilterBuffer[];
double Values[]={
+0.1177628838235,
 +0.1170077388431,
 +0.1147601209029,
 +0.1110729054065,
 +0.1060324421434,
 +0.0997560988008,
 +0.0923890376402,
 +0.0841000389219,
 +0.0750766919597,
 +0.0655202662708,
 +0.0556401583046,
 +0.0456482572592,
 +0.0357530528012,
 +0.02615415804227,
 +0.01703731282680,
 +0.00856960311288,
 +0.000895555708556,
 -0.00586627422066,
 -0.01162552971203,
 -0.01632152444323,
 -0.01992414580732,
 -0.02243335117589,
 -0.02387813894599,
 -0.02431430200598,
 -0.02382176331725,
 -0.02250140527159,
 -0.02047075493180,
 -0.01786000052706,
 -0.01480733499641,
 -0.01145463232852,
 -0.00794304696010,
 -0.00440829083275,
 -0.000977238472653,
 +0.002235823933755,
 +0.00513191787383,
 +0.00762972457736,
 +0.00966747623918,
 +0.01120310303187,
 +0.01221499285956,
 +0.01270127547603,
 +0.01267881242200,
 +0.01218165493397,
 +0.01125820035359,
 +0.00996954486984,
 +0.00838605323109,
 +0.00658436935337,
 +0.00464439195323,
 +0.002645759417416,
 +0.000666068159555,
 -0.001222776729259,
 -0.002956488520058,
 -0.00448011021214,
 -0.00574988855361,
 -0.00673332989225,
 -0.00741117882839,
 -0.00777644547070,
 -0.00783388153265,
 -0.00759966748743,
 -0.00709931269272,
 -0.00636769053766,
 -0.00544559940274,
 -0.00437852874428,
 -0.00321542503890,
 -0.002005580069262,
 -0.000798178859997,
 +0.000361723322003,
 +0.001433101593600,
 +0.002380073229874,
 +0.00317453700490,
 +0.00379492177651,
 +0.00422884523807,
 +0.00447038314289,
 +0.00452100306476,
 +0.00439082398691,
 +0.00409492037175,
 +0.00365528338580,
 +0.003096238149856,
 +0.002446112685573,
 +0.001736376831290,
 +0.000996103380422,
 +0.0002557237615143,
 -0.000458282529397,
 -0.001119581482823,
 -0.001704893115208,
 -0.002199032152313,
 -0.002586916898054,
 -0.002861741841535,
 -0.003018651749353,
 -0.003060101508137,
 -0.002997112675297,
 -0.002834938217095,
 -0.002589089321820,
 -0.002272072078644,
 -0.001902835889698,
 -0.001502872027811,
 -0.001077466851623,
 -0.000655481642188,
 -0.0002511660753314,
 +0.0001137882502083,
 +0.000426098842482,
 +0.000714775119642,
 +0.000916639580735,
 +0.001063116482197,
 +0.001143113996535,
 +0.001159315803654,
 +0.00922554212244
   };
//+------------------------------------------------------------------+
//| Digital filter indicator initialization function                 |
//+------------------------------------------------------------------+
int init()
  {
   string short_name;
//---- indicator line
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,FilterBuffer);
   SetIndexDrawBegin(0,106);
   IndicatorShortName ("PCCI as filter("+tf2str(TF)+")");
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Digital filter main function                                     |
//+------------------------------------------------------------------+
int start()
  {
   int i,counted_bars=IndicatorCounted();
   double response=0.0;
//----
   if(Bars<=106) return(0);
//---- initial zero
   if(counted_bars<106)
      for(i=1;i<=0;i++) FilterBuffer[Bars-i]=0.0;
//----
   int limit =Bars-106-1;
   if(counted_bars>=106) limit=Bars-counted_bars-1;
//----
   for(i=0; i<limit; i++)
     {
      response=0.0;
      for(int k=0; k<ArraySize(Values); k++)
         response+=Values[k] * iClose(NULL, TF, i+k);
      FilterBuffer[i]=iClose(NULL, TF, i) - response;
     }
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
string tf2str(int TF)
  {
   if (TF==0) TF=Period();
   switch(TF)
     {
      case PERIOD_M1 : return("1M"); break;
      case PERIOD_M5 : return("5M"); break;
      case PERIOD_M15 : return("15M"); break;
      case PERIOD_M30 : return("30M"); break;
      case PERIOD_H1 : return("1H"); break;
      case PERIOD_H4 : return("4H"); break;
      case PERIOD_D1 : return("1D"); break;
      case PERIOD_MN1 : return("1MN"); break;
      case PERIOD_W1 : return("1W"); break;
     }
   return("");
  }
//+------------------------------------------------------------------+