//+------------------------------------------------------------------+
//|                                                          MVA.mq4 |
//|                                Copyright  2008, Berkers Trading |
//|                                            http://www.quotar.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2008, Berkers Trading"
#property link      "http://www.quotar.com"

/*
MVA_v1.0.0
----------
- setup
- made standalone
- fixed accounting error

MVA_v1.0.1
----------
- solved accounting error

MVA_v1.0.2
----------
- added optimization function

MVA_v1.0.3
----------
- renamed functions
*/


#define GET                0
#define PUT                1
#define RESET              2
#define INIT               3

#define MVA_BALANCE        0
#define MVA_PROFIT         1
#define MVA_MARGIN         2
#define MVA_FREEMARGIN     3
#define MVA_EQUITY         4
#define MVA_TOTAL_SELL     5
#define MVA_TOTAL_BUY      6
#define MVA_LOT_PROFIT     7

#define DATA_PROFIT        0
#define DATA_MARGIN        1
#define DATA_TOTAL         2
#define DATA_LOTS          3
#define DATA_LOT_PROFIT    4

#define DATA_HISTORY       0
#define DATA_TRADES        1

extern string MVAccount = "---------------";
extern double Fund = 200;
//extern double switch opti

double gdMVA_Fund = 500;

void MVA_init(int iMagicNumber){
   
   gdMVA_Fund         = Fund;
   if (gdMVA_Fund > AccountBalance()){
      gdMVA_Fund = AccountBalance();
   }
   MiniVirtualAccount(0, iMagicNumber, INIT);
}


double MVA_Optimization(int iValue, int iMagicNumber, int iFunction = GET){

   static double ldData[5][2];
   static int liOHTProcessed = 0;
   if(iFunction == INIT){
      
      liOHTProcessed = 0;
      ldData[DATA_LOT_PROFIT][DATA_HISTORY] = 0;
   
   } else if(iFunction == PUT){
      int    liOT = OrdersTotal();
      
      ldData[DATA_TOTAL][OP_SELL] = 0;
      ldData[DATA_TOTAL][OP_BUY] = 0;
            
      for(int i = 0; i < liOT; i++){
         OrderSelect(i, SELECT_BY_POS, MODE_TRADES);
         if (OrderSymbol() == Symbol() && OrderMagicNumber() == iMagicNumber){
            ldData[DATA_TOTAL][OrderType()]++;   
         }
      }
   } else if(iFunction == GET){
      switch(iValue){
         case MVA_BALANCE:
            return(AccountBalance());
            break;
         case MVA_PROFIT:
            return(AccountEquity()-AccountBalance());
            break;
         case MVA_LOT_PROFIT:
            if (liOHTProcessed == 0){
               return(0);
            }
            return(ldData[DATA_LOT_PROFIT][DATA_HISTORY]/liOHTProcessed);
            break;
         case MVA_MARGIN:
            return(AccountMargin());
            break;
         case MVA_FREEMARGIN:
            return(AccountFreeMargin());
            break;
         case MVA_EQUITY:
            return(AccountEquity());
            break;
         case MVA_TOTAL_SELL:
            return(ldData[DATA_TOTAL][OP_SELL]);
            break;
         case MVA_TOTAL_BUY:
            return(ldData[DATA_TOTAL][OP_BUY]);
            break;
      }
   }
}

double MVA_main(int iValue, int iMagicNumber, int iFunction = GET){   
   
   if (IsOptimization() != FALSE || IsTesting() != FALSE){
      return(MVA_Optimization(iValue, iMagicNumber, iFunction));
   }
   
   static double ldData[5][2];
   static int liOHTProcessed = 0;
   if(iFunction == INIT){
      
      liOHTProcessed = 0;
      ldData[DATA_PROFIT][DATA_HISTORY] = gdMVA_Fund;
      ldData[DATA_LOT_PROFIT][DATA_HISTORY] = 0;
   
   } else if(iFunction == PUT){
      
      int    liOT = OrdersTotal();
      int    liOHT = OrdersHistoryTotal(); 
      int    liOHTCounted = liOHTProcessed;
            
      ldData[DATA_PROFIT][DATA_TRADES] = 0;            
      ldData[DATA_MARGIN][DATA_TRADES] = 0;
      ldData[DATA_TOTAL][OP_SELL] = 0;
      ldData[DATA_TOTAL][OP_BUY] = 0;
      ldData[DATA_LOTS][OP_SELL] = 0;
      ldData[DATA_LOTS][OP_BUY] = 0;
      
      for(int i = liOHTProcessed; i < liOHT; i++){
         if (OrderSelect(i, SELECT_BY_POS, MODE_HISTORY) != FALSE){
            if (OrderSymbol() == Symbol() && OrderMagicNumber() == iMagicNumber){
               ldData[DATA_PROFIT][DATA_HISTORY]+= OrderProfit()+OrderCommission()+OrderSwap(); 
               ldData[DATA_LOT_PROFIT][DATA_HISTORY]+= (OrderProfit()+OrderCommission()+OrderSwap())/OrderLots();                            
               liOHTCounted = i + 1;
            }
         }        
      }
      //if (ldData[DATA_PROFIT][DATA_HISTORY] > gdMVA_Fund*2){
       //  ldData[DATA_PROFIT][DATA_HISTORY] -= gdMVA_Fund;
      //}
      liOHTProcessed = liOHTCounted;
      
      for(i = 0; i < liOT; i++){
         OrderSelect(i, SELECT_BY_POS, MODE_TRADES);
         if (OrderSymbol() == Symbol() && OrderMagicNumber() == iMagicNumber){
            ldData[DATA_PROFIT][DATA_TRADES]+= OrderProfit()+OrderCommission()+OrderSwap();  
            ldData[DATA_TOTAL][OrderType()]++; 
            ldData[DATA_LOTS][OrderType()]+= OrderLots();   
         }
      }
      
      ldData[DATA_MARGIN][DATA_TRADES] = (MarketInfo(OrderSymbol(), MODE_MARGINREQUIRED)*ldData[DATA_LOTS][OP_SELL]);
      if (ldData[DATA_LOTS][OP_BUY] > ldData[DATA_LOTS][OP_SELL]){
         ldData[DATA_MARGIN][DATA_TRADES] = (MarketInfo(OrderSymbol(), MODE_MARGINREQUIRED)*ldData[DATA_LOTS][OP_BUY]);
      }
     
   } else if(iFunction == GET){
      switch(iValue){
         case MVA_BALANCE:
            return(ldData[DATA_PROFIT][DATA_HISTORY]);
            break;
         case MVA_PROFIT:
            return(ldData[DATA_PROFIT][DATA_TRADES]);
            break;
         case MVA_LOT_PROFIT:
            if (liOHTProcessed == 0){
               return(0);
            }
            return(ldData[DATA_LOT_PROFIT][DATA_HISTORY]/liOHTProcessed);
            break;
         case MVA_MARGIN:
            return(ldData[DATA_MARGIN][DATA_TRADES]);
            break;
         case MVA_FREEMARGIN:   
            if (ldData[DATA_PROFIT][DATA_HISTORY]+ldData[DATA_PROFIT][DATA_TRADES]-ldData[DATA_MARGIN][DATA_TRADES] < 0){
               return(0);
            }        
            return(ldData[DATA_PROFIT][DATA_HISTORY]+ldData[DATA_PROFIT][DATA_TRADES]-ldData[DATA_MARGIN][DATA_TRADES]);
            break;
         case MVA_EQUITY:
            return(ldData[DATA_PROFIT][DATA_HISTORY]+ldData[DATA_PROFIT][DATA_TRADES]);
            break;
         case MVA_TOTAL_SELL:
            return(ldData[DATA_TOTAL][OP_SELL]);
            break;
         case MVA_TOTAL_BUY:
            return(ldData[DATA_TOTAL][OP_BUY]);
            break;
      }
   }
}