//+------------------------------------------------------------------+
//|                                                mysql_wrapper.c++ |
//|                                Copyright  2008, Berkers Trading |
//|                                                http://quotar.com |
//+------------------------------------------------------------------+
//#include "stdafx.h"

#define WIN32_LEAN_AND_MEAN  // Exclude rarely-used stuff from Windows headers
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include "mysql.h"

//----
#define MT4_EXPFUNC __declspec(dllexport)

struct MqlStr{
   int               len;
   char             *string;
};
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
BOOL APIENTRY DllMain(HANDLE hModule,DWORD ul_reason_for_call,LPVOID lpReserved)
  {
//----
   switch(ul_reason_for_call)
     {
      case DLL_PROCESS_ATTACH:
      case DLL_THREAD_ATTACH:
      case DLL_THREAD_DETACH:
      case DLL_PROCESS_DETACH:
         break;
     }
//----
   return(TRUE);
  }

MT4_EXPFUNC char* __stdcall MT4_mysql_wrapper_version(){

	return("mysql_wrapper v1.0.2 Copyright  2008, Berkers Trading");
}

//+------------------------------------------------------------------+
//|                                                    EA_v1.0.0.mq4 |
//|                                 Copyright  2009, Berkers Trading |
//|                                                http://quotar.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, Berkers Trading"
#property link      "http://quotar.com"
/*
v1.0.0
------
- basic setup

v1.0.5
------
- no trades -> timefilter?

v1.0.6
------
- mva -> store balance for restart problem
- changed to environment_v1.0.2.mqh
- removed reporting
- removed externals for MVA
- changed to registry_v1.0.2.mqh
- changed to comments_v1.0.2.mqh
- added mysql_v2.0.4.mqh
- changed to MVA_v2.0.0.mqh
- added MinBalance
- changed to lots_v1.0.5.mqh
*/

#define SCRIPT    "EA_v1.0.6" //some comment
#define SCRIPTID  106

extern string General      = "---------------";
extern int    Slippage     = 2;
extern int    MagicNumber  = 54783;
extern int    MaxPositions = 2;
extern double MinBalance   = 100;

#include <stdlib.mqh>
#include <cfunctions_v1.0.1.mqh>
#include <mysql_v2.0.4.mqh>
#include <system_v2\registry_v1.0.2.mqh>
#include <system_v2\MVA_v2.0.0.mqh>
#include <system_v2\environment_v1.0.2.mqh>

//#include <system_v2\strategy_RSI_MA_v1.0.0.mqh>
//#include <system_v2\strategy_RSI_MA_AC_v1.0.0.mqh>
#include <stdfunctions_v1.0.0.mqh>
#include <performance_v1.0.0.mqh>
#include <system_v2\strategy_scalper_v1.0.2.mqh>
#include <system_v2\lots_v1.0.5.mqh>
#include <system_v2\manage_v1.0.2.mqh>
#include <system_v2\comments_v1.0.2.mqh>
#include <system_v2\filter_v1.0.5.mqh>

int giEA_MaxPositions   = 1;
int giEA_Slippage       = 3;
int giEA_MagicNumber    = 1234;
int giEA_MinBalance     = 100;

double gdHSL, gdHTP, gdVSL, gdVTP; 

int init(){   
   
   init_MySQL();
   init_registry();
   init_environment();
   
   giEA_Slippage     = Slippage;
   giEA_MagicNumber  = MagicNumber;   
   giEA_MaxPositions = MaxPositions;
   giEA_MinBalance   = MinBalance;

   double ldPointFactor = numericInterface("environment_pointfactor");
      
   init_filter(ldPointFactor);
   init_manage(ldPointFactor, gdHSL, gdHTP, gdVSL, gdVTP);   
   init_strategy(SCRIPTID, giEA_MaxPositions);
   if (IsOptimization() != FALSE || IsTesting() != FALSE){
      init_MVA(FALSE, giEA_MagicNumber);
   } else {
      init_MVA(TRUE, giEA_MagicNumber);
   }   
   init_lots(ldPointFactor);
   init_comments(giEA_MagicNumber); 
   show_comments();
   return(0);
}


int deinit(){   
   
   deinit_MVA();   
   deinit_MySQL();
   return(0);
}

int start(){

   if (start_performance(giEA_MagicNumber) == FALSE){
      manageCloseAll(giEA_MagicNumber, giEA_Slippage);
      return(-1);
   }
   
   //manage trades hidden SL + TP
   start_manage(giEA_MagicNumber, gdHSL, gdHTP, giEA_Slippage);
   
   start_MVA(giEA_MagicNumber);
   
   double ldBalance = main_MVA(MVA_BALANCE, giEA_MagicNumber);
   if (ldBalance < giEA_MinBalance){
      return(0);
   }
   
   //filters
   if (start_filter() == FALSE){
      show_comments();
      return(0);
   }

   int liTotal[2];
   if (filterMaxPositions(giEA_MagicNumber, giEA_MaxPositions, liTotal) == FALSE){      
      show_comments();
      return(0);     
   }
    
   //lots  
   double ldFreeMargin = main_MVA(MVA_FREEMARGIN, giEA_MagicNumber);
   double ldEquity = main_MVA(MVA_EQUITY, giEA_MagicNumber);
   double ldLots = start_lots(ldFreeMargin, ldEquity, gdHSL, gdHTP, giEA_MaxPositions, giEA_MagicNumber);
   if (ldLots == 0){
      show_comments();
      return(0);
   }   
   
   start_strategy(giEA_MagicNumber, gdVSL, gdVTP, giEA_Slippage, ldLots, liTotal);  
   
   show_comments();
   return(0);
}

int _IsTradeAllowed(int iMaxWaitingSec = 30){

   if(IsTradeAllowed() == FALSE || IsTradeContextBusy() != FALSE){
      int liStartWaitingTime = GetTickCount();        
      while(true){
         if(IsStopped()){ 
             return(-1); 
         }
         if(GetTickCount() - liStartWaitingTime > iMaxWaitingSec * 1000){
             Print("The waiting limit exceeded (" + iMaxWaitingSec + " seconds.)");
             return(-2);
         }
         if(IsTradeAllowed() != FALSE && IsTradeContextBusy() == FALSE){
             return(0);
         }
      }
   } else {
      return(1);
   }
}

// move to filter after MVA data is set to registry
bool filterMaxPositions(int iMagicNumber, int iMaxPositions, int& riTotal[]){

   riTotal[OP_BUY] = main_MVA(MVA_TOTAL_BUY, iMagicNumber);
   riTotal[OP_SELL] = main_MVA(MVA_TOTAL_SELL, iMagicNumber);
   if (riTotal[OP_BUY] >= iMaxPositions && riTotal[OP_SELL] >= iMaxPositions){
      return(FALSE);
   }
   return(TRUE);
}
