//+------------------------------------------------------------------+
//|                                                        mysql.mqh |
//|                                Copyright  2009, Berkers Trading |
//|                                                http://quotar.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, Berkers Trading"
#property link      "http://quotar.com"

/*
v2.0.3
------
- corrected initialization error (dbname)

*/

#import "mysql_wrapper.dll"
string   MT4_mysql_wrapper_version();
int      mysql_init        (int db);
int      mysql_errno       (int MySQL);
string   mysql_error       (int MySQL);
int      mysql_real_connect(int MySQL, string host, string user, string password, string DB, int port, int socket, int clientflag);
int      mysql_real_query  (int MySQL, string query, int length);
int      mysql_query       (int MySQL, string query);
void     mysql_close       (int MySQL);
 
int      mysql_store_result(int MySQL);
int      mysql_use_result  (int MySQL);
string   mysql_fetch_row   (int result);
void     MT4_mysql_fetch_row   (int result, string& row[]);
void     MT4_mysql_fetch_fields_string  (int result, string& row[], int type);
int      mysql_num_fields  (int result);
string   mysql_fetch_field (int result);
int      mysql_num_rows    (int result);
void     mysql_free_result (int result);
int      mysql_insert_id   (int MySQL);
#import



#define FIELD_NAME      0
#define FIELD_ORGNAME   1
#define FIELD_TABLE     2
#define FIELD_ORGTABLE  3
#define FIELD_DB        4
#define FIELD_CATALOG   5
#define FIELD_DEF       6

extern string MySQL     = "---------------";
extern int    MySQL_Verbose = 0;
extern string Host      = "localhost";
extern string User      = "metatrader";
extern string Password  = "45691";
extern string Database  = "fx_demo_trade";
extern int    Port      = 3306;

int  MYSQL_VERBOSE = 0;
int  giMySQL;
bool gbMySQLInitialized = FALSE;

int init_MySQL(string sDBName = "") {
   
   MYSQL_VERBOSE = MySQL_Verbose;
   giMySQL = mysql_init(giMySQL);
   
   if(giMySQL != 0 && MYSQL_VERBOSE > 0){ 
       Print("MySQL allocated");
   }
   
   string lsDB = Database;
   if (sDBName != ""){
      lsDB = sDBName;
   }
   return(MySQL_connect(lsDB));
}

int MySQL_connect(string sDBName = ""){   
   
   static string lsDBName;
   if (sDBName != ""){
      lsDBName = sDBName;
   }
   
   int liConnect = mysql_real_connect(giMySQL, Host, User, Password, lsDBName, Port, NULL, 0);
   if (liConnect == giMySQL){ 
       if(MYSQL_VERBOSE > 0){
         Print("MySQL connected");
       }
       gbMySQLInitialized = TRUE;
   } else {
       MySQL_NoError();
   }   
   
   return(0);
}

int deinit_MySQL(){
   
   mysql_close(giMySQL);
   return(0);
}

bool MySQL_NoError(){
   
   int liError = mysql_errno(giMySQL);
   if (liError > 0){
      if(MYSQL_VERBOSE > 0) Print("MySQL error=", liError, " ", mysql_error(giMySQL)); 
      if (liError == 2006){ //CR_SERVER_GONE_ERROR
         MySQL_connect();
      }
      return(FALSE);
   }
   return(TRUE);
}

bool MySQL_FetchRow(string sQuery, string &sResultSet[]){
   
   if (gbMySQLInitialized == FALSE) return(FALSE);   
   if (MYSQL_VERBOSE > 1) Print(sQuery);
   
   int liLength= StringLen(sQuery);    
   mysql_real_query(giMySQL, sQuery, liLength);   
   
   int liResult = mysql_store_result(giMySQL);
   if (liResult <= 0){      
      return(MySQL_NoError());
   }
   int liNumRow = mysql_num_rows(liResult);
   
   if (liNumRow > 0){
      ArrayResize(sResultSet, mysql_num_fields(liResult));   
      MT4_mysql_fetch_row(liResult, sResultSet);  
   } else {
      if (MYSQL_VERBOSE > 1) Print("MySQL 0 Rows selected");
   }
   //for (i = 0; i < ArrayRange(sResultSet,0); i++){
   //     Print(i+"="+sResultSet[i]);
   //}
   mysql_free_result(liResult);
   return(MySQL_NoError());
}

bool MySQL_FetchArray(string sQuery, string &sResultSet[][]){
   
   int i,j;
   if (gbMySQLInitialized == FALSE) return(FALSE);   
   if (MYSQL_VERBOSE > 1) Print(sQuery);
   
   int liLength= StringLen(sQuery);    
   mysql_real_query(giMySQL, sQuery, liLength);   
   
   int liResult = mysql_store_result(giMySQL);
   if (liResult <= 0){      
      return(MySQL_NoError());
   }
   string lsResult[0];

   int liNumRow   = mysql_num_rows(liResult);
   int liNumField = mysql_num_fields(liResult);
   
   ArrayResize(lsResult, liNumField);
   ArrayResize(sResultSet, liNumRow);
  // string sFieldSet[7];
  // ArrayResize(sFieldSet, mysql_num_fields(iResult));
  // MT4_mysql_fetch_fields_string(iResult, sFieldSet,FIELD_NAME);
   
   if (liNumRow < 1){
      if (MYSQL_VERBOSE > 1) Print("MySQL 0 Rows selected");
   }
   for (i = 0; i < liNumRow; i++){
      MT4_mysql_fetch_row(liResult, lsResult);  
      for (j = 0; j < liNumField; j++){
           sResultSet[i][j] = lsResult[j];
           //Print(i+","+j+":="+sResultSet[i][j]);
      }
   }
   mysql_free_result(liResult);
   return(MySQL_NoError());
}

bool MySQL_Query(string sQuery){
   
   if (gbMySQLInitialized == FALSE) return(FALSE);   
   if (MYSQL_VERBOSE > 1) Print(sQuery);
   
   int liLength= StringLen(sQuery);    
   mysql_real_query(giMySQL, sQuery, liLength);
   int liResult = mysql_store_result(giMySQL);
   
   mysql_free_result(liResult);
   
   return(MySQL_NoError());
}