//+------------------------------------------------------------------------------------------------------------------+
//|                                                                                        ZI_File_Functions_Full.mqh|
//|                                                                                        Copyright  Zhunko        |
//|                                                                                        ZHUNKO    vadim@zhunko.ru |
//|24.10.2008                                                                              Ilnur     X-79@yandex.ru  |
//+------------------------------------------------------------------------------------------------------------------+
//|                                         .                                      |
//+------------------------------------------------------------------------------------------------------------------+
//|      .                                                                                    |
//+------------------------------------------------------------------------------------------------------------------+
//| 1.     .                                                                           |
//| 2.    .                                                                      |
//| 3.       .                                                              |
//| 4.       .                                                            |
//| 5.      .                                                                |
//| 6.      .                                                              |
//| 7.         .                                                  |
//| 8.       .                                                                |
//| 9.   .                                                                                       |
//|10.   .                                                                                       |
//+------------------------------------------------------------------------------------------------------------------+
//|          .                                                          |
//+------------------------------------------------------------------------------------------------------------------+
//|11. "      ".                                                |
//|12. "       ".                                        |
//|13. "     ".                                                   |
//|14. "      ".                                           |
//|15. "     ".                                                       |
//|16. "      ".                                               |
//+------------------------------------------------------------------------------------------------------------------+
//|      .                                                                              |
//+------------------------------------------------------------------------------------------------------------------+
//|17.        .                                              |
//|18.    .                                                                        |
//|19.   .                                                                                    |
//|20.   .                                                                                    |
//|21.    .                                                                             |
//|22.    .                                                                      |
//|23.     .                                                                      |
//|24.       .                                                  |
//+------------------------------------------------------------------------------------------------------------------+
#define FILE_CREATE_    0 //    .
#define FILE_WRITE_     1 //  .
#define FILE_READ_      2 //  .
#define FILE_WRITE_END_ 3 //    .
 //++
 //|   . |
 //++
#import "ZI_File_Functions_Full_Main_Lib 0-81024.ex4"
 //====================================================================================================================================
 // 1.     .=============================================================================================
 //  /    / .      ,    .
 //      "CreateDirectory()".
 //  : handle -  ,     ;
 //                     -1     -   ;
 //                     -2     -        ;
 //                     -3     -     .
 int FileOpenFull (string PathName, //     .
                   int    ModeCWR); //   :
                                    // 0 - FILE_CREATE_       .   ,    
                                    //                     .       ,    .
                                    // 1 - FILE_WRITE_        .   .
                                    // 2 - FILE_READ_         .    ,   .
                                    // 3 - FILE_WRITE_END_        .   
                                    //                        .    ,   .
 //====================================================================================================================================
 // 2.    .========================================================================================
 //       ,       ,    
 // .        .      ,  
 //  ,   "-1".
 int FileSeekFull (int Handle,  //  ,   "FileOpenFull()".
                   int Offset,  //   .
                   int Origin); //    : SEEK_CUR -   ,
                                //                                          SEEK_SET -  ,
                                //                                          SEEK_END -   .
 //====================================================================================================================================
#import "ZI_File_Functions_Full_Double_Data_Lib 0-81024.ex4"
 //====================================================================================================================================
 // 3.        .======================================================================
 //           .
 int FileWriteDoubleFull (int    Handle, //  ,   "FileOpenFull()".
                          double Value,  //   .
                          int    Size);  //  : DOUBLE_VALUE (8 );
                                         //               FLOAT_VALUE  (4 ).
 //====================================================================================================================================
 // 4.          .=======================================================
 double FileReadDoubleFull (int Handle, //  ,   "FileOpenFull()".
                            int Size);  //  : DOUBLE_VALUE (8 );
                                        //               FLOAT_VALUE  (4 ).
 //====================================================================================================================================
#import "ZI_File_Functions_Full_Intenger_Data_Lib 0-81024.ex4"
 //====================================================================================================================================
 // 5.       .=================================================================================
 //           .
 int FileWriteIntegerFull (int Handle, //  ,   "FileOpenFull()".
                           int Value,  //   .
                           int Size);  //  : CHAR_VALUE  (1 );
                                       //               SHORT_VALUE (2 );
                                       //               LONG_VALUE  (4 ).
 //====================================================================================================================================
 // 6.         .==================================================================
 int FileReadIntegerFull (int Handle, //  ,   "FileOpenFull()".
                          int Size);  //  : CHAR_VALUE  (1 );
                                      //               SHORT_VALUE (2 );
                                      //               LONG_VALUE  (4 ).
 //====================================================================================================================================
#import "ZI_File_Functions_Full_String_Value_Lib 0-81024.ex4"
 //====================================================================================================================================
 // 7.         .====================================================================
 //           .
 int FileWriteStringFull (int    Handle, //  ,   "FileOpenFull()".
                          string Value,  //  .
                          int    Size);  //   .
 //====================================================================================================================================
 // 8.       .==================================================================================
 string FileReadStringFull (int Handle,  //  ,   "FileOpenFull()".
                            int Length); //    .
 //====================================================================================================================================
#import "ZI_File_Functions_Full_Main_Lib 0-81024.ex4"
 //====================================================================================================================================
 // 9.   .=========================================================================================================
 //     .    ,   TRUE,   FALSE.
 bool FileCloseFull (int Handle); //  ,   "FileOpenFull()".
 //====================================================================================================================================
 //10.   .=========================================================================================================
 //    .    ,   TRUE,   FALSE.
 int FileDeleteFull (string PathName); //    .
 //++
 //|        . |
 //++
#import "ZI_File_Functions_Full_Double_Data_Lib 0-81024.ex4"
 //====================================================================================================================================
 //11.  "      ".=================================================================
 //      p     .    p   "-1".
 //      .
 double FileOperationsDoubleValue (string  PathName,        //  .
                                   double& Value,           //     .
                                   int     Size,            //  : DOUBLE_VALUE (8 );
                                                            //               FLOAT_VALUE  (4 ).
                                   int     ModeCWR,         //     : 0 - FILE_CREATE_     ;
                                                            //                                     1 - FILE_WRITE_    ;
                                                            //                                     2 - FILE_READ_     .
                                   int     Offset,          //     .
                                   int     Origin,          //    : SEEK_CUR -   ,
                                                            //                                          SEEK_SET -  ,
                                                            //                                          SEEK_END -   ).
                                   int&    ArOutputByte[]); //     .
 //====================================================================================================================================
 //12.  "       ".=========================================================
 // p   .    p   "-1".
 int FileOperationsDoubleArray (string  PathName, //  .
                                double& Array[],  //     .
                                int     ModeCWR,  //     : 0 - FILE_CREATE_     ;
                                                  //                                     1 - FILE_WRITE_    ;
                                                  //                                     2 - FILE_READ_     .
                                int     Start,    //          .
                                int     Count,    //          .
                                int     Offset,   //     .
                                int     Origin);  //    : SEEK_CUR -   ,
                                                  //                                          SEEK_SET -  ,
                                                  //                                          SEEK_END -   ).
 //====================================================================================================================================
#import "ZI_File_Functions_Full_Intenger_Data_Lib 0-81024.ex4"
 //====================================================================================================================================
 //13.  "     ".====================================================================
 //      p     .    p   "-1".
 //      .
 int FileOperationsIntValue (string PathName,        //  .
                             int&   Value,           //     .
                             int    Size,            //  : CHAR_VALUE  (1 );
                                                     //               SHORT_VALUE (2 );
                                                     //               LONG_VALUE  (4 ).
                             int    ModeCWR,         //     : 0 - FILE_CREATE_     ;
                                                     //                                     1 - FILE_WRITE_    ;
                                                     //                                     2 - FILE_READ_     .
                             int    Offset,          //     .
                             int    Origin,          //    : SEEK_CUR -   ,
                                                     //                                          SEEK_SET -  ,
                                                     //                                          SEEK_END -   ).
                            int&   ArOutputByte[]);  //     .
 //====================================================================================================================================
 //14.  "      ".============================================================
 // p   .    p   "-1".
 int FileOperationsIntArray (string PathName, //  .
                             int&   Array[],  //     .
                             int    ModeCWR,  //     : 0 - FILE_CREATE_     ;
                                              //                                     1 - FILE_WRITE_    ;
                                              //                                     2 - FILE_READ_     .
                             int    Start,    //          .
                             int    Count,    //          .
                             int    Offset,   //     .
                             int    Origin);  //    : SEEK_CUR -   ,
                                              //                                          SEEK_SET -  ,
                                              //                                          SEEK_END -   ).
 //====================================================================================================================================
#import "ZI_File_Functions_Full_String_Value_Lib 0-81024.ex4"
 //====================================================================================================================================
 //15.  "     ".========================================================================
 // p   .    p   "-1".
 int FileOperationsStringValue (string  PathName, //  .
                                string& Value,    //     .
                                int     ModeCWR,  //     : 0 - FILE_CREATE_     ;
                                                  //                                     1 - FILE_WRITE_    ;
                                                  //                                     2 - FILE_READ_     .
                                int     Size,     //     .
                                int     Offset,   //     .
                                int     Origin);  //    : SEEK_CUR -   ,
                                                  //                                          SEEK_SET -  ,
                                                  //                                          SEEK_END -   ).
 //====================================================================================================================================
#import "ZI_File_Functions_Full_String_Array_Lib 0-81015.ex4"
 //====================================================================================================================================
 //16.  "      ".================================================================
 // p   .    p   "-1".
 int FileOperationsStringArray (string  PathName, //  .
                                string& Array[],  //     .
                                int     ModeCWR,  //     : 0 - FILE_CREATE_     ;
                                                  //                                     1 - FILE_WRITE_    ;
                                                  //                                     2 - FILE_READ_     .
                                int     Start,    //          .
                                int     Count,    //          .
                                int     Offset,   //     .
                                int     Origin);  //    : SEEK_CUR -   ,
                                                  //                                          SEEK_SET -  ,
                                                  //                                          SEEK_END -   ).
 //++
 //|   . |
 //++
#import "ZI_File_Functions_Full_Main_Lib 0-81024.ex4"
 //====================================================================================================================================
 // 5.        .================================================================
 //   TRUE,      ,   FALSE.
 bool FileIsEndingFull (int Handle); //  ,   "FileOpenFull()".
 //====================================================================================================================================
 // 6.    .==========================================================================================
 //          .
 int FileTellFull (int Handle);
 //====================================================================================================================================
 // 7.   .======================================================================================================
 //         .   ,    .
 //     .      ,    .
 //      "CreateDirectory()".    ,   TRUE,
 //   FALSE.
 bool FileCopy (string ExistingFileName, //    .
                string NewFileName);     //  ,     .
 //====================================================================================================================================
 // 8.   .======================================================================================================
 //         .   ,    .
 //      ,    .
 //      "CreateDirectory()".
 //    ,   TRUE,   FALSE.
 int FileMove (string ExistingFileName, //    .
               string NewFileName);     //  ,     .
 //====================================================================================================================================
 // 9.    .===============================================================================================
 //     ,   TRUE,   FALSE.
 bool CreateDirectory (string PathName); //   .
 //====================================================================================================================================
 //10.    .========================================================================================
 //     ,   TRUE,   FALSE.
 bool RemoveDirectory (string PathName); //   .
 //====================================================================================================================================
 //11.     .========================================================================================
 int SystemError();
 //====================================================================================================================================
 //12.       .====================================================================
 string StringError (int ErrorCode); //   .
//=====================================================================================================================================
#import
//