//+------------------------------------------------------------------------------------------------------------------+
//|                                                               ZI_File_Functions_Full_String_Value_Lib 0-81024.mq4|
//|                                                               Copyright  Zhunko                                 |
//|                                                               ZHUNKO vadim@zhunko.ru                             |
//|24.10.2008                                                     Ilnur  X-79@yandex.ru                              |
//+------------------------------------------------------------------------------------------------------------------+
//|                                     .                                    |
//+------------------------------------------------------------------------------------------------------------------+
//| 1.  "     ".                                                      |
//| 2.       .                                                               |
//| 3.         .                                                |
//| 4.       .                                                  |
//+------------------------------------------------------------------------------------------------------------------+

#property copyright "Copyright  2008 Zhunko, Ilnur"
#property link      "vadim@zhunko.ru ; X-79@yandex.ru"
#property library
//  .
#import "kernel32.dll"
 bool ReadFile (int hFile, string& lpBuffer, int nNumberOfBytesToRead, int& lpNumberOfBytesRead[], int lpOverlapped);
 bool WriteFile (int hFile, string lpBuffer, int nNumberOfBytesToWrite, int& lpNumberOfBytesWritten[], int lpOverlapped);
#import "ntdll.dll"
 int  RtlGetLastWin32Error();
 int  RtlSetLastWin32Error (int dwErrCode);
#import
#include <WinKernel32.mqh> //    "kernel32.dll"  API Windows XP.
//=================================================================================================================================================================================
// 1.  "     ".=====================================================================================================================
// p     .    p   "-1".
int FileOperationsStringValue (string  PathName, //  .
                               string& Value,    //     .
                               int     ModeCWR,  //     : 0 - FILE_CREATE_     ;
                                                 //                                     1 - FILE_WRITE_    ;
                                                 //                                     2 - FILE_READ_     .
                               int     Size,     //     .
                               int     Offset,   //     .
                               int     Origin)   //    : SEEK_CUR -   ,
                                                 //                                          SEEK_SET -  ,
                                                 //                                          SEEK_END -   ).
 {
  int Error;  //   .
  int Handle; //   .
  int i;
  //----
  int ArOutputByte[1]; //        .
  //----
  RtlSetLastWin32Error (0); //  .
  switch (ModeCWR)
   {
    case 0: Handle = CreateFileA (PathName, GENERIC_WRITE, FILE_SHARE_WRITE, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL); break; //  .
    case 1: Handle = CreateFileA (PathName, GENERIC_WRITE|GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL); break; //  .
    case 2: Handle = CreateFileA (PathName, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL); break;   //  .
    default: Print ("   \"FileOperationsStringValue()\".        \"", PathName, "\"   . ModeCWR = ", ModeCWR); return (-1);
   }
  if (Handle == -1) //    .
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileOperationsStringValue()\".    \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
    return (-1);
   }
  if (SetFilePointer (Handle, Offset, NULL, Origin) == -1) //   ,   ,  .
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileOperationsStringValue()\".      \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
    RtlSetLastWin32Error (0); //  .
    if (CloseHandle (Handle) == false)
     {
      Error = RtlGetLastWin32Error();
      Print ("   \"FileOperationsStringValue()\".    \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
     }
    return (-1);
   }
  switch (ModeCWR)
   {
    case 0: //       .
    case 1: //       .
     {
      if (WriteFile (Handle, Value, Size, ArOutputByte, NULL) == false)
       {
        Error = RtlGetLastWin32Error();
        Print ("   \"FileOperationsStringValue()\".      \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
       }
      break;
     }
    case 2: //    .
     {
      Value = ""; //  .
      for (i = 0; i < Size; i++) Value = Value + " "; //            .
      if (ReadFile (Handle, Value, Size, ArOutputByte, NULL) == false)
       {
        Error = RtlGetLastWin32Error();
        Print ("   \"FileOperationsStringValue()\".      \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
       }
      break;
     }
   }
  if (CloseHandle (Handle) == false) //  .
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileOperationsStringValue()\".    \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
    return (-1);
   }
  return (ArOutputByte[0]);
 }
//=================================================================================================================================================================================
// 2.         .=================================================================================================================
//           .
int FileWriteStringFull (int    Handle, //  ,   "FileOpenFull()".
                         string Value,  //  .
                         int    Size)   //   .
 {
  int Error;             //   .
  //----
  int ArOutputByte[1];   //     .
  //----
  RtlSetLastWin32Error (0); //  .
  if (WriteFile (Handle, Value, Size, ArOutputByte, NULL) == false)
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileWriteStringFull()\".     .  : \"", Error, "\". ", StringError (Error));
    return (-1);
   }
  else return (ArOutputByte[0]);
 }
//=================================================================================================================================================================================
// 3.       .===============================================================================================================================
string FileReadStringFull (int Handle, //  ,   "FileOpenFull()".
                           int Length) //    .
 {
  int    Error;  //   .
  string String; //  .
  //----
  int ArOutputByte[1]; //     .
  //----
  RtlSetLastWin32Error (0); //  .
  if (ReadFile (Handle, String, Length, ArOutputByte, NULL) == false)
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileReadStringFull()\".     .  : \"", Error, "\". ", StringError (Error));
    return ("ERROR");
   }
  else return (String);
 }
//=================================================================================================================================================================================
// 4.       .=================================================================================================================
string StringError (int ErrorCode)
 {
  int    i;
  string String = "";
  //----
  int    Buffer[128];
  //----
  ArrayInitialize (Buffer, 0);
  FormatMessageA (0x1000, 0, ErrorCode, 0, Buffer, ArraySize (Buffer), 0);
  //----
  for (i = 0; i < ArraySize (Buffer); i++)
   {
    String = String + CharToStr (Buffer[i]       & 0xFF)
                    + CharToStr (Buffer[i] >>  8 & 0xFF)
                    + CharToStr (Buffer[i] >> 16 & 0xFF)
                    + CharToStr (Buffer[i] >> 24 & 0xFF);
   }
  return (StringTrimRight (String) + ".");
 }
//