//+------------------------------------------------------------------------------------------------------------------+
//|                                                                ZI_File_Functions_Full_Double_Data_Lib 0-81024.mq4|
//|                                                                Copyright  Zhunko                                |
//|                                                                ZHUNKO vadim@zhunko.ru                            |
//|24.10.2008                                                      Ilnur  X-79@yandex.ru                             |
//+------------------------------------------------------------------------------------------------------------------+
//|                                      .                             |
//+------------------------------------------------------------------------------------------------------------------+
//| 1.  "      ".                                               |
//| 2.  "       ".                                       |
//| 3.        .                                                    |
//| 4.          .                                     |
//| 5.       .                                                  |
//+------------------------------------------------------------------------------------------------------------------+
#property copyright "Copyright  2008 Zhunko, Ilnur"
#property link      "vadim@zhunko.ru ; X-79@yandex.ru"
#property library
//  .
#import "kernel32.dll"
 bool ReadFile (int hFile, double& lpBuffer[], int nNumberOfBytesToRead, int& lpNumberOfBytesRead[], int lpOverlapped);
 bool WriteFile (int hFile, double lpBuffer[], int nNumberOfBytesToWrite, int& lpNumberOfBytesWritten[], int lpOverlapped);
 void RtlMoveMemory (double& Destination[], double Source[], int Length);
#import "ntdll.dll"
 int  RtlGetLastWin32Error();
 int  RtlSetLastWin32Error (int dwErrCode);
#import
#include <WinKernel32.mqh> //    "kernel32.dll"  API Windows XP.
//=================================================================================================================================================================================
// 1.  "      ".==============================================================================================================
//      p     .    p   "-1".
//      .
double FileOperationsDoubleValue (string  PathName,        //  .
                                  double& Value,           //     .
                                  int     Size,            //  : DOUBLE_VALUE (8 );
                                                           //               FLOAT_VALUE  (4 ).
                                  int     ModeCWR,         //     : 0 - FILE_CREATE_     ;
                                                           //                                     1 - FILE_WRITE_    ;
                                                           //                                     2 - FILE_READ_     .
                                  int     Offset,          //     .
                                  int     Origin,          //    : SEEK_CUR -   ,
                                                           //                                          SEEK_SET -  ,
                                                           //                                          SEEK_END -   ).
                                  int&    ArOutputByte[])  //     .
 {
  int Error;  //   .
  int Handle; //   .
  int i;
  //----
  double ArBuffer[1] = {0}; //     .
  //----
  ArrayResize (ArOutputByte, 1);
  //----
  RtlSetLastWin32Error (0); //  .
  switch (ModeCWR)
   {
    case 0: Handle = CreateFileA (PathName, GENERIC_WRITE, FILE_SHARE_WRITE, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL); break; //  .
    case 1: Handle = CreateFileA (PathName, GENERIC_WRITE|GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL); break; //  .
    case 2: Handle = CreateFileA (PathName, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL); break;   //  .
    default: Print ("   \"FileOperationsDoubleValue()\".        \"", PathName, "\"   . ModeCWR = ", ModeCWR); return (-1);
   }
  if (Handle == -1) //    .
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileOperationsDoubleValue()\".    \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
    return (-1);
   }
  if (SetFilePointer (Handle, Offset, NULL, Origin) == -1) //   ,   ,  .
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileOperationsDoubleValue()\".      \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
    RtlSetLastWin32Error (0); //  .
    if (CloseHandle (Handle) == false)
     {
      Error = RtlGetLastWin32Error();
      Print ("   \"FileOperationsDoubleValue()\".    \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
     }
    return (-1);
   }
  switch (ModeCWR)
   {
    case 0: //       .
    case 1: //       .
     {
      ArBuffer[0] = Value;
      if (WriteFile (Handle, ArBuffer, Size, ArOutputByte, NULL) == false)
       {
        Error = RtlGetLastWin32Error();
        Print ("   \"FileOperationsDoubleValue()\".      \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
       }
      break;
     }
    case 2: //    .
     {
      if (ReadFile (Handle, ArBuffer, Size, ArOutputByte, NULL) == false)
       {
        Error = RtlGetLastWin32Error();
        Print ("   \"FileOperationsDoubleValue()\".      \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
       }
      else Value = ArBuffer[0];
      break;
     }
   }
  if (CloseHandle (Handle) == false) //  .
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileOperationsDoubleValue()\".    \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
    return (-1);
   }
  switch (ModeCWR)
   {
    case 0: return (ArOutputByte[0]); //    .
    case 1: return (ArOutputByte[0]); //    .
    case 2: return (ArBuffer[0]);     //   .
   }
 }
//=================================================================================================================================================================================
// 2.  "       ".======================================================================================================
// p     .    p   "-1".
int FileOperationsDoubleArray (string  PathName, //  .
                               double& Array[],  //     .
                               int     ModeCWR,  //     : 0 - FILE_CREATE_     ;
                                                 //                                     1 - FILE_WRITE_    ;
                                                 //                                     2 - FILE_READ_     .
                               int     Start,    //          .
                               int     Count,    //          .
                               int     Offset,   //     .
                               int     Origin)   //    : SEEK_CUR -   ,
                                                 //                                          SEEK_SET -  ,
                                                 //                                          SEEK_END -   ).
 {
  int Bytes = 4 * Count;  //   .
  int Error;              //   .
  int Handle;             //   .
  int i;
  int Size;               //  .
  //----
  double ArTemp1[];       //  .
  double ArTemp2[];       //  .
  int    ArOutputByte[1]; //        .
  //----
  RtlSetLastWin32Error (0); //  .
  switch (ModeCWR)
   {
    case 0: Handle = CreateFileA (PathName, GENERIC_WRITE, FILE_SHARE_WRITE, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL); break; //  .
    case 1: Handle = CreateFileA (PathName, GENERIC_WRITE|GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL); break; //  .
    case 2: Handle = CreateFileA (PathName, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL); break;   //  .
    default: Print ("   \"FileOperationsDoubleArray()\".        \"", PathName, "\"   . ModeCWR = ", ModeCWR); return (-1);
   }
  if (Handle == -1) //    .
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileOperationsDoubleArray()\".    \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
    return (-1);
   }
  if (SetFilePointer (Handle, Offset, NULL, Origin) == -1) //   ,   ,  .
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileOperationsDoubleArray()\".      \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
    RtlSetLastWin32Error (0); //  .
    if (CloseHandle (Handle) == false)
     {
      Error = RtlGetLastWin32Error();
      Print ("   \"FileOperationsDoubleArray()\".    \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
     }
    return (-1);
   }
  switch (ModeCWR)
   {
    case 0: //       .
    case 1: //       .
     {
      Size = ArraySize (Array);             //   .
      ArrayResize (ArTemp1, Size);          //        .
      RtlMoveMemory (ArTemp1, Array, Size); //        .
      if (Start != 0) ArrayCopy (ArTemp1, ArTemp1, 0, Start, Count);    //      .
      if (WriteFile (Handle, Array, Bytes, ArOutputByte, NULL) == false) //      .
       {
        Error = RtlGetLastWin32Error();
        Print ("   \"FileOperationsDoubleArray()\".      \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
       }
      break;
     }
    case 2: //    .
     {
      if (ReadFile (Handle, Array, Bytes, ArOutputByte, NULL) == false)
       {
        Error = RtlGetLastWin32Error();
        Print ("   \"FileOperationsDoubleArray()\".      \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
       }
      Size = ArraySize (Array);                             //   .
      if (Size < (Start + Count)) Count = Size - Start;     //          .
      if (Start == 0) RtlMoveMemory (Array, ArTemp1, Size); //     ,          .
      else                                                  //      .
       {
        ArrayResize (ArTemp2, Size);                        //         .
        RtlMoveMemory (ArTemp2, Array, Size);               //         .    .
        ArrayCopy (ArTemp2, ArTemp1, Start, 0, Count);      //          (  ).
        RtlMoveMemory (Array, ArTemp2, Size);               //         .
        ArrayResize (ArTemp2, 0);                           //    .
       }
      break;
     }
   }
  if (CloseHandle (Handle) == false) //  .
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileOperationsDoubleArray()\".    \"", PathName, "\"  .  : \"", Error, "\". ", StringError (Error));
    return (-1);
   }
  ArrayResize (ArTemp1, 0); //  .
  return (ArOutputByte[0] / 8);
 }
//=================================================================================================================================================================================
// 3.        .===================================================================================================================
//           .
int FileWriteDoubleFull (int    Handle, //  ,   "FileOpenFull()".
                         double Value,  //   .
                         int    Size)   //  : DOUBLE_VALUE (8 );
                                        //               FLOAT_VALUE  (4 ).
 {
  int Error;                //   .
  //----
  double ArBuffer[1] = {0}; //     .
  int    ArOutputByte[1];   //     .
  //----
  RtlSetLastWin32Error (0); //  .
  ArBuffer[0] = Value;
  if (WriteFile (Handle, ArBuffer, Size, ArOutputByte, NULL) == false)
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileWriteDoubleFull()\".     .  : \"", Error, "\". ", StringError (Error));
    return (-1);
   }
  else return (ArOutputByte[0]);
 }
//=================================================================================================================================================================================
// 4.          .====================================================================================================
double FileReadDoubleFull (int Handle, //  ,   "FileOpenFull()".
                           int Size)   //  : DOUBLE_VALUE (8 );
                                       //               FLOAT_VALUE  (4 ).
 {
  int Error;                //   .
  //----
  double ArBuffer[1] = {0}; //     .
  int    ArOutputByte[1];   //     .
  //----
  RtlSetLastWin32Error (0); //  .
  if (ReadFile (Handle, ArBuffer, Size, ArOutputByte, NULL) == false)
   {
    Error = RtlGetLastWin32Error();
    Print ("   \"FileReadDoubleFull()\".     .  : \"", Error, "\". ", StringError (Error));
    return (0);
   }
  else return (ArBuffer[0]);
 }
//=================================================================================================================================================================================
// 5.       .=================================================================================================================
string StringError (int ErrorCode)
 {
  int    i;
  string String = "";
  //----
  int    Buffer[128];
  //----
  ArrayInitialize (Buffer, 0);
  FormatMessageA (0x1000, 0, ErrorCode, 0, Buffer, ArraySize (Buffer), 0);
  //----
  for (i = 0; i < ArraySize (Buffer); i++)
   {
    String = String + CharToStr (Buffer[i]       & 0xFF)
                    + CharToStr (Buffer[i] >>  8 & 0xFF)
                    + CharToStr (Buffer[i] >> 16 & 0xFF)
                    + CharToStr (Buffer[i] >> 24 & 0xFF);
   }
  return (StringTrimRight (String) + ".");
 }
//=================================================================================================================================================================================
//