//+------------------------------------------------------------------+
//|                                                 FastFile_Example |
//|                    Copyright  2006-2012, Finexware Technologies |
//|                                                www.FINEXWARE.com |
//|      programming & development - Alexey Sergeev, Boris Gershanov |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006-2012, Finexware Technologies"
#property link      "www.FINEXWARE.com"
#property version		"1.00"

#include <FastFile.mqh>
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
   CFastFile *h=new CFastFile; // creating "virtual file" object

   h.WriteDouble(123);              // write double (8 bytes)
   h.WriteInteger(456, INT_VALUE);  // write integer (4 bytes)
   h.WriteChar(char(100));          // write char (1 byte)
   uint n=h.WriteString("Hello FastFile Object!"); // the string has been written and its size has been received

   h.Save("dump.txt");     // save the virtual file to the real file on disk
   h.Clear();              // clear
   h.Load("dump.txt");     // load file from disk

   Print("read double= "+string(h.ReadDouble()));         // read double
   Print("read integer= "+string(h.ReadInteger()));       // read integer
   Print("read char= "+string(h.ReadChar()));             // read char
   Print("read string["+string(n)+"]= "+h.ReadString(n)); // read string (n chars)

   delete h; // delete virtual file object
  }
//------------------------------------------------------------------