//+------------------------------------------------------------------+
//|                                                     Beginner.mq4 |
//|                                                 Copyright  2007 |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, Heaven"
#property link      "http://Beginner.com"
//----
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Blue
#property indicator_color2 Red
#define  SH_BUY   1
#define  SH_SELL  -1
//----  
extern bool SoundON=true;
extern int     AllBars=0;//   . 0 -  .
extern int     Otstup=30;//.
extern double  Per=9;//.
//----
int            SH,NB,i,UD;
double         R,SHMax,SHMin;
double         BufD[];
double         BufU[];
int flagval1=0;
int flagval2=0;
//+------------------------------------------------------------------+
//|                                              |
//+------------------------------------------------------------------+
int init()
  {
   // NB       
   if (Bars<AllBars+Per || AllBars==0) NB=Bars-Per; else NB=AllBars;
   IndicatorBuffers(2);
   IndicatorShortName("SHI_SilverTrendSig");
   SetIndexStyle(0,DRAW_ARROW,0,1);
   SetIndexStyle(1,DRAW_ARROW,0,1);
   SetIndexArrow(0,159);
   SetIndexArrow(1,159);
   SetIndexBuffer(0,BufU);
   SetIndexBuffer(1,BufD);
   SetIndexDrawBegin(0,Bars-NB);//    NB 
   SetIndexDrawBegin(1,Bars-NB);
   ArrayInitialize(BufD,0.0);//   .      .
   ArrayInitialize(BufU,0.0);
   return(0);
  }
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
int deinit()
  {
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                   |
//+------------------------------------------------------------------+
int start()
  {
   int CB=IndicatorCounted();
   /*      .    ,   
    ,   .      0,  ,  
    ,        . ..    100,
      99.    ,     NB - -  
   .       ,       (I80286) 
    .  , ,    NB  ,    
     , .. 1  2,      */
   if(CB<0) return(-1); else if(NB>Bars-CB) NB=Bars-CB;
   for(SH=1;SH<NB;SH++)//   1  NB
     {
      for(R=0,i=SH;i<SH+10;i++) {R+=(10+SH-i)*(High[i]-Low[i]);}      R/=55;
//----
      SHMax=High[Highest(NULL,0,MODE_HIGH,Per,SH)];
      SHMin=Low[Lowest(NULL,0,MODE_LOW,Per,SH)];
      if (Close[SH]<SHMin+(SHMax-SHMin)*Otstup/100 && UD!=SH_SELL)
        {
         // Pop an Alert
         if (SH==1 && flagval1==0)
           {
            flagval1=1;
            flagval2=0;
            if (SoundON) Alert("BUY signal at Ask=",Ask,"\n Bid=",Bid,"\n Time=",TimeToStr(CurTime(),TIME_DATE)," ",TimeHour(CurTime()),":",TimeMinute(CurTime()),"\n Symbol=",Symbol()," Period=",Period());
           }
         BufU[SH]=Low[SH]-R*0.5; UD=SH_SELL;
        }
      if (Close[SH]>SHMax-(SHMax-SHMin)*Otstup/100 && UD!=SH_BUY)
        {
         // pop an Alert
         if (SH==1 && flagval2==0)
           {
            flagval2=1;
            flagval1=0;
            if (SoundON) Alert("SELL signal at Ask=",Ask,"\n Bid=",Bid,"\n Date=",TimeToStr(CurTime(),TIME_DATE)," ",TimeHour(CurTime()),":",TimeMinute(CurTime()),"\n Symbol=",Symbol()," Period=",Period());
           }
         BufD[SH]=High[SH]+R*0.5; UD=SH_BUY;
        }
     }
   return(0);
  }
//+------------------------------------------------------------------+