//+------------------------------------------------------------------+
//|                                   Heiken_Ashi_SmoothedSignal.mqh |
//|                             Copyright  2011,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
//+------------------------------------------------------------------+
//| Included files                                                   |
//+------------------------------------------------------------------+
#property tester_indicator "Heiken_Ashi_Smoothed.ex5"
#include <Expert\ExpertSignal.mqh>
//--- wizard description start
//+------------------------------------------------------------------+ 
//|  Declaration of constants                                        |
//+------------------------------------------------------------------+ 
#define OPEN_LONG     80  // The constant for returning the buy command to the Expert Advisor
#define OPEN_SHORT    80  // The constant for returning the sell command to the Expert Advisor
#define CLOSE_LONG    40  // The constant for returning the command to close a long position to the Expert Advisor
#define CLOSE_SHORT   40  // The constant for returning the command to close a short position to the Expert Advisor
#define REVERSE_LONG  100 // The constant for returning the command to reverse a long position to the Expert Advisor
#define REVERSE_SHORT 100 // The constant for returning the command to reverse a short position to the Expert Advisor
#define NO_SIGNAL      0  // The constant for returning the absence of a signal to the Expert Advisor
//+----------------------------------------------------------------------+
//| Description of the class                                             |
//| Title=The signals based on Heiken_Ashi_Smoothed indicator            |
//| Type=SignalAdvanced                                                  |
//| Name=Heiken_Ashi_Sm                                                  |
//| Class=CHeiken_Ashi_SmoothedSignal                                    |
//| Page=                                                                |
//| Parameter=BuyPosOpen,bool,true,Permission to buy                     |
//| Parameter=SellPosOpen,bool,true,Permission to sell                   |
//| Parameter=BuyPosClose,bool,true,Permission to exit a long position   |
//| Parameter=SellPosClose,bool,true,Permission to exit a short position |
//| Parameter=Ind_Timeframe,ENUM_TIMEFRAMES,PERIOD_H4,Timeframe          |
//| Parameter=MA_SMethod,uint,5,Smoothing method (1 - 10)                |
//| Parameter=MA_Length,uint,30,Smoothing depth                          |
//| Parameter=MA_Phase,uint,100,Smoothing parameter                      |
//| Parameter=SignalBar,uint,1,Bar index for entry signal                |
//+----------------------------------------------------------------------+
//--- wizard description end
//+----------------------------------------------------------------------+
//| CHeiken_Ashi_SmoothedSignal class.                                   |
//| Purpose: Signals generator class by the indicator values             |
//| Heiken_Ashi_Smoothed http://www.mql5.com/en/code/481/.               |
//|             Is derived from the CExpertSignal class.                 |
//+----------------------------------------------------------------------+
class CHeiken_Ashi_SmoothedSignal : public CExpertSignal
  {
protected:
   CiCustom          m_indicator;        // the object for access to Heiken_Ashi_Smoothed values

   //--- adjusted parameters
   bool              m_BuyPosOpen;       // permission to buy
   bool              m_SellPosOpen;      // permission to sell
   bool              m_BuyPosClose;      // permission to exit a long position
   bool              m_SellPosClose;     // permission to exit a short position
   ENUM_TIMEFRAMES   m_Ind_Timeframe;    // Heiken_Ashi_Smoothed indicator timeframe
   uint              m_MA_SMethod;       // smoothing method (1 - 10)
   uint              m_MA_Length;        // smoothing depth
   uint              m_MA_Phase;         // smoothing parameter
   uint              m_SignalBar;        // bar index for getting entry signal 

public:
                     CHeiken_Ashi_SmoothedSignal();

   //--- methods of setting adjustable parameters
   void              BuyPosOpen(bool value)                  { m_BuyPosOpen=value;       }
   void              SellPosOpen(bool value)                 { m_SellPosOpen=value;      }
   void              BuyPosClose(bool value)                 { m_BuyPosClose=value;      }
   void              SellPosClose(bool value)                { m_SellPosClose=value;     }
   void              Ind_Timeframe(ENUM_TIMEFRAMES value)    { m_Ind_Timeframe=value;    }
   void              MA_SMethod(uint value)                  { m_MA_SMethod=value;       }
   void              MA_Length(uint value)                   { m_MA_Length=value;        }
   void              MA_Phase(uint value)                    { m_MA_Phase=value;         }
   void              SignalBar(uint value)                   { m_SignalBar=value;        }

   //--- adjustable parameters validation method
   virtual bool      ValidationSettings();
   //--- adjustable parameters validation method
   virtual bool      InitIndicators(CIndicators *indicators); // indicators initialization
   //--- market entry signals generation method
   virtual int       LongCondition();
   virtual int       ShortCondition();

   bool              InitHeiken_Ashi_Sm(CIndicators *indicators);   // Heiken_Ashi_Smoothed indicator initializing method

protected:

  };
//+------------------------------------------------------------------+
//| CHeiken_Ashi_SmoothedSignal constructor.                         |
//| INPUT:  no.                                                      |
//| OUTPUT: no.                                                      |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
void CHeiken_Ashi_SmoothedSignal::CHeiken_Ashi_SmoothedSignal()
  {
//--- setting default values
   m_BuyPosOpen=true;
   m_SellPosOpen=true;
   m_BuyPosClose=true;
   m_SellPosClose=true;
   m_Ind_Timeframe=PERIOD_H4;
   m_MA_SMethod=5;
   m_MA_Length=30;
   m_MA_Phase=100;
   m_SignalBar=1;
   m_used_series=USE_SERIES_OPEN+USE_SERIES_HIGH+USE_SERIES_LOW+USE_SERIES_CLOSE;
  }
//+------------------------------------------------------------------+
//| Checking adjustable parameters.                                  |
//| INPUT:  no.                                                      |
//| OUTPUT: true, if the settings are valid, false - if not.         |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
bool CHeiken_Ashi_SmoothedSignal::ValidationSettings()
  {
//--- checking parameters
   if(m_MA_SMethod<1)
     {
      printf(__FUNCTION__+": Smoothing method parameter cannot be less than 1!");
      printf(__FUNCTION__+": Default value equal to 1 will be used!");
      m_MA_SMethod=1;
     }

   if(m_MA_SMethod>10)
     {
      printf(__FUNCTION__+": Smoothing method parameter cannot exceed 10!");
      printf(__FUNCTION__+": Default value equal to 10 will be used!");
      m_MA_SMethod=10;
     }

//--- successful completion
   return(true);
  }
//+------------------------------------------------------------------+
//| Initialization of indicators and time series.                    |
//| INPUT:  indicators - pointer to an object-collection             |
//|                      of indicators and time series.              |
//| OUTPUT: true - in case of successful, otherwise - false.         |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
bool CHeiken_Ashi_SmoothedSignal::InitIndicators(CIndicators *indicators)
  {
//--- check of pointer
   if(indicators==NULL) return(false);

//--- indicator initialization
   if(!InitHeiken_Ashi_Sm(indicators)) return(false);

//--- successful completion
   return(true);
  }
//+------------------------------------------------------------------+
//| Heiken_Ashi_Smoothed indicator initialization.                   |
//| INPUT:  indicators - pointer to an object-collection             |
//|                      of indicators and time series.              |
//| OUTPUT: true - in case of successful, otherwise - false.         |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
bool CHeiken_Ashi_SmoothedSignal::InitHeiken_Ashi_Sm(CIndicators *indicators)
  {
//--- check of pointer
   if(indicators==NULL) return(false);

//--- adding an object to the collection
   if(!indicators.Add(GetPointer(m_indicator)))
     {
      printf(__FUNCTION__+": error of adding the object");
      return(false);
     }

//--- setting the indicator parameters
   MqlParam parameters[4];

   parameters[0].type=TYPE_STRING;
   parameters[0].string_value="Heiken_Ashi_Smoothed.ex5";

   parameters[1].type=TYPE_INT;
   parameters[1].integer_value=m_MA_SMethod;

   parameters[2].type=TYPE_INT;
   parameters[2].integer_value=m_MA_Length;

   parameters[3].type=TYPE_INT;
   parameters[3].integer_value=m_MA_Phase;

//--- object initialization   
   if(!m_indicator.Create(m_symbol.Name(),m_Ind_Timeframe,IND_CUSTOM,4,parameters))
     {
      printf(__FUNCTION__+": object initialization error");
      return(false);
     }
     
//--- number of buffers
   if(!m_indicator.NumBuffers(5)) return(false);
   
//--- Heiken_Ashi_Smoothed indicator initialized successfully
   return(true);
  }
//+------------------------------------------------------------------+
//| Checking conditions for opening a long position and              |
//| closing a short one                                              |
//| INPUT:  no                                                       |
//| OUTPUT: Vote weight from 0 to 100                                |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
int CHeiken_Ashi_SmoothedSignal::LongCondition()
  {
//--- buy signal is determined by buffer 4 of the Heiken_Ashi_Smoothed indicator
   double Signal0=m_indicator.GetData(4,m_SignalBar);
   double Signal1=m_indicator.GetData(4,m_SignalBar+1);

//--- getting a trading signal 
   if(Signal0==0)
     {
      if(Signal1==1)
        {
         if(m_BuyPosOpen)
           {
            if(m_SellPosClose) return(REVERSE_SHORT);
            else return(OPEN_LONG);
           }
         if(m_SellPosClose) return(CLOSE_SHORT);
        }
     }
//--- no trading signal
   return(NO_SIGNAL);
  }
//+------------------------------------------------------------------+
//| Checking conditions for opening a short position and             |
//| closing a long one                                               |
//| INPUT:  no                                                       |
//| OUTPUT: Vote weight from 0 to 100                                |
//| REMARK: no.                                                      |
//+------------------------------------------------------------------+
int CHeiken_Ashi_SmoothedSignal::ShortCondition()
  {
//--- sell signal is determined by buffer 4 of the Heiken_Ashi_Smoothed indicator
   double Signal0=m_indicator.GetData(4,m_SignalBar);
   double Signal1=m_indicator.GetData(4,m_SignalBar+1);

//--- getting a trading signal 
   if(Signal0==1)
     {
      if(Signal1==0)
        {
         if(m_SellPosOpen)
           {
            if(m_BuyPosClose) return(REVERSE_LONG);
            else return(OPEN_LONG);
           }
         if(m_BuyPosClose) return(CLOSE_LONG);
        }
     }
//--- no trading signal   
   return(NO_SIGNAL);
  }
//+------------------------------------------------------------------+
