//+------------------------------------------------------------------+
//|                                                 TradeContext.mq4 |
//|                                      Copyright  2006, komposter |
//|                                      mailto:komposterius@mail.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, komposter"
#property link      "mailto:komposterius@mail.ru"

/////////////////////////////////////////////////////////////////////////////////
/**/ int _IsTradeAllowed( int MaxWaiting_sec = 30 )
/////////////////////////////////////////////////////////////////////////////////
//     .  :
//  1 -   ,  
//  0 -    ,  .       .
// -1 -   ,    (   ,  ,  
// 	   /  , ... )
// -2 -   ,     (MaxWaiting_sec). ,   
// 	   ( "  "   ).
//
// MaxWaiting_sec -  ( ),          (  
// ).   = 30.
/////////////////////////////////////////////////////////////////////////////////
{
	// ,    
	if ( !IsTradeAllowed() )
	{
		int StartWaitingTime = GetTickCount();
		Print( "  ! ,   ..." );
		//  
		while ( true )
		{
			//     ,  
			if ( IsStopped() ) { Print( "   !" ); return(-1); }
			//     ,    MaxWaiting_sec,   
			if ( GetTickCount() - StartWaitingTime > MaxWaiting_sec * 1000 ) { Print( "   (" + MaxWaiting_sec + " .)!" ); return(-2); }
			//    ,
			if ( IsTradeAllowed() )
			{
				Print( "  !" );
				return(0);
			}
			//         , "" 0,1     
			Sleep(100);
		}
	}
	else
	{
		Print( "  !" );
		return(1);
	}
}
/*
 ,   _IsTradeAllowed:
int start()
{
	//     
	...
	//    ,     
	...
	// ,    
	int TradeAllow = _IsTradeAllowed();
	if ( TradeAllow < 0 ) { return(-1); }
	if ( TradeAllow == 0 )
	{
		RefreshRates();
		//       
		...
	}
	//  
	OrderSend(.....);
return(0);
}
*/

/////////////////////////////////////////////////////////////////////////////////
/**/ int TradeIsBusy ( int MaxWaiting_sec = 30 )
/////////////////////////////////////////////////////////////////////////////////
//      TradeIsBusy  0  1.
//     TradeIsBusy = 1,  ,  TradeIsBusy  = 0,    .
//    TradeIsBusy  ,   .
//  :
//  1 -  .   TradeIsBusy   1
// -1 -     TradeIsBusy = 1,     (   ,  
// ,   /  , ... )
// -2 -     TradeIsBusy = 1,     (MaxWaiting_sec)
/////////////////////////////////////////////////////////////////////////////////
{
	//         -    
	if ( IsTesting() ) { return(1); }
	int _GetLastError = 0, StartWaitingTime = GetTickCount();

	//+------------------------------------------------------------------+
	//| ,   .  ,  ,  
	//+------------------------------------------------------------------+
	while( true )
	{
		//     ,  
		if ( IsStopped() ) { Print( "   !" ); return(-1); }
		//     ,    MaxWaiting_sec,   
		if ( GetTickCount() - StartWaitingTime > MaxWaiting_sec * 1000 ) { Print( "   (" + MaxWaiting_sec + " .)!" ); return(-2); }
		// ,   . 
		if ( GlobalVariableCheck( "TradeIsBusy" ) )
		//   ,           TradeIsBusy
		{ break; }
		else
		//  GlobalVariableCheck  FALSE,    ,     
		{
			_GetLastError = GetLastError();
			//     ,  ,  0,1     
			if ( _GetLastError != 0 )
			{
				Print( "TradeIsBusy() - GlobalVariableCheck ( \"TradeIsBusy\" ) - Error #", _GetLastError );
				Sleep(100);
				continue;
			}
		}

		//   ,     ,   
		if ( GlobalVariableSet ( "TradeIsBusy", 1.0 ) > 0 )
		//  GlobalVariableSet > 0,     .   -
		{ return(1); }
		else
		//  GlobalVariableSet   <= 0,      
		{
			_GetLastError = GetLastError();
			//  ,  0,1     
			if ( _GetLastError != 0 )
			{
				Print( "TradeIsBusy() - GlobalVariableSet ( \"TradeIsBusy\", 0.0 ) - Error #", _GetLastError );
				Sleep(100);
				continue;
			}
		}
	}

	//+------------------------------------------------------------------+
	//|       ,    .
	//| ,  TradeIsBusy  = 0    TradeIsBusy  0  1
	//+------------------------------------------------------------------+
	while( true )
	{
		//     ,  
		if ( IsStopped() ) { Print( "   !" ); return(-1); }
		//     ,    MaxWaiting_sec,   
		if ( GetTickCount() - StartWaitingTime > MaxWaiting_sec * 1000 ) { Print( "   (" + MaxWaiting_sec + " .)!" ); return(-2); }
		//    TradeIsBusy  0  1
		if ( GlobalVariableSetOnCondition( "TradeIsBusy", 1.0, 0.0 ) )
		//    ,   -,  1 - " "
		{ return(1); }
		else
		//  ,  2 : TradeIsBusy = 1 (  ),    (   )
		{
			_GetLastError = GetLastError();
			//     ,      
			if ( _GetLastError != 0 )
			{
				Print( "TradeIsBusy() - GlobalVariableSetOnCondition ( \"TradeIsBusy\", 1.0, 0.0 ) - Error #", _GetLastError );
				continue;
			}
		}

		//   ,  TradeIsBusy = 1 (  ) -    ...
		Comment ( ",     ..." );
		Sleep(1000);
	}
}

/////////////////////////////////////////////////////////////////////////////////
/**/ void TradeIsNotBusy ()
/////////////////////////////////////////////////////////////////////////////////
//      TradeIsBusy = 0.
//    TradeIsBusy  ,   .
/////////////////////////////////////////////////////////////////////////////////
{
	//         -    
	if ( IsTesting() ) { return(0); }
	int _GetLastError;

	while( true )
	{
		//     ,  
		if ( IsStopped() ) { Print( "   !" ); return(-1); }
		//    .  = 0 (  . )
		if ( GlobalVariableSet( "TradeIsBusy", 0.0 ) > 0 )
		//  GlobalVariableSet   > 0,    .   -
		{ return(1); }
		else
		//  GlobalVariableSet   <= 0,   .  , ,    
		{
			_GetLastError = GetLastError();
			if ( _GetLastError != 0 )
			{ Print( "TradeIsNotBusy() - GlobalVariableSet ( \"TradeIsBusy\", 0.0 ) - Error #", _GetLastError ); }
		}
		Sleep(100);
	}
}

/*
 ,   TradeIsBusy()  TradeIsNotBusy():

#include <TradeContext.mqh>

int start()
{
	//     
	...
	//    ,     
	...
	//        (  , )
	if ( TradeIsBusy() < 0 ) { return(-1); }
	//   
	RefreshRates();
	//       
	...
	//  
	OrderSend(.....);
	//   
	TradeIsNotBusy();
return(0);
}
*/