//+------------------------------------------------------------------+
//|                                                        mt4mm.mq4 |
//|                                         Copyright  2007, 4xTrim |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, 4xTrim"
#property link      ""

#include <WinUser32.mqh>

#import "mt4mm.dll"
   int mmOpen(int hWnd, string szSymbol, int inI[], double inF[], double cur[], double out[]);
#import

#define SLIPPAGE  100
int    TryCount   = 5;
string mt4comment = "";

//+------------------------------------------------------------------+
//| script program start function                                    |
//+------------------------------------------------------------------+
int start()
  {
   int inI[3];
   int i, ticket, ssl, stp;
   double inF[10];
   double cur[4];
   double out[12];
   // out[0]   -  0 -   , 1 -  
   // out[1]   -   :
   //             0 - BUY
   //             1 - SELL
   //             2 - BUY LIMIT
   //             3 - SELL LIMIT
   //             4 - BUY STOP
   //             5 - SELL STOP
   // out[2]   -    
   // out[3]   -   
   // out[4]   -   
   // out[5]   -  -  
   // out[6]   -  0 -   stop-loss, > 0 -  stop-loss
   // out[7]   -  -  
   // out[8]   -  0 -   take-profit, > 0 -  take-profit
   // out[9]   -  0 -      , > 0 -   
   // out[10]   -  0 -      , > 0 -   
   // out[11]   -  MAGIC
//----
   cur[0]  = MarketInfo("EURUSD", MODE_BID);
   cur[1]  = MarketInfo("GBPUSD", MODE_BID);
   cur[2]  = MarketInfo("USDCHF", MODE_BID);
   cur[3]  = MarketInfo("USDJPY", MODE_BID);
//----
   inI[0]  = Digits;
   inI[1]  = MarketInfo(Symbol(), MODE_PROFITCALCMODE);
   inI[2]  = MarketInfo(Symbol(), MODE_MARGINCALCMODE);
//----
   inF[0]  = MarketInfo(Symbol(), MODE_TICKSIZE);
   inF[1]  = MarketInfo(Symbol(), MODE_TICKVALUE);
   inF[2]  = MarketInfo(Symbol(), MODE_MINLOT);
   inF[3]  = MarketInfo(Symbol(), MODE_LOTSTEP);
   inF[4]  = MarketInfo(Symbol(), MODE_STOPLEVEL);
   inF[5]  = MarketInfo(Symbol(), MODE_MARGINREQUIRED);
   inF[6]  = Bid;
   inF[7]  = MarketInfo(Symbol(), MODE_SPREAD);
   inF[8]  = AccountBalance();
   inF[9]  = AccountEquity();
//----
   mmOpen(WindowHandle(Symbol(),Period()), Symbol(), inI, inF, cur, out);
   if (out[0] == 1)
   {
      for (i = 0; i < out[2]; i++)
      {
         ssl = 0; stp = 0;
         if (out[6] > 0 && out[9] > 0.0) ssl = out[5];
         if (out[8] > 0 && out[10]> 0.0) stp = out[7];
         ticket = SetOrder(out[1], out[4], out[3], ssl, stp , out[11]);
         if (ticket > 0 && (out[6] > 0 || out[8] > 0))
         {
            if (out[6] == 0.0) out[5] = 0.0;
            if (out[8] == 0.0) out[7] = 0.0;
            ModOrder(ticket, out[1], out[5], out[7]);
         }
      }
   }
//----
   return(0);
  }

double GetLimit(int type, double openprice, double limitp, bool GetStop)
{
   double limit = 0.0;
//----
   if (limitp > 0.0)
   {
      if (MathMod(type, 2) == 0.0)
      {
         if (GetStop)
            limit = openprice - limitp * MarketInfo(Symbol(), MODE_TICKSIZE);
         else
            limit = openprice + limitp * MarketInfo(Symbol(), MODE_TICKSIZE);
      }
      else
      {
         if (GetStop)
            limit = openprice + limitp * MarketInfo(Symbol(), MODE_TICKSIZE);
         else
            limit = openprice - limitp * MarketInfo(Symbol(), MODE_TICKSIZE);
      }
   }
   return(limit);
}

//+---------------------------------------------------------------------------+
//|                                                             |
//| ---------------                                                           |
//|   type        -                                      |
//|   openprice   - ,                      |
//|   lot         -                                                 |
//|   slp         -  > 0,   -             |
//|   tpp         -  > 0,   -           |
//|   mn          - MAGIC                                                     |
//|  :                                                    |
//|           .        |
//|        -1                                |
//+---------------------------------------------------------------------------+
int SetOrder(int type, double openprice, double lot, double slp, double tpp, double mn)
{
   int ticket = 0;
   int i = 0;
   string com;
//----
   if (lot < MarketInfo(Symbol(), MODE_MINLOT))
     lot = MarketInfo(Symbol(), MODE_MINLOT);
   if (lot > MarketInfo(Symbol(), MODE_MAXLOT))
     lot = MarketInfo(Symbol(), MODE_MAXLOT);
   GetLastError();   //   last_error
   while(i < TryCount)
   {
      com = mt4comment;
      if (slp > 0.0 || tpp > 0.0)
      {
         if (StringLen(mt4comment) > 0)
            com = com + " ";
         com = com + "(";
         if (slp > 0.0)
         {
            com = com + "SL: " + DoubleToStr(GetLimit(type, openprice, slp, true), Digits);
            if (tpp > 0.0)
               com = com + " / ";
         }
         if (tpp > 0.0)
            com = com + "TP: " + DoubleToStr(GetLimit(type, openprice, tpp, false), Digits);
         com = com + ")";
      }
      ticket = OrderSend(Symbol(), type, lot, openprice, SLIPPAGE, 0, 0, com, mn);
      if(ticket > 0)
         return(ticket);
      else
      {
         i++;
         //    
         if(ProcessError(GetLastError()))
         {
            RefreshRates();
            switch (type)
            {
            case OP_BUY:
               openprice = Ask;
               break;
            case OP_SELL:
               openprice = Bid;
               break;
            }
         }
         //   
         else
            return(-1);
      }
   }
   Print("  ", TryCount, "     \"", Symbol(), "\"   ");
   return(-1);
}

//+---------------------------------------------------------------------------+
//|                                                          |
//| ------------------                                                        |
//|   ticket   -                                    |
//|   type     -                                      |
//|   slp      - -                                            |
//|   tpp      - -                                          |
//|  :                                                    |
//|          TRUE.           |
//|      - FALSE.                                             |
//+---------------------------------------------------------------------------+
bool ModOrder(int ticket, double type, double slp, double tpp)
{
   if (OrderSelect(ticket, SELECT_BY_TICKET) == true)
   {
      double sl = 0.0, tp = 0.0;
      int i = 0;
//----
      if (MathMod(type, 2) == 0.0)
      {
         if (slp > 0.0) sl = OrderOpenPrice() - slp * MarketInfo(Symbol(), MODE_TICKSIZE);
         if (tpp > 0.0) tp = OrderOpenPrice() + tpp * MarketInfo(Symbol(), MODE_TICKSIZE);
      }
      else
      {
         if (slp > 0.0) sl = OrderOpenPrice() + slp * MarketInfo(Symbol(), MODE_TICKSIZE);
         if (tpp > 0.0) tp = OrderOpenPrice() - tpp * MarketInfo(Symbol(), MODE_TICKSIZE);
      }
      GetLastError();
      while (i < TryCount)
      {
         if (OrderModify(OrderTicket(), OrderOpenPrice(), sl, tp, 0))
            return(true);
         else
         {
            if (!ProcessError(GetLastError()))
               return(false);
            i++;
         }
      }
      Print("  ", TryCount, "    ", OrderTicket(), "   ");
   }
   return(false);
}

//+---------------------------------------------------------------------------+
//|                                                            |
//| ----------------                                                          |
//|   err -                                               |
//|  :                                                    |
//|       ,       |
//|    ,   TRUE.                          |
//|      - FALSE.                                             |
//+---------------------------------------------------------------------------+
bool ProcessError(int err)
{
   int iteration;
//----
   PrintError(err);
   switch(err)
   {
   //  
   case 0:     // ERR_NO_ERROR
   case 135:   // ERR_PRICE_CHANGED
   case 138:   // ERR_REQUOTE
      return(true);
   //  ,  
   case 4:     // ERR_SERVER_BUSY
   case 128:   // ERR_TRADE_TIMEOUT
      Sleep(1000 * 60);
      return(true);   
   case 129:   // ERR_INVALID_PRICE
   case 130:   // ERR_INVALID_STOPS
   case 136:   // ERR_OFF_QUOTES
      Sleep(1000 * 5);
      return(true);   
   case 137:   // ERR_BROKER_BUSY
   case 145:   // ERR_TRADE_MODIFY_DENIED
      Sleep(1000 * 15);
      return(true);   
   //    .   
   case 6:     // ERR_NO_CONNECTION
   {
      bool connect = false;
      iteration = 0;
      while((!connect) || (iteration < 60)) //   5     
      {
         Sleep(1000 * 5);
         connect = IsConnected();
         if(connect)
         {
            Print(" ");
            return(true);
         }
         iteration++;
         Print("  ,  ", iteration * 5, " .");
      }
      Print("   ", iteration * 5, "    .");
      return(false);
   }
   //   . ,  
   case 146:   // ERR_TRADE_CONTEXT_BUSY
   {
      bool tradecontextbusy = true;
      iteration = 0;
      while((tradecontextbusy) || (iteration < 60)) //   5     
      {
         Sleep(1000 * 5);
         tradecontextbusy = IsTradeContextBusy();
         if(!tradecontextbusy)
         {
            Print("  .");
            return(true);
         }
         iteration++;
         Print("    ,  ", iteration * 5, " .");
      }
      Print("    ", iteration * 5, "   .");
      return(false);
   }
   //  .    
   case 1:     // ERR_NO_RESULT
   case 2:     // ERR_COMMON_ERROR
   case 3:     // ERR_INVALID_TRADE_PARAMETERS
   case 5:     // ERR_OLD_VERSION
   case 7:     // ERR_NOT_ENOUGH_RIGHTS
   case 8:     // ERR_TOO_FREQUENT_REQUESTS
   case 9:     // ERR_MALFUNCTIONAL_TRADE
   case 64:    // ERR_ACCOUNT_DISABLED
   case 65:    // ERR_INVALID_ACCOUNT
   case 131:   // ERR_INVALID_TRADE_VOLUME
   case 132:   // ERR_MARKET_CLOSED
   case 133:   // ERR_TRADE_DISABLED
   case 134:   // ERR_NOT_ENOUGH_MONEY
   case 139:   // ERR_ORDER_LOCKED
   case 140:   // ERR_LONG_POSITIONS_ONLY_ALLOWED
   case 141:   // ERR_TOO_MANY_REQUESTS
   case 142:
   case 143:
   case 144:
   case 147:   // ERR_TRADE_EXPIRATION_DENIED
   case 148:   // ERR_TRADE_TOO_MANY_ORDERS
   case 4109:  // ERR_TRADE_NOT_ALLOWED
   case 4110:  // ERR_LONGS_NOT_ALLOWED
   case 4111:  // ERR_SHORTS_NOT_ALLOWED
      return(false);
   }
   return(false);
}
//+---------------------------------------------------------------------------+
//|                                            |
//| --------------------------------------                                    |
//|   err -                                               |
//+---------------------------------------------------------------------------+
int PrintError(int err)
{
   Print("ERROR ", err, ":  ", err2str(err));
   return(0);
}
//+---------------------------------------------------------------------------+
//|                                          |
//| --------------------------------------                                    |
//|   err -                                               |
//|  :                                                    |
//|                                   |
//+---------------------------------------------------------------------------+
string err2str(int err)
{
   switch(err)
   {
   case 0:
      return(" ");
   case 1:
      return("          ");
   case 2:
      return(" ");
   case 3:
      return("     ");
   case 4:
      return("  ");
   case 5:
      return("   ");
   case 6:
      return("    ");
   case 7:
      return(" ");
   case 8:
      return("  ");
   case 9:
      return("    ");
   case 64:
      return(" ");
   case 65:
      return("  ");
   case 128:
      return("    ");
   case 129:
      return(" ");
   case 130:
      return(" ");
   case 131:
      return("  ");
   case 132:
      return(" ");
   case 133:
      return(" . ,       ");
   case 134:
      return("    ");
   case 135:
      return(" ");
   case 136:
      return(" ");
   case 137:
      return(" ");
   case 138:
      return("!  ");
   case 139:
      return("    ");
   case 140:
      return("  ");
   case 141:
      return("  ");
   case 142:
      return("   ");
   case 143:
      return("    ");
   case 144:
      return("       ");
   case 145:
      return(" ,       ");
   case 146:
      return("  ");
   case 147:
      return("     ");
   case 148:
      return("      ,  ");
   case 4109:
      return("  .     \"  \"   ");
   case 4110:
      return("   ");
   case 4111:
      return("   ");
   }
   return("   ");
}
//+---------------------------------------------------------------------------+

