//+------------------------------------------------------------------+
//|                                                 b-SharingDoW.mqh |
//|                                             . aka KimIV |
//|                                              http://www.kimiv.ru |
//|                                                                  |
//|    03.02.2006  Sharing the Deals on Weekdays.                    |
//|                    .              |
//|                                                                  |
//|     :                              |
//|  -         : #include <b-SharingDoW.mqh>               |
//|  -   deinit(): WriteDealsInfo();                         |
//+------------------------------------------------------------------+

//-------    -----------------------------------
extern string _P_b_SharingDoW = "----------   b-SharingDoW";
extern bool   sdUseModule   = False;
extern string sdOutFileName = "SharingDoW.csv";

//-------    -------------------------------


//+------------------------------------------------------------------+
//|         .          |
//+------------------------------------------------------------------+
void WriteDealsInfo()
{
  double op[6]={0,0,0,0,0,0};     //  
  double ou[6]={0,0,0,0,0,0};     //  
  double pr;
  double mb[6]={0,0,0,0,0,0};     //  
  double mr[6]={0,0,0,0,0,0};     //  
  int    i, j, nd;
  int    vs[6]={0,0,0,0,0,0};     //  
  double kp[6]={0,0,0,0,0,0};     //   
  int    sp[6]={0,0,0,0,0,0};     //   
  int    mp[6]={0,0,0,0,0,0};     //    
  int    su[6]={0,0,0,0,0,0};     //   
  int    mu[6]={0,0,0,0,0,0};     //    
  string text="";

  if (IsTesting() && sdUseModule)
  {
    text=";;;;;;";
    WritingLineInFile(sdOutFileName, text);

    for (i=0; i<HistoryTotal(); i++)
    {
      if (OrderSelect(i, SELECT_BY_POS, MODE_HISTORY))
      {
        if (OrderSymbol()==Symbol() && OrderMagicNumber()==MAGIC)
        {
          if (OrderType()==OP_BUY || OrderType()==OP_SELL)
          {
            nd=TimeDayOfWeek(OrderOpenTime())-1;
            if (OrderProfit()>0)
            { 
              op[nd]+=OrderProfit();
              op[5]+=OrderProfit();
              kp[nd]++; kp[5]++;
              sp[nd]++; sp[5]++;
              su[nd]=0; su[5]=0;
            }
            else
            {
              ou[nd]+=OrderProfit();
              ou[5]+=OrderProfit();
              sp[nd]=0; sp[5]=0;
              su[nd]++; su[5]++;
            }
            op[nd]+=OrderSwap();
            op[5]+=OrderSwap();
            for (j=0; j<6; j++) {
              if (mb[j]<op[j]+ou[j]) mb[j]=op[j]+ou[j];
              if (mr[j]<mb[j]-op[j]-ou[j]) mr[j]=mb[j]-op[j]-ou[j];
              if (mp[j]<sp[j]) mp[j]=sp[j];
              if (mu[j]<su[j]) mu[j]=su[j];
            }
            vs[nd]++;
            vs[5]++;
          }
        }
      }
    }

    text=" ";
    for (i=0; i<6; i++) text=text+";"+DoubleToStr(op[i]+ou[i], 2);
    WritingLineInFile(sdOutFileName, StrTran(text, ".", ","));

    text=" ";
    for (i=0; i<6; i++) text=text+";"+DoubleToStr(op[i], 2);
    WritingLineInFile(sdOutFileName, StrTran(text, ".", ","));

    text=" ";
    for (i=0; i<6; i++) text=text+";"+DoubleToStr(ou[i], 2);
    WritingLineInFile(sdOutFileName, StrTran(text, ".", ","));

    text="";
    for (i=0; i<6; i++)
    {
      if (ou[i]==0) pr=0; else pr=MathAbs(op[i]/ou[i]);
      text=text+";"+DoubleToStr(pr, 2);
    }
    WritingLineInFile(sdOutFileName, StrTran(text, ".", ","));

    text="";
    for (i=0; i<6; i++) text=text+";"+DoubleToStr(mr[i], 2);
    WritingLineInFile(sdOutFileName, StrTran(text, ".", ","));

    text="";
    for (i=0; i<6; i++)
    {
      if (mr[i]==0) pr=0; else pr=(op[i]+ou[i])/mr[i];
      text=text+";"+DoubleToStr(pr, 2);
    }
    text=" ."+StrTran(text, ".", ",");
    WritingLineInFile(sdOutFileName, text);

    text=" ";
    for (i=0; i<6; i++) text=text+";"+DoubleToStr(vs[i], 0);
    WritingLineInFile(sdOutFileName, text);

    text=", %";
    for (i=0; i<6; i++)
    {
      if (vs[i]==0) pr=0; else pr=kp[i]/vs[i]*100;
      text=text+";"+DoubleToStr(pr, 2);
    }
    WritingLineInFile(sdOutFileName, StrTran(text, ".", ","));

    text=". ";
    for (i=0; i<6; i++)
    {
      if (kp[i]==0) pr=0; else pr=op[i]/kp[i];
      text=text+";"+DoubleToStr(pr, 2);
    }
    WritingLineInFile(sdOutFileName, StrTran(text, ".", ","));

    text="";
    for (i=0; i<6; i++) text=text+";"+DoubleToStr(mp[i], 0);
    text=". "+StrTran(text, ".", ",");
    WritingLineInFile(sdOutFileName, text);

    text=". ";
    for (i=0; i<6; i++)
    {
      if (vs[i]-kp[i]==0) pr=0; else pr=ou[i]/(vs[i]-kp[i]);
      text=text+";"+DoubleToStr(pr, 2);
    }
    WritingLineInFile(sdOutFileName, StrTran(text, ".", ","));

    text="";
    for (i=0; i<6; i++) text=text+";"+DoubleToStr(mu[i], 0);
    text=". "+StrTran(text, ".", ",");
    WritingLineInFile(sdOutFileName, text);
  }
}

//+------------------------------------------------------------------+
//|                                                   |
//| :                                                       |
//|   str     -  ,          |
//|   strfrom -                                   |
//|   strto   -                                   |
//+------------------------------------------------------------------+
string StrTran(string str, string strfrom, string strto)
{
  int    n;
  string outstr="", tempstr;

  for (n=0; n<StringLen(str); n++)
  {
    tempstr=StringSubstr(str, n, StringLen(strfrom));
    if (tempstr==strfrom)
    {
      outstr=outstr+strto;
      n=n+StringLen(strfrom)-1;
    } else outstr=outstr+StringSubstr(str, n, 1);
  }
  return(outstr);
}

//+------------------------------------------------------------------+
//|                                                 |
//+------------------------------------------------------------------+
void WritingLineInFile(string FileName, string text)
{
  int file_handle=FileOpen(FileName, FILE_READ|FILE_WRITE, " ");

	if (file_handle>0)
	{
		FileSeek(file_handle, 0, SEEK_END);
		FileWrite(file_handle, text);
		FileClose(file_handle);
	}
}
//+------------------------------------------------------------------+

