//+------------------------------------------------------------------+
//|                                                       SL_ATR.mq5 | 
//|                               Copyright  2011, Vladimir Hlystov |
//|                                                cmillion@narod.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, Vladimir Hlystov"
#property link      "cmillion@narod.ru"
#property description "The indicator shows the best places for setting a stop-loss for current positions."
#property description "The indicator can be used for trailing stop operation."
//---- indicator version
#property version   "1.00"
//---- drawing the indicator in the main window
#property indicator_chart_window 
//---- number of indicator buffers 4
#property indicator_buffers 4
//---- only 2 plots are used
#property indicator_plots   2
//+----------------------------------------------+
//|  Declaration of constants                    |
//+----------------------------------------------+
#define RESET 0 // the constant for getting the command for the indicator recalculation back to the terminal
//+--------------------------------------------+
//|  Indicator levels drawing parameters       |
//+--------------------------------------------+
//---- drawing the levels as a cloud
#property indicator_type1   DRAW_FILLING
#property indicator_type2   DRAW_FILLING
//---- selection of levels colors
#property indicator_color1  LightGreen,LightGreen
#property indicator_color2  Violet,Violet
//---- display levels labels
#property indicator_label1  "StopLoss Sell Min/Max"
#property indicator_label2  "StopLoss Buy Min/Max"
//+-----------------------------------+
//|  Indicator input parameters       |
//+-----------------------------------+
input int Period_ATR=14;  // R period
//+-----------------------------------+
//---- declaration of dynamic arrays that
//---- will be used as indicator buffers
double ExtLineBuffer1[],ExtLineBuffer2[],ExtLineBuffer3[],ExtLineBuffer4[];
//---- declaration of integer variables for storing the indicators handles
int ATR_Handle;
//---- declaration of the integer variables for the start of data calculation
int StartBars,StartBars1,StartBars2;
//+------------------------------------------------------------------+   
//| SL_ATR indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---- initialization of variables of the start of data calculation
   StartBars=Period_ATR;

//---- getting handle of the ATR indicator
   ATR_Handle=iATR(NULL,0,Period_ATR);
   if(ATR_Handle==INVALID_HANDLE)Print(" Failed to get handle of the ATR indicator");

//---- set dynamic arrays as indicator buffers
   SetIndexBuffer(0,ExtLineBuffer1,INDICATOR_DATA);
   SetIndexBuffer(1,ExtLineBuffer2,INDICATOR_DATA);
   SetIndexBuffer(2,ExtLineBuffer3,INDICATOR_DATA);
   SetIndexBuffer(3,ExtLineBuffer4,INDICATOR_DATA);

//---- set the position, from which the Bollinger Bands drawing starts
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,StartBars);
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,StartBars);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,StartBars);
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,StartBars);

//---- restriction to draw empty values for the indicator
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
   
//---- indexing the elements in buffers as timeseries   
   ArraySetAsSeries(ExtLineBuffer1,true);
   ArraySetAsSeries(ExtLineBuffer2,true);
   ArraySetAsSeries(ExtLineBuffer3,true);
   ArraySetAsSeries(ExtLineBuffer4,true);

//---- initializations of a variable for the indicator short name
   string shortname;
   StringConcatenate(shortname,"SL_ATR(",Period_ATR,")");
//---- creating a name for displaying in a separate sub-window and in a tooltip
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---- determination of accuracy of displaying the indicator values
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---- initialization end
  }
//+------------------------------------------------------------------+ 
//| SL_ATR iteration function                                        | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    // number of bars in history at the current tick
                const int prev_calculated,// number of bars calculated at previous call
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---- checking the number of bars to be enough for the calculation
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<StartBars) return(RESET);

//---- declarations of local variables 
   int to_copy,limit,bar;
   double Range[],ATR;

//---- calculation of the 'limit' starting index for the bars recalculation loop
   if(prev_calculated>rates_total || prev_calculated<=0)// checking for the first start of the indicator calculation
      limit=rates_total-StartBars;         // starting index for calculation of all bars
   else limit=rates_total-prev_calculated; // starting index for calculation of new bars

//---- calculation of the necessary amount of data to be copied
   to_copy=limit+1;

//---- copy newly appeared data in the Range[] arrays
   if(CopyBuffer(ATR_Handle,0,0,to_copy,Range)<=0) return(RESET);

//---- indexing elements in arrays as time series  
   ArraySetAsSeries(Range,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);

//---- main indicator calculation loop
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ATR=Range[bar];
      ExtLineBuffer1[bar]=NormalizeDouble(low[bar] +ATR,_Digits);
      ExtLineBuffer2[bar]=NormalizeDouble(high[bar]+ATR,_Digits);
      ExtLineBuffer3[bar]=NormalizeDouble(high[bar]-ATR,_Digits);
      ExtLineBuffer4[bar]=NormalizeDouble(low[bar] -ATR,_Digits);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
