//+------------------------------------------------------------------+ 
//|                                              NonLagMA_v5_HTF.mq5 | 
//|                               Copyright  2014, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2014, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.00"
#property description "NonLagMA_v5       "
//----     
#property indicator_chart_window
//----   
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+-------------------------------------+
//|                   |
//+-------------------------------------+
#define RESET 0                      //        
#define INDICATOR_NAME "NonLagMA_v5" //    
#define SIZE 1                       //      CountIndicator
//+-------------------------------------+
//|     1   |
//+-------------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_LINE
//----      
#property indicator_color1  clrGray,clrGreen,clrMagenta
//----   -  
#property indicator_style1  STYLE_SOLID
//----     4
#property indicator_width1  4
//----   
#property indicator_label1  INDICATOR_NAME

//+-------------------------------------+
//|           |
//+-------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4; //  
//+-------------------------------------+
//|           |
//+-------------------------------------+
input int                 MAPeriod       = 13;            // 
input  ENUM_MA_METHOD     MAType         = MODE_EMA;      //  
input ENUM_APPLIED_PRICE  MAPrice        = PRICE_CLOSE;   // 
input uint                Filter         = 0;             // Static filter in points  
input uint                ColorBarBack   = 1;             // Bar back for color mode
input double              Deviation      = 0;             // Up/down deviation  
input int                 Shift          = 0;             //                  
//+-------------------------------------+
//----   ,    
//      
double IndBuffer[];
double ColorIndBuffer[];
//----  
string Symbol_,Word;
//----      
int min_rates_total;
//----      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);

//----   
   min_rates_total=2;
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);

//----    NonLagMA_v5
   Ind_Handle=iCustom(Symbol(),TimeFrame,INDICATOR_NAME,MAPeriod,MAType,MAPrice,Filter,ColorBarBack,Deviation,0);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      NonLagMA_v5");
      return(INIT_FAILED);
     }

//----   
   IndInit(0,IndBuffer,ColorIndBuffer,0.0,min_rates_total,0);

//----           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(RESET);

//----         
   ArraySetAsSeries(time,true);

//----
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,0,IndBuffer,1,ColorIndBuffer,
      time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//----     
   return(rates_total);
  }
//----
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],double &ColorBuffer[],double Empty_Value,int Draw_Begin,int nShift)
  {
//----
   int indnumb=2*Number;
   int plotnumb=indnumb;
//----      
   SetIndexBuffer(indnumb,Buffer,INDICATOR_DATA);
   SetIndexBuffer(indnumb+1,ColorBuffer,INDICATOR_COLOR_INDEX);
//----      
   PlotIndexSetInteger(plotnumb,PLOT_DRAW_BEGIN,Draw_Begin);
//----   ,      
   PlotIndexSetDouble(plotnumb,PLOT_EMPTY_VALUE,Empty_Value);
//----       Shift
   PlotIndexSetInteger(plotnumb,PLOT_SHIFT,nShift);
//----       
   ArraySetAsSeries(Buffer,true);
   ArraySetAsSeries(ColorBuffer,true);
//----
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(
                    uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     BuffNumb,        //    
                    double&  IndBuf[],        //   
                    uint     ColBuffNumb,     //    
                    double&  ColIndBuf[],     //   
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total //       
                    )
//---- 
  {
//----
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;

//----      
//  limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       

//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----      
      IndBuf[bar]=0.0;

      //----       IndTime
      if(CopyTime(Symbol_,TFrame,iTime[bar],1,IndTime)<=0) return(RESET);

      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Arr[1],ColArr[1];

         //----      
         if(CopyBuffer(IndHandle,BuffNumb,iTime[bar],1,Arr)<=0) return(RESET);
         if(CopyBuffer(IndHandle,ColBuffNumb,iTime[bar],1,ColArr)<=0) return(RESET);

         IndBuf[bar]=Arr[0];
         ColIndBuf[bar]=ColArr[0];
        }
      else
        {
         IndBuf[bar]=IndBuf[bar+1];
         ColIndBuf[bar]=ColIndBuf[bar+1];
        }
     }
//----     
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(
                     string IndName,
                     ENUM_TIMEFRAMES TFrame //  
                     )
//TimeFramesCheck(INDICATOR_NAME,TimeFrame)
  {
//----     
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("    "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//----
   return(true);
  }
//+------------------------------------------------------------------+
