//+------------------------------------------------------------------+
//|                                                  NonLagMA_v5.mq5 |
//|                                Copyright  2006, TrendLaboratory |
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |
//|                                   E-mail: igorad2003@yahoo.co.uk |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, TrendLaboratory"
#property link      "http://finance.groups.yahoo.com/group/TrendLaboratory"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_LINE
//----      
#property indicator_color1  clrGray,clrGreen,clrMagenta
//----   -  
#property indicator_style1  STYLE_SOLID
//----     3
#property indicator_width1  3
//----   
#property indicator_label1  "NonLagMA_v5"
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET  0 //        
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int                 MAPeriod       = 13;            // 
input  ENUM_MA_METHOD     MAType         = MODE_EMA;      //  
input ENUM_APPLIED_PRICE  MAPrice        = PRICE_CLOSE;   // 
input uint                Filter         = 0;             // Static filter in points  
input uint                ColorBarBack   = 1;             // Bar back for color mode
input double              Deviation      = 0;             // Up/down deviation  
input int                 Shift          = 0;             //      
//+-----------------------------------+

//----   ,    
//      
double IndBuffer[];
double ColorIndBuffer[];
//----
double alfa[];
int Phase,Len,Cycle,size;
double Coeff,beta,t,Sum,Weight,g,pi,dFilter;
//----      
int MA_Handle;
//----      
double dPriceShift;
//----      
int min_rates_total;
//----   
int Count[];
double Trend[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[],//        
                          int Size)
  {
//----
   int numb,Max1,Max2;
   static int count=1;

   Max2=Size;
   Max1=Max2-1;

   count--;
   if(count<0) count=Max1;

   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//----
  }
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----    iMA
   MA_Handle=iMA(NULL,0,MAPeriod,0,MAType,MAPrice);
   if(MA_Handle==INVALID_HANDLE)
     {
      Print("      iMA");
      return(INIT_FAILED);
     }

//----    
   dFilter=Filter*_Point;
//----  
   Cycle=4;
   pi=3.1415926535;
   Coeff=3*pi;
   Phase=MAPeriod-1;
   Len=MAPeriod*Cycle+Phase;
   if(ArrayResize(alfa,Len)<Len)
     {
      Print("      alfa[]");
      return(INIT_FAILED);
     }
   Weight=0;
   for(int iii=0; iii<Len; iii++)
     {
      if(iii<=Phase-1) t=1.0*iii/(Phase-1);
      else t=1.0+(iii-Phase+1)*(2.0*Cycle-1.0)/(Cycle*MAPeriod-1.0);
      beta=MathCos(pi*t);
      g=1.0/(Coeff*t+1);
      if(t<=0.5) g=1;
      alfa[iii]=g*beta;
      Weight+=alfa[iii];
     }
     
//----     
   min_rates_total=int(MAPeriod+ColorBarBack+Len);

//----     
   size=int(ColorBarBack+1);
   if(ArrayResize(Count,size)<size)
     {
      Print("      Count[]");
      return(INIT_FAILED);
     }
   if(ArrayResize(Trend,size)<size)
     {
      Print("      Trend[]");
      return(INIT_FAILED);
     }
   ArrayInitialize(Count,0);
   ArrayInitialize(Trend,0.0);

//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(IndBuffer,true);

//----     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorIndBuffer,true);

//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);

//----      
   string shortname;
   StringConcatenate(shortname,"NonLagMA_v5(",MAPeriod,")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(MA_Handle)<rates_total || rates_total<min_rates_total) return(RESET);

//----    
   int to_copy,limit,bar;
   double MA[];

//----         limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-min_rates_total-1; //      
   else limit=rates_total-prev_calculated; //      
   to_copy=limit+Len+1;

//----      
   if(CopyBuffer(MA_Handle,0,0,to_copy,MA)<=0) return(RESET);

//----         
   ArraySetAsSeries(MA,true);

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      Sum=0;
      for(int kkk=0; kkk<Len; kkk++) Sum+=alfa[kkk]*MA[bar+kkk];
      if(Weight) IndBuffer[bar]=(1.0+Deviation/100)*Sum/Weight;
      if(Filter>0) if(MathAbs(IndBuffer[bar]-IndBuffer[bar+1])<dFilter) IndBuffer[bar]=IndBuffer[bar+1];
     }

//----    limit
   if(prev_calculated>rates_total || prev_calculated<=0) limit--;

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ColorIndBuffer[bar]=0;
      Trend[Count[0]]=Trend[Count[1]];
      if(IndBuffer[bar]-IndBuffer[bar+1]>dFilter) Trend[Count[0]]=+1;
      if(IndBuffer[bar+1]-IndBuffer[bar]>dFilter) Trend[Count[0]]=-1;
      if(Trend[Count[0]]>0)
        {
         ColorIndBuffer[bar]=1;
         if(Trend[Count[ColorBarBack]]<0) ColorIndBuffer[bar+ColorBarBack]=1;
        }
      if(Trend[Count[0]]<0)
        {
         ColorIndBuffer[bar]=2;
         if(Trend[Count[ColorBarBack]]>0) ColorIndBuffer[bar+ColorBarBack]=2;
        }
      if(bar) Recount_ArrayZeroPos(Count,size);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
