//+------------------------------------------------------------------+
//|                                                      WPRfast.mq5 | 
//|                                         Copyright  2007, OlegVS | 
//|                                                                  | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2007, OlegVS"
#property link ""
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//---     
#property indicator_separate_window
//---       
#property indicator_height 20
//---        
#property indicator_maximum +1.9
#property indicator_minimum +0.3
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_ARROW
//----    
#property indicator_color1  clrDodgerBlue,clrMagenta
//----    4
#property indicator_width1  4
//----   
#property indicator_label1  "WPRfast"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 1.0
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0    //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint iPeriod=9; //  
input uint Max=49;    //    
input uint Min=9;     //    
input int Shift=0;    //      
//+----------------------------------------------+

//----   ,    
//      
double IndBuffer[];
double ColorIndBuffer[];
//---      
int Ind_Handle;
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----     
   min_rates_total=int(iPeriod);

//---    WPR
   Ind_Handle=iWPR(Symbol(),PERIOD_CURRENT,iPeriod);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      WPR");
      return(INIT_FAILED);
     }

//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(IndBuffer,true);

//----     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorIndBuffer,true);

//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);

//----           
   IndicatorSetString(INDICATOR_SHORTNAME,"WPRfast");

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total || BarsCalculated(Ind_Handle)<rates_total) return(rates_total);

//----    
   int to_copy,limit,bar;
   double V1,V2,WPR[];

//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
     }
   else limit=rates_total-prev_calculated; //      

   to_copy=limit+1;

//----    ,     
   ArraySetAsSeries(WPR,true);

//----      
   if(CopyBuffer(Ind_Handle,0,0,to_copy,WPR)<=0) return(RESET);

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      IndBuffer[bar]=0.0;
      ColorIndBuffer[bar]=0;
      V1=WPR[bar]*WPR[bar]/100;
      V2=MathCeil(V1);
      if(V2<Min)
        {
         IndBuffer[bar]=1.0;
         ColorIndBuffer[bar]=0;
        }
      if(V2>Max)
        {
         IndBuffer[bar]=1.0;
         ColorIndBuffer[bar]=1;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
