//+------------------------------------------------------------------+
//| Core/JsonCore.mqh                                                |
//+------------------------------------------------------------------+
#ifndef MQL5_JSON_CORE
#define MQL5_JSON_CORE

class JsonNode;
class JsonDocument;

enum ENUM_JSON_TYPE
{
   JSON_NULL, JSON_BOOL, JSON_INT, JSON_DOUBLE,
   JSON_STRING, JSON_ARRAY, JSON_OBJECT, JSON_INVALID
};

enum ENUM_JSON_PARSE_ENGINE
{
   ENGINE_AUTO,
   ENGINE_STANDARD,
   ENGINE_HIGH_SPEED
};

enum ENUM_JSONPATH_MODE
{
   MODE_SIMPLE,
   MODE_ADVANCED
};

struct JsonError
{
   int    line;
   int    column;
   string message;
   string context;

   void Clear()
   {
      line=0;
      column=0;
      message="";
      context="";
   }
   string ToString() const
   {
      if(message=="") return "No error";
      string near = (context != "") ? " near '" + context + "'" : "";
      string loc = (line > 0) ? StringFormat("Line %d, Col %d: ", line, column) : "";
      return loc + message + near;
   }
};

struct JsonParseOptions
{
   ENUM_JSON_PARSE_ENGINE engine;
   bool                   allow_comments;
   bool                   allow_trailing_commas;
   uint                   max_depth;
   bool                   strict_unicode;


   JsonParseOptions()
   {
      engine = ENGINE_AUTO;
      allow_comments = false;
      allow_trailing_commas = false;
      max_depth = 128;
      strict_unicode = false;
   }
};

interface IJsonObjectVisitor
{
   void Visit(const string &key, const JsonNode &value);
};

interface IJsonArrayVisitor
{
   void Visit(int index, const JsonNode &item);
};

interface IJsonStreamHandler
{
   bool OnStartDocument();
   bool OnEndDocument();
   bool OnStartObject();
   bool OnEndObject();
   bool OnStartArray();
   bool OnEndArray();
   bool OnKey(const string &key);
   bool OnString(const string &value);
   bool OnNumber(const string &value, ENUM_JSON_TYPE type_hint);
   bool OnBool(bool value);
   bool OnNull();
};

interface IJsonSerializable
{
   void FromJson(const JsonNode &node);
   JsonNode ToJson(JsonDocument &owner_doc) const;
};

// Forward declarations for internal classes
class CJsonValue;
class CJsonDocument;
class CJsonArena;
class CJsonHashMap;

interface ICharacterStreamReader
{
   bool   IsEOF() const;
   int    Line() const;
   int    Column() const;
   ushort Peek();
   ushort Next();
   bool   Prev();
   string GetContext(int length) const;
   bool   IsValid() const;
};

struct JsonToken
{
   ENUM_JSON_TYPE type;
   int            start;
   int            length;
   int            child_count;
   int            parent_index;
};

#endif //MQL5_JSON_CORE
//+------------------------------------------------------------------+
