//+------------------------------------------------------------------+
//|                                           IncIchimokuOnArray.mqh |
//|                          https://login.mql5.com/ru/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int PeriodTenkan  =  9;
   input int PeriodKijun   =  26;
   input int PeriodSenkou  =  52;

   Declaration:
   #include <IncOnArray/IncIchimokuOnArray.mqh>
   CIchimokuOnArray ich;

   In OnInit:  
   ich.Init(PeriodTenkan,PeriodKijun,PeriodSenkou,true/false);

   In OnCalculate:
   ich.Solve(rates_total,prev_calculated,DataHigh,DataLow,TBuffer,KBuffer,SABuffer,SBBuffer);

*/
//+------------------------------------------------------------------+
//| CIchimokuOnArray                                                 |
//+------------------------------------------------------------------+
class CIchimokuOnArray
  {
protected:
   int               m_PeriodTenkan;
   int               m_PeriodKijun;
   int               m_PeriodSenkou;
   int               m_br;
   int               m_br2;
   string            m_Name;
   int               m_absh;
public:
   void Init(int aPeriodTenkan=9,int aPeriodKijun=26,int aPeriodSenkou=52,bool aABShift=false)
     {
      m_PeriodTenkan=aPeriodTenkan;
      m_PeriodKijun=aPeriodKijun;
      m_PeriodSenkou=aPeriodSenkou;
      m_Name="Ichimoku("+IntegerToString(m_PeriodTenkan)+","+IntegerToString(m_PeriodKijun)+","+IntegerToString(m_PeriodSenkou)+")";
      m_absh=0;
      if(aABShift)
        {
         m_absh=aPeriodKijun;
        }
      m_br=MathMax(m_PeriodTenkan,m_PeriodKijun);
      m_br2=MathMax(MathMax(m_PeriodTenkan,m_PeriodKijun),m_PeriodSenkou)+m_absh;
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aDataHigh[],
              double  &aDataLow[],
              double  &aTenkan[],
              double  &aKijun[],
              double  &aSpanA[],
              double  &aSpanB[])
     {
      int Start=0;
      int Start2=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aDataHigh[i]!=0 && aDataHigh[i]!=EMPTY_VALUE)
              {
               if(aDataLow[i]!=0 && aDataLow[i]!=EMPTY_VALUE)
                 {
                  Start=i+m_br-1;
                  Start2=i+m_br2-1;
                  break;
                 }
              }
           }
        }
      else
        {
         Start=aPrevCalc-1;
         Start2=Start;
        }

      for(int i=Start;i<aRatesTotal;i++)
        {
         aTenkan[i]=(aDataHigh[ArrayMaximum(aDataHigh,i-m_PeriodTenkan+1,m_PeriodTenkan)]+aDataLow[ArrayMinimum(aDataLow,i-m_PeriodTenkan+1,m_PeriodTenkan)])/2;
         aKijun[i]=(aDataHigh[ArrayMaximum(aDataHigh,i-m_PeriodKijun+1,m_PeriodKijun)]+aDataLow[ArrayMinimum(aDataLow,i-m_PeriodKijun+1,m_PeriodKijun)])/2;
        }
      for(int i=Start2;i<aRatesTotal;i++)
        {
         aSpanA[i]=(aTenkan[i-m_absh]+aKijun[i-m_absh])/2;
         aSpanB[i]=(aDataHigh[ArrayMaximum(aDataHigh,i-m_PeriodSenkou+1-m_absh,m_PeriodSenkou)]+aDataLow[ArrayMinimum(aDataLow,i-m_PeriodSenkou+1-m_absh,m_PeriodSenkou)])/2;
        }
     }
   int SpanABShift()
     {
      return(m_PeriodKijun);
     }
   int BarsRequiredTK()
     {
      return(m_br);
     }
   int BarsRequiredAB()
     {
      return(m_br2);
     }
   string Name()
     {
      return(m_Name);
     }
   string NameT()
     {
      return(m_Name+" Tenkan");
     }
   string NameK()
     {
      return(m_Name+" Kijun");
     }
   string NameSA()
     {
      return(m_Name+" SenkouSpanA");
     }
   string NameSB()
     {
      return(m_Name+" SenkouSpanB");
     }

   string About()
     {
      return("Integer's IchimokuOnArray class. https://login.mql5.com/ru/users/Integer");
     }

  };
//+------------------------------------------------------------------+
