//+------------------------------------------------------------------+
//|                                              Test_CHOOnArray.mq5 |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 8
#property indicator_plots   1
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- plot Label2
#property indicator_label2  "Label2"
#property indicator_type2   DRAW_LINE
#property indicator_color2  clrRed
#property indicator_style2  STYLE_SOLID
#property indicator_width2  1
//--- plot Label3
#property indicator_label3  "Label3"
#property indicator_type3   DRAW_LINE
#property indicator_color3  clrRed
#property indicator_style3  STYLE_SOLID
#property indicator_width3  1
//--- plot Label4
#property indicator_label4  "Label4"
#property indicator_type4   DRAW_LINE
#property indicator_color4  clrRed
#property indicator_style4  STYLE_SOLID
#property indicator_width4  1
//--- plot Label5
#property indicator_label5  "Label5"
#property indicator_type5   DRAW_LINE
#property indicator_color5  clrRed
#property indicator_style5  STYLE_SOLID
#property indicator_width5  1
//--- plot Label6
#property indicator_label6  "Label6"
#property indicator_type6   DRAW_LINE
#property indicator_color6  clrRed
#property indicator_style6  STYLE_SOLID
#property indicator_width6  1
//--- plot Label7
#property indicator_label7  "Label7"
#property indicator_type7   DRAW_LINE
#property indicator_color7  clrRed
#property indicator_style7  STYLE_SOLID
#property indicator_width7  1
//--- plot Label8
#property indicator_label8  "Label8"
#property indicator_type8   DRAW_LINE
#property indicator_color8  clrRed
#property indicator_style8  STYLE_SOLID
#property indicator_width8  1
//--- input parameters
input int            CHOFastPeriod  =  3;
input int            CHOSlowPeriod  =  10;
input ENUM_MA_METHOD CHOMethod      =  MODE_EMA;
//--- indicator buffers
double  DataHigh[];
double  DataLow[];
double  DataClose[];
double  DataVolume[];
double  TmpAD[];
double  FastAD[];
double  SlowAD[];
double  CHO[];

#include <IncOnArray/IncCHOOnArray.mqh>
CCHOOnArray cho;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   cho.Init(CHOFastPeriod,CHOSlowPeriod,CHOMethod);

//--- indicator buffers mapping
   SetIndexBuffer(0,CHO,INDICATOR_DATA);
   SetIndexBuffer(1,DataHigh,INDICATOR_CALCULATIONS);
   SetIndexBuffer(2,DataLow,INDICATOR_CALCULATIONS);
   SetIndexBuffer(3,DataClose,INDICATOR_CALCULATIONS);
   SetIndexBuffer(4,DataVolume,INDICATOR_CALCULATIONS);
   SetIndexBuffer(5,TmpAD,INDICATOR_CALCULATIONS);
   SetIndexBuffer(6,FastAD,INDICATOR_CALCULATIONS);
   SetIndexBuffer(7,SlowAD,INDICATOR_CALCULATIONS);
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      DataClose[i]=close[i];
      DataHigh[i]=high[i];
      DataLow[i]=low[i];
      DataVolume[i]=(double)tick_volume[i];
     }

   cho.Solve(rates_total,prev_calculated,DataHigh,DataLow,DataClose,DataVolume,TmpAD,FastAD,SlowAD,CHO);

   return(rates_total);
  }
//+------------------------------------------------------------------+
