//+------------------------------------------------------------------+
//|                                                IncCHOOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int            CHOFastPeriod  =  3;
   input int            CHOSlowPeriod  =  10;
   input ENUM_MA_METHOD CHOMethod      =  MODE_EMA;

   Declaration:
   #include <IncOnArray/IncCHOOnArray.mqh>
   CCHOOnArray cho;

   In OnInit:  
   cho.Init(CHOFastPeriod,CHOSlowPeriod,CHOMethod);

   In OnCalculate:
   cho.Solve(rates_total,prev_calculated,DataHigh,DataLow,DataClose,DataVolume,TmpAD,FastAD,SlowAD,CHO);
*/
#include <IncOnArray/IncMAOnArray.mqh>
//+------------------------------------------------------------------+
//| CCHOOnArray                                                      |
//+------------------------------------------------------------------+
class CCHOOnArray
  {
protected:
   int               m_FastPeriod;
   int               m_SlowPeriod;
   ENUM_MA_METHOD    m_Method;
   int               m_br;
   string            m_Name;
   CMAOnArray        m_fm;
   CMAOnArray        m_sm;
public:
   void Init(int aFastPeriod=3,int aSlowPeriod=12,ENUM_MA_METHOD aMethod=MODE_EMA)
     {
      m_FastPeriod=aFastPeriod;
      m_SlowPeriod=aSlowPeriod;
      m_Method=aMethod;
      m_fm.Init(m_FastPeriod,m_Method);
      m_sm.Init(m_SlowPeriod,m_Method);
      m_br=MathMax(m_fm.BarsRequired(),m_sm.BarsRequired())+1;
      m_Name="CHO("+IntegerToString(m_FastPeriod)+","+IntegerToString(m_SlowPeriod)+","+m_fm.NameMethod()+")";
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aDataHigh[],
              double  &aDataLow[],
              double  &aDataClose[],
              double  &aDataVolume[],
              double  &aTmpAD[],
              double  &aFastAD[],
              double  &aSlowAD[],
              double  &aCHO[])
     {

      int Start=0;
      int Start2=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aDataHigh[i]!=0 && aDataHigh[i]!=EMPTY_VALUE)
              {
               if(aDataLow[i]!=0 && aDataLow[i]!=EMPTY_VALUE)
                 {
                  if(aDataClose[i]!=0 && aDataClose[i]!=EMPTY_VALUE)
                    {
                     if(aDataVolume[i]!=0 && aDataVolume[i]!=EMPTY_VALUE)
                       {
                        Start=i;
                        break;
                       }
                    }
                 }
              }
           }
         double sum=0;
         int i=Start;
         if(aDataHigh[i]!=aDataLow[i])
           {
            sum=(aDataClose[i]-aDataLow[i])-(aDataHigh[i]-aDataClose[i]);
            sum=(sum/(aDataHigh[i]-aDataLow[i]))*aDataVolume[i];
           }
         aTmpAD[i]=0;
         Start++;
         Start2=Start+m_br;
        }
      else
        {
         Start=aPrevCalc-1;
         Start2=Start;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         double sum=0;
         if(aDataHigh[i]!=aDataLow[i])
           {
            sum=(aDataClose[i]-aDataLow[i])-(aDataHigh[i]-aDataClose[i]);
            sum=(sum/(aDataHigh[i]-aDataLow[i]))*aDataVolume[i];
           }
         aTmpAD[i]=aTmpAD[i-1]+sum;
        }
      m_fm.Solve(aRatesTotal,aPrevCalc,aTmpAD,aFastAD);
      m_sm.Solve(aRatesTotal,aPrevCalc,aTmpAD,aSlowAD);
      for(int i=Start2;i<aRatesTotal;i++)
        {
         aCHO[i]=aFastAD[i]-aSlowAD[i];
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's CHOOnArray class. https://login.mql5.com/en/users/Integer");
     }
  };
//+------------------------------------------------------------------+
