//+------------------------------------------------------------------+
//|                                              Test_SAROnArray.mq5 |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 3
#property indicator_plots   1
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_ARROW
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- input parameters
input double SARStep=0.02;
input double SARMax=0.2;
//--- indicator buffers
double         SARBuffer[];
double         DataHigh[];
double         DataLow[];
#include <IncOnArray/IncSAROnArray.mqh>
CSAROnArray sar;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   sar.Init(SARStep,SARMax);

//--- indicator buffers mapping
   SetIndexBuffer(0,SARBuffer,INDICATOR_DATA);
//--- setting a code from the Wingdings charset as the property of PLOT_ARROW
   PlotIndexSetInteger(0,PLOT_ARROW,159);

   SetIndexBuffer(1,DataHigh,INDICATOR_CALCULATIONS);
   SetIndexBuffer(2,DataLow,INDICATOR_CALCULATIONS);

   PlotIndexSetString(0,PLOT_LABEL,sar.Name());
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      DataHigh[i]=high[i];
      DataLow[i]=low[i];
     }

   sar.Solve(rates_total,prev_calculated,DataHigh,DataLow,SARBuffer);

   return(rates_total);
  }
//+------------------------------------------------------------------+
