﻿#include <Forester\TickCompressor.mqh> 

//#define compressTo3Bytes

// метод сжатия
int method=1;//1...6 BidAsk_=1, BidAskVolume_=2, All_=3, BidAsk_Zipped=4, BidAskVolume_Zipped=5, All_Zipped=6
int ticks_per_block=200000;

input datetime inFrom = D'2025.01.01';


void Strategy( const MqlTick& ) {}

// Возвращает размер массива в байтах.
template <typename T>
ulong GetSize( const T &Array[] ) { return((ulong)sizeof(T) * ArraySize(Array)); }

template <typename T1, typename T2>
double Criterion( const T1 &Decompression[], const T2 &Compression[], const ulong Interval )
{
  const double Performance = (double)ArraySize(Decompression) / Interval;

  return(Performance * ((double)GetSize(Decompression) / GetSize(Compression)));
}

#define TICK_SHORT uchar

void OnStart()
{
  MqlTick Ticks[]; // Для исходных тиков.

  if (CopyTicksRange(_Symbol, Ticks, COPY_TICKS_ALL,(ulong)inFrom * 1000) > 0)
  {
    TICK_SHORT Ticks2[], tmp[]; // Для сжатых тиков.
    TickCompressor Compressor2;
    int Amount = ArraySize(Ticks);

    double VolumeStep_=SymbolInfoDouble(Symbol(), SYMBOL_VOLUME_STEP);
    Compressor2.Start(method,_Point,VolumeStep_,_Digits);
    Print("Ticks: ",ArraySize(Ticks));
    ulong Interval = GetMicrosecondCount();

    int ZIPpos=0;//счетчик сжатых байтов
    if(Amount>ticks_per_block){// > 1 блока - склейка блоков из tmp в Ticks2
       for(int start=0; start<Amount; start+=ticks_per_block){
          Compressor2.Compress(Ticks, tmp, start, (Amount > start + ticks_per_block ? ticks_per_block : Amount - start)); 
          ZIPpos+=ArrayCopy(Ticks2,tmp,ZIPpos); //скопировать в конец Ticks2
       }
    }else{//1 блок - распаковка сразу в Ticks2
       Compressor2.Compress(Ticks, Ticks2, 0, Amount); 
    }

    //или
    //Compressor2.Compress(Ticks,Ticks2); // сжать в 1 блок

    Print("Compressed size: ",ArraySize(Ticks2));
    
    Interval = GetMicrosecondCount() - Interval;
    const double Performance = (double)ArraySize(Ticks) / Interval;

    // https://www.mql5.com/ru/forum/490384#comment_57497700
    long n1 = ArraySize(Ticks) * (long)sizeof(MqlTick);
    long n2 = ArraySize(Ticks2) * (long)sizeof(TICK_SHORT);
    PrintFormat("Compressed %I64i bytes into %I64i bytes ==> %.2f%%",n1,n2,(double)n2/n1*100);

    Print("Compress performance: " + DoubleToString(Performance * sizeof(MqlTick) / 1.04858, 0) + " MB/s");
    Print("Compress performance: " + DoubleToString(Performance, 1) + " Ticks (millions)/sec.");
    Print("Compress performance criterion: " + DoubleToString(Criterion(Ticks, Ticks2, Interval), 1));

    MqlTick Ticks3[]; // Для разжатых тиков.
    TickCompressor Compressor3;
    Compressor3.Start(method,_Point,VolumeStep_,_Digits);
    ulong Interval2 = GetMicrosecondCount();
//    TICKS_SHORT::Decompress(Ticks2, Ticks3); // Разжали.

    ArrayResize(Ticks3,Amount); //изменить размер массива для чтения поблочно
    int total_ticks=0;
    int nextSize=0;//размер следущего блока
    ZIPpos=0;// адрес
    while (ZIPpos<ArraySize(Ticks2)){
       nextSize=Compressor3.ArrToInt(Ticks2,ZIPpos);//размер следущего блока, увеличит ZIPpos на 4

       uint s = ArrayCopy(tmp,Ticks2,0,ZIPpos,nextSize); //скопировать новый блок в tmp размером nextSize
       //медленнее в 3 раза ArrayResize(Ticks3,total_ticks+ticks_per_block,10000000); //изменить размер большого массива - работает медленнее, чем перезапись малого блока
       //total_ticks=Compressor3.DeCompress(tmp,Ticks3,nextSize,total_ticks);//распаковать блок и дописать в Ticks3
       
       total_ticks+=Compressor3.DeCompress(tmp,Ticks3,nextSize,0); //распаковать блок и перезаписать в Ticks3
       ZIPpos+=nextSize;
       //for (int j = 0; j < ticks; j++){ Strategy(Ticks3[j]);}//стратегия
    };

    Interval2 = GetMicrosecondCount() - Interval2;
    Print("Decompressed ticks: ",total_ticks);
    ArrayResize(Ticks3,total_ticks);
    const double Performance2 = (double)ArraySize(Ticks3) / Interval2;

    Print("Decompress performance: " + DoubleToString(Performance2 * sizeof(MqlTick) / 1.04858, 0) + " MB/s");
    Print("Decompress performance: " + DoubleToString(Performance2, 1) + " Ticks (millions)/sec.");
    Print("Decompress performance criterion: " + DoubleToString(Criterion(Ticks3, Ticks2, Interval2), 1));
    
    
    //сравнить тики отдельнo, чтобы не ухудшать оценку сборкой большого массива для сравнения
    ArrayResize(Ticks3,Amount);
    Compressor3.Start(method,_Point,VolumeStep_,_Digits);
    nextSize=0;//размер следущего блока
    ZIPpos=0;// адрес
    total_ticks=0;
    while (ZIPpos<ArraySize(Ticks2)){
       nextSize=Compressor3.ArrToInt(Ticks2,ZIPpos);//размер следущего блока, увеличит ZIPpos на 4

       uint s = ArrayCopy(tmp,Ticks2,0,ZIPpos,nextSize); //скопировать новый блок в tmp размером nextSize
       //медленнее  ArrayResize(Ticks3,total_ticks+ticks_per_block,10000000); //изменить размер большого массива - работает медленнее, чем перезапись малого блока
       total_ticks=Compressor3.DeCompress(tmp,Ticks3,nextSize,total_ticks);//распаковать блок и дописать в Ticks3
       
       //total_ticks+=Compressor3.DeCompress(tmp,Ticks3,nextSize,0); //распаковать блок и перезаписать в Ticks3
       ZIPpos+=nextSize;
       //for (int j = 0; j < ticks; j++){ Strategy(Ticks3[j]);}//стратегия
    };
    
    // или
    //total_ticks=Compressor3.DeCompress(Ticks2,Ticks3); //разжать из 1 блока

    Print("Correct = " + (string)IsEqual(Ticks, Ticks3)); // Сравнили.
  }
  
}

bool IsEqual( const MqlTick &Ticks1[], const MqlTick &Ticks2[] )
  {
    const int Size = ::ArraySize(Ticks1);

    bool Res = (::ArraySize(Ticks2) == Size);
    if(!Res){Print("ArraySize: ",ArraySize(Ticks2)," != ",Size);}
    Res=1;
    for (int i = 0; Res && (i < Size); i++){
      Res = IsEqual(Ticks1[i], Ticks2[i]);
      if(!Res){Print(Ticks1[i].time," ",Ticks2[i].time," ",Ticks1[i].ask," ",Ticks2[i].ask," ",Ticks1[i].bid," ",Ticks2[i].bid);}
    }

    return(Res);
  }
  
bool IsEqual( const MqlTick &Tick1, const MqlTick &Tick2 )
  {
    return((Tick1.bid == Tick2.bid) && (Tick1.ask == Tick2.ask) && (Tick1.time_msc == Tick2.time_msc) && (Tick1.volume_real == Tick2.volume_real));
  }