//+------------------------------------------------------------------+
//|                                               IncTemaOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/ru/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int            TemaPeriod  =  14;
   input ENUM_MA_METHOD TemaMethod  =  MODE_EMA;

   Declaration:
   #include <IncOnArray/IncTemaOnArray.mqh>
   CTemaOnArray tema;

   In OnInit:
   tema.Init(TemaPeriod,TemaMethod);

   In OnCalculate:
   tema.Solve(rates_total,prev_calculated,data,M1Buffer,M2Buffer,M3Buffer,TBuffer);
*/

#include <IncOnArray/IncMAOnArray.mqh>
//+------------------------------------------------------------------+
//| CTemaOnArray                                                     |
//+------------------------------------------------------------------+
class CTemaOnArray
  {
private:
   int               m_MAPeriod;
   ENUM_MA_METHOD    m_MAMethod;
   string            m_Name;
   int               m_br;
   CMAOnArray        m_ma1;
   CMAOnArray        m_ma2;
   CMAOnArray        m_ma3;
public:
   void Init(int aMAPeriod=12,ENUM_MA_METHOD aMAMethod=MODE_EMA)
     {
      m_MAPeriod=aMAPeriod;
      m_MAMethod=aMAMethod;
      m_ma3.Init(m_MAPeriod,m_MAMethod);
      m_ma2.Init(m_MAPeriod,m_MAMethod);
      m_ma1.Init(m_MAPeriod,m_MAMethod);
      m_br=m_ma1.BarsRequired()+m_ma2.BarsRequired()+m_ma3.BarsRequired();
      m_Name="TEMA("+IntegerToString(m_MAPeriod)+","+m_ma1.NameMethod()+")";
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aData[],
              double  &aMA1[],
              double  &aMA2[],
              double  &aMA3[],
              double  &aTEMA[]
              )
     {
      m_ma1.Solve(aRatesTotal,aPrevCalc,aData,aMA1);
      m_ma2.Solve(aRatesTotal,aPrevCalc,aMA1,aMA2);
      m_ma3.Solve(aRatesTotal,aPrevCalc,aMA2,aMA3);
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aData[i]!=0 && aData[i]!=EMPTY_VALUE)
              {
               Start=i+m_ma3.BarsRequired();
               break;
              }
           }
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         aTEMA[i]=3.0*aMA1[i]-3.0*aMA2[i]+aMA3[i];
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's TEMAOnArray class. https://login.mql5.com/ru/users/Integer");
     }
  };
//+------------------------------------------------------------------+
