//+------------------------------------------------------------------+
//|                                                IncRVIOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int            RVIPeriod   =  10;
   input ENUM_MA_METHOD RVIMethod   =  MODE_SMA;

   Declaration:
   #include <IncOnArray/IncRVIOnArray.mqh>
   CRVIOnArray rvi;

   In OnInit:
   rvi.Init(RVIPeriod,RVIMethod);

   In OnCalculate:
   rvi.Solve(rates_total,prev_calculated,DataOpen,DataHigh,DataLow,DataClose,MBuffer,MSBuffer,RBuffer,RSBuffer,RVIMBuffer,RVISBuffer);
*/

#include <IncOnArray/IncMAOnArray.mqh>
//+------------------------------------------------------------------+
//| CRVIOnArray                                                      |
//+------------------------------------------------------------------+
class CRVIOnArray
  {
private:
   int               m_Period;
   ENUM_MA_METHOD    m_Method;
   string            m_Name;
   int               m_rbm;
   int               m_rbs;
   CMAOnArray        m_mma;
   CMAOnArray        m_rma;
public:
   void Init(int aPeriod=10,ENUM_MA_METHOD aMethod=MODE_SMA)
     {
      m_Period=aPeriod;
      m_Method=aMethod;
      m_Name="RVI("+IntegerToString(m_Period)+")";
      m_mma.Init(m_Period,m_Method);
      m_rma.Init(m_Period,m_Method);
      m_rbs=3+m_rma.BarsRequired()-1+3;
      m_rbm=3+m_rma.BarsRequired()-1;
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aDataOpen[],
              double  &aDataHigh[],
              double  &aDataLow[],
              double  &aDataClose[],
              double  &aM[],
              double  &aMS[],
              double  &aR[],
              double  &aRS[],
              double  &aMain[],
              double  &aSignal[]
              )
     {
      int Start=0;
      int Start1=0;
      int Start2=0;
      int Start3=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aDataOpen[i]!=0 && aDataOpen[i]!=EMPTY_VALUE && aDataClose[i]!=0 && aDataClose[i]!=EMPTY_VALUE && aDataHigh[i]!=0 && aDataHigh[i]!=EMPTY_VALUE && aDataLow[i]!=0 && aDataLow[i]!=EMPTY_VALUE)
              {
               Start=i;
               break;
              }
           }
         Start1=Start+3;
         Start2=Start+3+m_rma.BarsRequired()-1;
         Start3=Start+3+m_rma.BarsRequired()-1+3;
        }
      else
        {
         Start1=aPrevCalc-1;
         Start2=Start1;
         Start3=Start1;
        }
      for(int i=Start1;i<aRatesTotal;i++)
        {
         aM[i]=aDataClose[i]-aDataOpen[i]+2*(aDataClose[i-1]-aDataOpen[i-1])+2*(aDataClose[i-2]-aDataOpen[i-2])+aDataClose[i-3]-aDataOpen[i-3];
         aR[i]=aDataHigh[i]-aDataLow[i]+2*(aDataHigh[i-1]-aDataLow[i-1])+2*(aDataHigh[i-2]-aDataLow[i-2])+aDataHigh[i-3]-aDataLow[i-3];
        }
      m_mma.Solve(aRatesTotal,aPrevCalc,aM,aMS);
      m_rma.Solve(aRatesTotal,aPrevCalc,aR,aRS);
      for(int i=Start2;i<aRatesTotal;i++)
        {
         if(aRS[i]!=0)
           {
            aMain[i]=aMS[i]/aRS[i];
           }
         else
           {
            aMain[i]=aMS[i];
           }
        }
      for(int i=Start3;i<aRatesTotal;i++)
        {
         aSignal[i]=(aMain[i]+2*aMain[i-1]+2*aMain[i-2]+aMain[i-3])/6;
        }
     }
   int BarsRequiredMain()
     {
      return(m_rbm);
     }
   int BarsRequiredSignal()
     {
      return(m_rbs);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's RVIOnArray class. https://login.mql5.com/en/users/Integer");
     }
  };
//+------------------------------------------------------------------+
