//+------------------------------------------------------------------+
//|                                           IncDeMarkerOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int               DemPeriod   =  14;
   input ENUM_MA_METHOD    DemMethod   =  MODE_SMA;

   Declaration:
   #include <IncOnArray/IncDemarkerOnArray.mqh>
   CDeMarkerOnArray dem;

   In OnInit:
   dem.Init(DemPeriod,DemMethod);

   In OnCalculate:
   dem.Solve(rates_total,prev_calculated,DataHigh,DataLow,PBuffer,MBuffer,PSBuffer,MSBuffer,DemBuffer);
*/
#include <IncOnArray/IncMAOnArray.mqh>
//+------------------------------------------------------------------+
//| CDeMarkerOnArray                                                 |
//+------------------------------------------------------------------+
class CDeMarkerOnArray
  {
private:
   int               m_Period;
   ENUM_MA_METHOD    m_Method;
   string            m_Name;
   double            m_d;
   CMAOnArray        m_pma;
   CMAOnArray        m_mma;
   int               m_br;
public:
   void Init(int aPeriod=14,ENUM_MA_METHOD aMethod=MODE_SMMA)
     {
      m_Period=aPeriod;
      m_Method=aMethod;
      m_pma.Init(m_Period,m_Method);
      m_mma.Init(m_Period,m_Method);
      m_Name="DeMarker("+IntegerToString(m_Period)+","+m_mma.NameMethod()+")";
      m_br=m_pma.BarsRequired()+1;
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aDataHigh[],
              double  &aDataLow[],
              double  &aP[],
              double  &aM[],
              double  &aPS[],
              double  &aMS[],
              double  &aDeMarker[]
              )
     {
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aDataHigh[i]!=0 && aDataHigh[i]!=EMPTY_VALUE && aDataLow[i]!=0 && aDataLow[i]!=EMPTY_VALUE)
              {
               Start=i+1;
               break;
              }
           }
         if(aDataHigh[Start]>aDataHigh[Start-1])
           {
            aP[Start]=aDataHigh[Start]-aDataHigh[Start-1];
           }
         else
           {
            aP[Start]=0.00000001;
           }

         if(aDataLow[Start-1]>aDataLow[Start])
           {
            aM[Start]=aDataLow[Start-1]-aDataLow[Start];
           }
         else
           {
            aM[Start]=0.00000001;
           }
         Start++;
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         if(aDataHigh[i]>aDataHigh[i-1])
           {
            aP[i]=aDataHigh[i]-aDataHigh[i-1];
           }
         else
           {
            aP[i]=0.0;
           }
         if(aDataLow[i-1]>aDataLow[i])
           {
            aM[i]=aDataLow[i-1]-aDataLow[i];
           }
         else
           {
            aM[i]=0.0;
           }
        }
      m_pma.Solve(aRatesTotal,aPrevCalc,aP,aPS);
      m_mma.Solve(aRatesTotal,aPrevCalc,aM,aMS);
      for(int i=Start;i<aRatesTotal;i++)
        {
         m_d=aPS[i]+aMS[i];
         if(m_d!=0)
           {
            aDeMarker[i]=aPS[i]/m_d;
           }
         else
           {
            aDeMarker[i]=0.0;
           }
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's DeMArkerOnArray class. https://login.mql5.com/en/users/Integer");
     }
  };
//+------------------------------------------------------------------+
