//+------------------------------------------------------------------+
//|                                                IncCMOOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"

/*
   External parameters:
   input int      CMOPeriod=9;

   Declaration:
   #include <IncOnArray/IncCMOOnArray.mqh>
   CCMOOnArray cmo;

   In OnInit:
   cmo.Init(CMOPeriod);

   In OnCalculate:
   cmo.Solve(rates_total,prev_calculated,data,CMOBuffer);

*/
//+------------------------------------------------------------------+
//| CCMOOnArray                                                      |
//+------------------------------------------------------------------+
class CCMOOnArray
  {
private:
   int               m_Period;
   string            m_Name;
   int               m_br;
public:
   void Init(int aPeriod=9)
     {
      m_Period=aPeriod;
      m_Name="CMO("+IntegerToString(m_Period)+")";
      m_br=m_Period+1;
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aData[],
              double  &aCMO[])
     {
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aData[i]!=0 && aData[i]!=EMPTY_VALUE)
              {
               Start=i+m_Period;
               break;
              }
           }
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         double UpSum=0.0,DownSum=0.0;
         for(int j=0;j<m_Period;j++)
           {
            double diff=aData[i-j]-aData[i-j-1];
            if(diff>0.0)
              {
               UpSum+=diff;
              }
            else
              {
               DownSum+=(-diff);
              }
           }
         if(UpSum+DownSum!=0.0)
           {
            aCMO[i]=(UpSum-DownSum)/(UpSum+DownSum);
           }
         else
           {
            aCMO[i]=aCMO[i-1];
           }
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's CMOOnArray class. https://login.mql5.com/en/users/Integer");
     }
  };
//+------------------------------------------------------------------+
