//+------------------------------------------------------------------+
//|                                                IncVHFOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int  VHFPeriod =  34;

   Declaration:
   #include <IncOnArray/IncVHFOnArray.mqh>
   CVHFOnArray vhf;

   In OnInit: 
   vhf.Init(VHFPeriod);

   In OnCalculate:
   vhf.Solve(rates_total,prev_calculated,DataHigh,DataLow,DataClose,VHFBuffer);
*/
//+------------------------------------------------------------------+
//| CVHFOnArray                                                      |
//+------------------------------------------------------------------+
class CVHFOnArray
  {
private:
   int               m_Period;
   string            m_Name;
   int               m_br;
public:
   void Init(int aPeriod=34)
     {
      m_Period=aPeriod;
      m_Name="VHF("+IntegerToString(m_Period)+")";
      m_br=m_Period;
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aDataHigh[],
              double  &aDataLow[],
              double  &aDataClose[],
              double  &aVHF[])
     {
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aDataClose[i]!=0 && aDataClose[i]!=EMPTY_VALUE && aDataHigh[i]!=0 && aDataHigh[i]!=EMPTY_VALUE && aDataLow[i]!=0 && aDataLow[i]!=EMPTY_VALUE)
              {
               Start=i+m_Period;
               break;
              }
           }
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         double m_a=aDataHigh[ArrayMaximum(aDataHigh,i-m_Period+1,m_Period)]-aDataLow[ArrayMinimum(aDataLow,i-m_Period+1,m_Period)];
         double m_b=0;
         for(int j=i;j>i-m_Period;j--)
           {
            m_b+=MathAbs(aDataClose[j]-aDataClose[j-1]);
           }
         if(m_b!=0)
           {
            aVHF[i]=m_a/m_b;
           }
         else
           {
            aVHF[i]=aVHF[i-1];
           }

        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's VHFOnArray class. https://login.mql5.com/en/users/Integer");
     }
  };
//+------------------------------------------------------------------+
