//+------------------------------------------------------------------+
//|                                                CTsLoggerTest.mq5 |
//|                                         Copyright 2025, Trefoter |
//|                             https://www.mql5.com/ru/users/useral |
//+------------------------------------------------------------------+

#property copyright "Copyright 2025, Trefoter"
#property link      "https://www.mql5.com/ru/users/useral"
#property version   "1.00"
#property description "CTsLogger - a simple and flexible logging system,"
#property description "specifically designed for creating and debugging trading systems in MQL5."
#property description ""
#property description "The main advantage of CTsLogger is the ability to temporarily enable"
#property description "debug mode for specific modules or code sections while maintaining"
#property description "a lower global logging level."
#property description ""
#property description "This allows you to get detailed logging of specific code areas without"
#property description "\"drowning\" in a flood of messages,"
#property description "and then disable it with a single command."

#property script_show_inputs

// Include the logger
#include "CTsLogger.mqh"

// Input parameters
input string   InpLogFileName = "my_log.log"; // Log file name
input bool     InpLogToTerminal = true;       // Terminal output

// Create global logger variable
CTsLogger *Logger = NULL;

//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
{
   // Create logger instance
   Logger = new CTsLogger();
   
   // Check for successful creation
   if(Logger == NULL)
   {
      Print("Error creating logger!");
      return;
   }
   
   // Initialize logger
   Logger.Initialize(InpLogFileName, InpLogToTerminal);
   Logger.SetGlobalLogLevel(LOG_LEVEL_INFO);
   
   // Basic logging
   Logger.Info("LoggerScript", "Example of using CTsLogger");
   Logger.Warning("LoggerScript", "This warning will be displayed");
   Logger.Error("LoggerScript", "This error message will be displayed");
   Logger.Debug("LoggerScript", "This debug message will NOT be displayed (INFO level)");
   
   // Demonstration of hierarchical identifiers
   Logger.EnableDebugMode("Module");
   Logger.Debug("Module.Component", "This message will be displayed (debug mode enabled)");
   Logger.Debug("Module.OtherComponent", "This message will also be displayed");
   
   // Disabling debug mode for parent module also disables child modules
   Logger.DisableDebugMode("Module");
   Logger.Debug("Module.Component", "This message will NOT be displayed");
   
   // Demonstration of debug mode pause
   Logger.EnableDebugMode("Component1");
   Logger.EnableDebugMode("Component2");
   
   Logger.Debug("Component1", "This message will be displayed");
   Logger.Debug("Component2", "This message will be displayed");
   
   // Pause debug mode
   Logger.PauseDebugMode();
   Logger.Debug("Component1", "This message will NOT be displayed (debug mode paused)");
   
   // Resume debug mode
   Logger.ResumeDebugMode();
   Logger.Debug("Component1", "This message will be displayed again");
   
   // Switch global logging level
   Logger.SetGlobalLogLevel(LOG_LEVEL_DEBUG);
   Logger.Debug("LoggerScript", "Now this debug message will be displayed");
   
   // Complete reset of debug modules
   Logger.ResetDebugModules();
   
   // Completion
   Logger.Info("LoggerScript", "Script completed");
   
   // Free logger resources
   if(Logger != NULL)
   {
      delete Logger;
      Logger = NULL;
   }
}

