//+------------------------------------------------------------------+
//|                                                     MqlError.mqh |
//|                                  Copyright 2021, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| All error codes in MQL5                                          |
//| "ERR_" prefixes are stripped down to eliminate name collisions   |
//+------------------------------------------------------------------+
enum MQL_ERROR
{
   SUCCESS = 0,
   INTERNAL_ERROR = 4001,
   WRONG_INTERNAL_PARAMETER = 4002,
   INVALID_PARAMETER = 4003,
   NOT_ENOUGH_MEMORY = 4004,
   STRUCT_WITHOBJECTS_ORCLASS = 4005,
   INVALID_ARRAY = 4006,
   ARRAY_RESIZE_ERROR = 4007,
   STRING_RESIZE_ERROR = 4008,
   NOTINITIALIZED_STRING = 4009,
   INVALID_DATETIME = 4010,
   ARRAY_BAD_SIZE = 4011,
   INVALID_POINTER = 4012,
   INVALID_POINTER_TYPE = 4013,
   FUNCTION_NOT_ALLOWED = 4014,
   RESOURCE_NAME_DUPLICATED = 4015,
   RESOURCE_NOT_FOUND = 4016,
   RESOURCE_UNSUPPORTED_TYPE = 4017,
   RESOURCE_NAME_IS_TOO_LONG = 4018,
   MATH_OVERFLOW = 4019,
   SLEEP_ERROR = 4020,
   PROGRAM_STOPPED = 4022,
   // Charts
   CHART_WRONG_ID = 4101,
   CHART_NO_REPLY = 4102,
   CHART_NOT_FOUND = 4103,
   CHART_NO_EXPERT = 4104,
   CHART_CANNOT_OPEN = 4105,
   CHART_CANNOT_CHANGE = 4106,
   CHART_WRONG_PARAMETER = 4107,
   CHART_CANNOT_CREATE_TIMER = 4108,
   CHART_WRONG_PROPERTY = 4109,
   CHART_SCREENSHOT_FAILED = 4110,
   CHART_NAVIGATE_FAILED = 4111,
   CHART_TEMPLATE_FAILED = 4112,
   CHART_WINDOW_NOT_FOUND = 4113,
   CHART_INDICATOR_CANNOT_ADD = 4114,
   CHART_INDICATOR_CANNOT_DEL = 4115,
   CHART_INDICATOR_NOT_FOUND = 4116,
   // Graphical Objects
   OBJECT_ERROR = 4201,
   OBJECT_NOT_FOUND = 4202,
   OBJECT_WRONG_PROPERTY = 4203,
   OBJECT_GETDATE_FAILED = 4204,
   OBJECT_GETVALUE_FAILED = 4205,
   // MarketInfo
   MARKET_UNKNOWN_SYMBOL = 4301,
   MARKET_NOT_SELECTED = 4302,
   MARKET_WRONG_PROPERTY = 4303,
   MARKET_LASTTIME_UNKNOWN = 4304,
   MARKET_SELECT_ERROR = 4305,
   // History Access
   HISTORY_NOT_FOUND = 4401,
   HISTORY_WRONG_PROPERTY = 4402,
   HISTORY_TIMEOUT = 4403,
   HISTORY_BARS_LIMIT = 4404,
   HISTORY_LOAD_ERRORS = 4405,
   HISTORY_SMALL_BUFFER = 4407,
   // Global_Variables
   GLOBALVARIABLE_NOT_FOUND = 4501,
   GLOBALVARIABLE_EXISTS = 4502,
   GLOBALVARIABLE_NOT_MODIFIED = 4503,
   GLOBALVARIABLE_CANNOTREAD = 4504,
   GLOBALVARIABLE_CANNOTWRITE = 4505,
   MAIL_SEND_FAILED = 4510,
   PLAY_SOUND_FAILED = 4511,
   MQL5_WRONG_PROPERTY = 4512,
   TERMINAL_WRONG_PROPERTY = 4513,
   FTP_SEND_FAILED = 4514,
   NOTIFICATION_SEND_FAILED = 4515,
   NOTIFICATION_WRONG_PARAMETER = 4516,
   NOTIFICATION_WRONG_SETTINGS = 4517,
   NOTIFICATION_TOO_FREQUENT = 4518,
   FTP_NOSERVER = 4519,
   FTP_NOLOGIN = 4520,
   FTP_FILE_ERROR = 4521,
   FTP_CONNECT_FAILED = 4522,
   FTP_CHANGEDIR = 4523,
   FTP_CLOSED = 4524,
   // Custom Indicator Buffers
   BUFFERS_NO_MEMORY = 4601,
   BUFFERS_WRONG_INDEX = 4602,
   // Custom Indicator Properties
   CUSTOM_WRONG_PROPERTY = 4603,
   // Account
   ACCOUNT_WRONG_PROPERTY = 4701,
   TRADE_WRONG_PROPERTY = 4751,
   TRADE_DISABLED = 4752,
   TRADE_POSITION_NOT_FOUND = 4753,
   TRADE_ORDER_NOT_FOUND = 4754,
   TRADE_DEAL_NOT_FOUND = 4755,
   TRADE_SEND_FAILED = 4756,
   TRADE_CALC_FAILED = 4758,
   // Indicators
   INDICATOR_UNKNOWN_SYMBOL = 4801,
   INDICATOR_CANNOT_CREATE = 4802,
   INDICATOR_NO_MEMORY = 4803,
   INDICATOR_CANNOT_APPLY = 4804,
   INDICATOR_CANNOT_ADD = 4805,
   INDICATOR_DATA_NOT_FOUND = 4806,
   INDICATOR_WRONG_HANDLE = 4807,
   INDICATOR_WRONG_PARAMETERS = 4808,
   INDICATOR_PARAMETERS_MISSING = 4809,
   INDICATOR_CUSTOM_NAME = 4810,
   INDICATOR_PARAMETER_TYPE = 4811,
   INDICATOR_WRONG_INDEX = 4812,
   // Depth of Market
   BOOKS_CANNOT_ADD = 4901,
   BOOKS_CANNOT_DELETE = 4902,
   BOOKS_CANNOT_GET = 4903,
   BOOKS_CANNOT_SUBSCRIBE = 4904,
   // File Operations
   TOO_MANY_FILES = 5001,
   WRONG_FILENAME = 5002,
   TOO_LONG_FILENAME = 5003,
   CANNOT_OPEN_FILE = 5004,
   FILE_CACHEBUFFER_ERROR = 5005,
   CANNOT_DELETE_FILE = 5006,
   INVALID_FILEHANDLE = 5007,
   WRONG_FILEHANDLE = 5008,
   FILE_NOTTOWRITE = 5009,
   FILE_NOTTOREAD = 5010,
   FILE_NOTBIN = 5011,
   FILE_NOTTXT = 5012,
   FILE_NOTTXTORCSV = 5013,
   FILE_NOTCSV = 5014,
   FILE_READERROR = 5015,
   FILE_BINSTRINGSIZE = 5016,
   INCOMPATIBLE_FILE = 5017,
   FILE_IS_DIRECTORY = 5018,
   FILE_NOT_EXIST = 5019,
   FILE_CANNOT_REWRITE = 5020,
   WRONG_DIRECTORYNAME = 5021,
   DIRECTORY_NOT_EXIST = 5022,
   FILE_ISNOT_DIRECTORY = 5023,
   CANNOT_DELETE_DIRECTORY = 5024,
   CANNOT_CLEAN_DIRECTORY = 5025,
   FILE_WRITEERROR = 5026,
   FILE_ENDOFFILE = 5027,
   // String Casting
   NO_STRING_DATE = 5030,
   WRONG_STRING_DATE = 5031,
   WRONG_STRING_TIME = 5032,
   STRING_TIME_ERROR = 5033,
   STRING_OUT_OF_MEMORY = 5034,
   STRING_SMALL_LEN = 5035,
   STRING_TOO_BIGNUMBER = 5036,
   WRONG_FORMATSTRING = 5037,
   TOO_MANY_FORMATTERS = 5038,
   TOO_MANY_PARAMETERS = 5039,
   WRONG_STRING_PARAMETER = 5040,
   STRINGPOS_OUTOFRANGE = 5041,
   STRING_ZEROADDED = 5042,
   STRING_UNKNOWNTYPE = 5043,
   WRONG_STRING_OBJECT = 5044,
   // Operations with Arrays
   INCOMPATIBLE_ARRAYS = 5050,
   SMALL_ASSERIES_ARRAY = 5051,
   SMALL_ARRAY = 5052,
   ZEROSIZE_ARRAY = 5053,
   NUMBER_ARRAYS_ONLY = 5054,
   ONEDIM_ARRAYS_ONLY = 5055,
   SERIES_ARRAY = 5056,
   DOUBLE_ARRAY_ONLY = 5057,
   FLOAT_ARRAY_ONLY = 5058,
   LONG_ARRAY_ONLY = 5059,
   INT_ARRAY_ONLY = 5060,
   SHORT_ARRAY_ONLY = 5061,
   CHAR_ARRAY_ONLY = 5062,
   STRING_ARRAY_ONLY = 5063,
   // Operations with OpenCL
   OPENCL_NOT_SUPPORTED = 5100,
   OPENCL_INTERNAL = 5101,
   OPENCL_INVALID_HANDLE = 5102,
   OPENCL_CONTEXT_CREATE = 5103,
   OPENCL_QUEUE_CREATE = 5104,
   OPENCL_PROGRAM_CREATE = 5105,
   OPENCL_TOO_LONG_KERNEL_NAME = 5106,
   OPENCL_KERNEL_CREATE = 5107,
   OPENCL_SET_KERNEL_PARAMETER = 5108,
   OPENCL_EXECUTE = 5109,
   OPENCL_WRONG_BUFFER_SIZE = 5110,
   OPENCL_WRONG_BUFFER_OFFSET = 5111,
   OPENCL_BUFFER_CREATE = 5112,
   OPENCL_TOO_MANY_OBJECTS = 5113,
   OPENCL_SELECTDEVICE = 5114,
   // Working with databases
   DATABASE_INTERNAL_1 = 5120,
   DATABASE_INVALID_HANDLE = 5121,
   DATABASE_TOO_MANY_OBJECTS = 5122,
   DATABASE_CONNECT = 5123,
   DATABASE_EXECUTE = 5124,
   DATABASE_PREPARE = 5125,
   DATABASE_NO_MORE_DATA = 5126,
   DATABASE_STEP = 5127,
   DATABASE_NOT_READY = 5128,
   DATABASE_BIND_PARAMETERS = 5129,
   // Operations with WebRequest
   WEBREQUEST_INVALID_ADDRESS = 5200,
   WEBREQUEST_CONNECT_FAILED = 5201,
   WEBREQUEST_TIMEOUT = 5202,
   WEBREQUEST_REQUEST_FAILED = 5203,
   // Operations with network (sockets)
   NETSOCKET_INVALIDHANDLE = 5270,
   NETSOCKET_TOO_MANY_OPENED = 5271,
   NETSOCKET_CANNOT_CONNECT = 5272,
   NETSOCKET_IO_ERROR = 5273,
   NETSOCKET_HANDSHAKE_FAILED = 5274,
   NETSOCKET_NO_CERTIFICATE = 5275,
   // Custom Symbols
   NOT_CUSTOM_SYMBOL = 5300,
   CUSTOM_SYMBOL_WRONG_NAME = 5301,
   CUSTOM_SYMBOL_NAME_LONG = 5302,
   CUSTOM_SYMBOL_PATH_LONG = 5303,
   CUSTOM_SYMBOL_EXIST = 5304,
   CUSTOM_SYMBOL_ERROR = 5305,
   CUSTOM_SYMBOL_SELECTED = 5306,
   CUSTOM_SYMBOL_PROPERTY_WRONG = 5307,
   CUSTOM_SYMBOL_PARAMETER_ERROR = 5308,
   CUSTOM_SYMBOL_PARAMETER_LONG = 5309,
   CUSTOM_TICKS_WRONG_ORDER = 5310,
   // Economic Calendar
   CALENDAR_MORE_DATA = 5400,
   CALENDAR_TIMEOUT = 5401,
   CALENDAR_NO_DATA = 5402,
   // Working with databases
   DATABASE_ERROR = 5601,
   DATABASE_INTERNAL_2 = 5602,
   DATABASE_PERM = 5603,
   DATABASE_ABORT = 5604,
   DATABASE_BUSY = 5605,
   DATABASE_LOCKED = 5606,
   DATABASE_NOMEM = 5607,
   DATABASE_READONLY = 5608,
   DATABASE_INTERRUPT = 5609,
   DATABASE_IOERR = 5610,
   DATABASE_CORRUPT = 5611,
   DATABASE_NOTFOUND = 5612,
   DATABASE_FULL = 5613,
   DATABASE_CANTOPEN = 5614,
   DATABASE_PROTOCOL = 5615,
   DATABASE_EMPTY = 5616,
   DATABASE_SCHEMA = 5617,
   DATABASE_TOOBIG = 5618,
   DATABASE_CONSTRAINT = 5619,
   DATABASE_MISMATCH = 5620,
   DATABASE_MISUSE = 5621,
   DATABASE_NOLFS = 5622,
   DATABASE_AUTH = 5623,
   DATABASE_FORMAT = 5624,
   DATABASE_RANGE = 5625,
   DATABASE_NOTADB = 5626,
   // User-Defined Errors
   USER_ERROR_FIRST = 65536,
};

#define E2S(X) EnumToString((MQL_ERROR)(X))
//+------------------------------------------------------------------+
