//+--------------------------------------------------------------------+
//| Copyright 2024, StormWave Technologies                             |
//| https://stormwave.co/                                              |
//| https://stormwave.ai/                                              |
//|                                                                    |
//| StormWave Investments Technologies delivers advanced software      |
//| and solutions for both short and medium to long-term investments.  |
//| Our automated systems use sophisticated algorithms and predictive  |
//| analysis to identify profitable opportunities and minimize risks.  |
//| With cutting-edge technology and expert support, we offer reliable |
//| and customized solutions tailored to our clients' needs.           |
//|                                                                    |
//| CDebugLogger Class                                                 |
//|                                                                    |
//| This class provides a flexible logging system for MQL4/5,          |
//| allowing developers to log messages with varying levels of         |
//| importance and detail. The logger supports logging to both the     |
//| console and a file, with options to include timestamps, function   |
//| signatures, file names, and line numbers in log messages.          |
//|                                                                    |
//| Features:                                                          |
//| - Log messages at different levels (INFO, WARNING, ERROR, DEBUG)   |
//| - Optionally include timestamps in log messages                    |
//| - Optionally log to a file with support for saving in a common     |
//|   folder                                                           |
//| - Silence logs based on specific keywords                          |
//| - Filter logs based on specific keywords                           |
//| - Optionally include function signatures, file names, and line     |
//|   numbers in log entries                                           |
//| - Option to save logs in CSV format                                |
//|                                                                    |
//| Example Usage:                                                     |
//|                                                                    |
//|   // Initialize the logger with INFO level logging to a file       |
//|   CDebugLogger logger(INFO, true, "log.txt", true, TIME_DATE |     |
//|                      TIME_MINUTES, false, true, true, true);       |
//|                                                                    |
//|   // Log a simple message                                          |
//|   logger.Log(INFO, "This is an info message");                     |
//|                                                                    |
//|   // Silence a keyword                                             |
//|   logger.AddSilentKeyword("password");                             |
//|                                                                    |
//|   // Log a message that will be silenced                           |
//|   logger.Log(INFO, "User entered password: 1234");                 |
//|                                                                    |
//|   // Enable file logging                                           |
//|   logger.EnableFileLogging(true, "debug.log", false);              |
//|                                                                    |
//|   // Remove a silenced keyword                                     |
//|   logger.RemoveSilentKeyword("password");                          |
//|                                                                    |
//|   // Log a message after removing the keyword from the silence     |
//|   // list                                                          |
//|   logger.Log(INFO, "User entered password: 1234");                 |
//|                                                                    |
//|   // Add a keyword to filter logs                                  |
//|   logger.AddFilterKeyword("success");                              |
//|                                                                    |
//|   // Log a message that will be filtered out                       |
//|   logger.Log(INFO, "Operation failed");                            |
//|                                                                    |
//|   // Log a message that will pass the filter                       |
//|   logger.Log(INFO, "Operation successful");                        |
//|                                                                    |
//|   // Remove a keyword from the filter                              |
//|   logger.RemoveFilterKeyword("success");                           |
//|                                                                    |
//|   // Initialize using the generic Log function                     |
//|   logging.Initialize(WARNING, true, "warnings.log", true,          |
//|                      TIME_SECONDS, true, false, true, true);       |
//|                                                                    |
//|   // Log a warning using the generic Log function                  |
//|   Log(WARNING, "This is a warning message");                       |
//|                                                                    |
//+--------------------------------------------------------------------+
#property copyright "Copyright 2024, StormWave Technologies"
#property link      "https://stormwave.co/"
#property version   "1.00"
//+------------------------------------------------------------------+
//|                                                  Example Script  |
//|                                                                  |
//| This script demonstrates how to use the CDebugLogger class for   |
//| logging messages at various levels within the OnStart function.  |
//| It initializes the logger, logs different types of messages,     |
//| and manages silent keywords.                                     |
//+------------------------------------------------------------------+

//--- Include the necessary header files
#include <Logging.mqh>  


//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
{
   //--- Initialize the logger with INFO level, logging to a file
   //--- Including timestamps and saving in CSV format
   int log_options = 0; // FILENAME | LINE | FUNCSIG;
   logging.Initialize(INFO, true, "example_log.txt", true, TIME_DATE | TIME_MINUTES | TIME_SECONDS, false, log_options, false);

   //--- Log a simple informational message
   Log(INFO, "Script started successfully.");

   //--- Log a warning message
   Log(WARNING, "This is a warning message.");

   //--- Log an error message
   Log(ERROR, "This is an error message.");

   //--- Log a debug message
   Log(DEBUG, "This is a debug message for debugging purposes.");

   //--- Add a keyword to silence logs containing 'password'
   logging.AddSilentKeyword("password");

   //--- Attempt to log a message containing the silenced keyword
   Log(INFO, "User entered password: 12348"); // This message will be silenced

   //--- Remove the silenced keyword
   logging.RemoveSilentKeyword("password");

   //--- Log the message again, now it will be logged
   Log(INFO, "User entered password: 1234");

   //--- Use the generic Log function to log a message
   Log(INFO, "This message is logged using the generic Log function.");

   //--- Use the Print macro to log a message at the INFO level
   Print("This message is logged using the Print macro.");

   //--- Demonstrate logging with different combinations of options
   logging.Initialize(INFO, true, "log_with_options.txt", true, TIME_DATE | TIME_MINUTES, false, FILENAME | LINE, true);
   Log(INFO, "This log includes only the file name and line number.");

   logging.Initialize(INFO, true, "log_with_funcsig.txt", true, TIME_DATE | TIME_MINUTES | TIME_SECONDS, false, FUNCSIG, true);
   Log(INFO, "This log includes only the function signature.");

   logging.Initialize(INFO, true, "log_custom_order.txt", true, TIME_MINUTES, false, LINE | FILENAME | FUNCSIG, true);
   Log(INFO, "This log includes line number, file name, and function signature in a custom order.");

   //--- Add a keyword to filter logs containing 'important'
   logging.AddFilterKeyword("important");

   //--- Log some messages to demonstrate the filter
   Log(INFO, "This is an important message."); // This message will be visible
   Log(INFO, "This is a regular message.");    // This message will not be visible

   //--- Remove the filter keyword to show all logs
   logging.RemoveFilterKeyword("important");

   //--- Log a final message indicating the end of the script
   Log(INFO, "Script execution completed.");
}
//+------------------------------------------------------------------+